/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Main;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.logging.FileLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.interlis2.validator.UpdateIliDataTool;
import org.interlis2.validator.Validator;

public class CheckRepoDataTool {
    public static boolean launch(Settings settings) {
        return new CheckRepoDataTool().checkRepoData(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRepoData(Settings settings) {
        FileLogger logfile;
        block20: {
            boolean bl;
            block19: {
                logfile = null;
                try {
                    IomObject[] actualIliDatas;
                    String repository;
                    String logFilename = settings.getValue("org.interlis2.validator.log");
                    if (logFilename != null) {
                        File f = new File(logFilename);
                        try {
                            if (!Validator.isWriteable(f)) throw new Exception("failed to write to logfile <" + f.getPath() + ">");
                            logfile = new FileLogger(f);
                            EhiLogger.getInstance().addListener((LogListener)logfile);
                        }
                        catch (IOException e) {
                            throw new Exception("failed to write to logfile <" + f.getPath() + ">", e);
                        }
                    }
                    if ((repository = settings.getValue("org.interlis2.validator.baseUrl")) == null) throw new Exception("Repository should be given as a parameter!");
                    if (repository.isEmpty()) {
                        throw new Exception("Repository should be given as a parameter!");
                    }
                    Main.setHttpProxySystemProperties((Settings)settings);
                    RepositoryAccess reposAccess = new RepositoryAccess();
                    File localCopyOfRemoteOriginalIliDataXml = reposAccess.getLocalFileLocation(repository, "ilidata.xml", 0L, null);
                    if (localCopyOfRemoteOriginalIliDataXml == null) {
                        throw new Exception("ilidata.xml could not be found in <" + repository + ">");
                    }
                    IomObject[] ilidataContents = UpdateIliDataTool.readIliData(localCopyOfRemoteOriginalIliDataXml);
                    if (ilidataContents == null) {
                        throw new Exception("Contents of the ilidata.xml should not be empty!");
                    }
                    ArrayList<String> failedFiles = new ArrayList<String>();
                    for (IomObject currentObj : actualIliDatas = this.findActualIliDatas(ilidataContents)) {
                        boolean runValidation;
                        String tid = currentObj.getobjectoid();
                        EhiLogger.traceState((String)("validate TID <" + tid + ">"));
                        IomObject files = currentObj.getattrobj("files", 0);
                        if (files == null) {
                            EhiLogger.logError((String)("TID " + tid + ": missing " + "files"));
                        }
                        IomObject file = null;
                        if (files != null && (file = files.getattrobj("file", 0)) == null) {
                            EhiLogger.logError((String)("TID " + tid + ": missing " + "file"));
                        }
                        String filepath = null;
                        if (file != null && (filepath = file.getattrvalue("path")) == null) {
                            EhiLogger.logError((String)("TID " + tid + ": missing " + "path"));
                        }
                        File localCopyOfRemoteFile = null;
                        if (filepath != null && (localCopyOfRemoteFile = reposAccess.getLocalFileLocation(repository, filepath, 0L, null)) == null) {
                            EhiLogger.logError((String)("TID " + tid + ": " + filepath + " could not be found in <" + repository + ">"));
                            failedFiles.add(filepath);
                        }
                        if (localCopyOfRemoteFile == null || (runValidation = Validator.runValidation(new String[]{localCopyOfRemoteFile.getAbsolutePath()}, null))) continue;
                        failedFiles.add(filepath);
                    }
                    if (!failedFiles.isEmpty()) {
                        StringBuilder failed = new StringBuilder();
                        String sep = "";
                        for (String f : failedFiles) {
                            failed.append(sep);
                            failed.append(f);
                            sep = ", ";
                        }
                        EhiLogger.logError((String)("validation failed with files: " + failed));
                        bl = false;
                        if (logfile == null) return bl;
                        break block19;
                    }
                    if (logfile == null) return true;
                    break block20;
                }
                catch (Exception e) {
                    EhiLogger.logError((Throwable)e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            logfile.close();
            EhiLogger.getInstance().removeListener((LogListener)logfile);
            return bl;
        }
        logfile.close();
        EhiLogger.getInstance().removeListener((LogListener)logfile);
        return true;
        finally {
            if (logfile != null) {
                logfile.close();
                EhiLogger.getInstance().removeListener(logfile);
                logfile = null;
            }
        }
    }

    public IomObject[] findActualIliDatas(IomObject[] ilidataContents) throws Exception {
        HashMap<String, List<IomObject>> actualIliDatas = new HashMap<String, List<IomObject>>();
        try {
            for (IomObject currentIomObj : ilidataContents) {
                if (!currentIomObj.getobjecttag().equals("DatasetIdx16.DataIndex.DatasetMetadata")) continue;
                String currentID = currentIomObj.getattrvalue("id");
                String currentpreVersion = currentIomObj.getattrvalue("precursorVersion");
                if (currentpreVersion == null || currentpreVersion.isEmpty()) {
                    this.appendNewIomObj(actualIliDatas, currentIomObj, currentID);
                    continue;
                }
                List iomObj = (List)actualIliDatas.get(currentID);
                if (iomObj == null || iomObj.isEmpty()) {
                    ArrayList objectList = new ArrayList();
                    actualIliDatas.put(currentID, objectList);
                    continue;
                }
                this.appendNewIomObj(actualIliDatas, currentIomObj, currentID);
                String[] precursorValues = this.findAllPrecursorVersions(iomObj);
                if (precursorValues == null) continue;
                for (int i = 0; i < iomObj.size(); ++i) {
                    String currentVersionName = ((IomObject)iomObj.get(i)).getattrvalue("version");
                    for (String preValue : precursorValues) {
                        if (!preValue.equals(currentVersionName)) continue;
                        iomObj.remove(i);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        ArrayList<IomObject> returnValues = new ArrayList<IomObject>();
        for (List values : actualIliDatas.values()) {
            for (IomObject iomObj : values) {
                returnValues.add(iomObj);
            }
        }
        return returnValues.toArray(new IomObject[returnValues.size()]);
    }

    private String[] findAllPrecursorVersions(List<IomObject> iomObj) {
        ArrayList<String> returnPreValues = new ArrayList<String>();
        for (int i = 0; i < iomObj.size(); ++i) {
            String tmpPrecursor = iomObj.get(i).getattrvalue("precursorVersion");
            if (tmpPrecursor == null) continue;
            returnPreValues.add(tmpPrecursor);
        }
        return returnPreValues.toArray(new String[returnPreValues.size()]);
    }

    private void appendNewIomObj(Map<String, List<IomObject>> actualIliDatas, IomObject currentIomObj, String currentID) {
        List<IomObject> iomObj = actualIliDatas.get(currentID);
        if (iomObj == null) {
            iomObj = new ArrayList<IomObject>();
        }
        iomObj.add(currentIomObj);
        actualIliDatas.put(currentID, iomObj);
    }
}

