/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.models.DATASETIDX16;
import ch.interlis.models.DatasetIdx16.Code_;
import ch.interlis.models.DatasetIdx16.DataFile;
import ch.interlis.models.DatasetIdx16.DataIndex.BasketMetadata;
import ch.interlis.models.DatasetIdx16.DataIndex.DatasetMetadata;
import ch.interlis.models.DatasetIdx16.LocalisedMText;
import ch.interlis.models.DatasetIdx16.LocalisedText;
import ch.interlis.models.DatasetIdx16.ModelLink;
import ch.interlis.models.DatasetIdx16.MultilingualMText;
import ch.interlis.models.DatasetIdx16.MultilingualText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.interlis2.validator.Main;
import org.interlis2.validator.Validator;

@Deprecated
public class CreateIliDataTool {
    private static final String CODES_GEOIV = "https://ids.geo.admin.ch/geoiv/";
    private static final String CODES_MODEL = "http://codes.interlis.ch/model/";
    private static final String CODES_TYPE_REFERENCE_DATA = "http://codes.interlis.ch/type/referenceData";

    public static boolean start(Settings settings) {
        EhiLogger.logAdaption((String)"please use the new ilimanager tool");
        return new CreateIliDataTool().createIliData(settings);
    }

    private boolean createIliData(Settings settings) {
        String destinationFile = settings.getValue("org.interlis2.validator.ilidata");
        String filelistFile = settings.getValue("org.interlis2.validator.filelist");
        String baseUrl = settings.getValue("org.interlis2.validator.baseUrl");
        ch.interlis.ili2c.Main.setHttpProxySystemProperties(settings);
        try {
            HashSet<File> filelist = new HashSet<File>();
            if (filelistFile != null) {
                this.readFilelistFromFile(filelistFile, filelist);
            } else {
                File localFolder = new File(baseUrl);
                if (!(localFolder.exists() && localFolder.isDirectory() && localFolder.canRead())) {
                    EhiLogger.logError((String)("can't read repos folder <" + baseUrl + ">"));
                    return false;
                }
                this.scanLocalFolder(localFolder, null, filelist);
            }
            this.readFilesFromSourceFolder(new File(destinationFile), filelist, baseUrl, settings);
        }
        catch (Exception e) {
            EhiLogger.logError((Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFilesFromSourceFolder(File destFile, Set<File> allFiles, String baseUrl, Settings settings) throws Exception {
        XtfWriterBase ioxWriter = null;
        try {
            FileOutputStream outStream = new FileOutputStream(destFile.getPath());
            XtfWriterBase ioxWriter1 = new XtfWriterBase((OutputStream)outStream, DATASETIDX16.getIoxMapping(), "2.3");
            ioxWriter1.setModels(new XtfModel[]{DATASETIDX16.getXtfModel()});
            StartTransferEvent startTransferEvent = new StartTransferEvent();
            startTransferEvent.setSender("ilivalidator-" + Main.getVersion());
            ioxWriter1.write((IoxEvent)startTransferEvent);
            ioxWriter = ioxWriter1;
            StartBasketEvent startBasketEvent = new StartBasketEvent("DatasetIdx16.DataIndex", "b1");
            ioxWriter.write((IoxEvent)startBasketEvent);
            int oid = this.getStartTid(settings);
            String defaultVersion = this.getDefaultVersion(settings);
            boolean addReferenceDataTag = true;
            for (File currentFile : allFiles) {
                String version = defaultVersion;
                StringBuffer versionBuf = new StringBuffer();
                CreateIliDataTool.getFileNameWithoutPfadExtensionAndDate(currentFile, versionBuf);
                if (versionBuf.length() > 0) {
                    version = versionBuf.toString();
                }
                DatasetMetadata datasetMetadata = this.generateNewDatasetMetaData(currentFile, settings, baseUrl, version, oid++, addReferenceDataTag);
                ioxWriter.write((IoxEvent)new ObjectEvent((IomObject)datasetMetadata));
            }
        }
        finally {
            if (ioxWriter != null) {
                ioxWriter.write((IoxEvent)new EndBasketEvent());
                ioxWriter.write((IoxEvent)new EndTransferEvent());
                ioxWriter.close();
            }
        }
    }

    private String getDefaultVersion(Settings settings) {
        return "1";
    }

    private int getStartTid(Settings settings) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatasetMetadata generateNewDatasetMetaData(File currentFile, Settings settings, String baseUrl, String version, int oid, boolean addReferenceDataTag) throws Exception {
        IoxReader ioxReader = null;
        DatasetMetadata datasetMetadata = new DatasetMetadata(Integer.toString(oid));
        ch.interlis.models.DatasetIdx16.File file = new ch.interlis.models.DatasetIdx16.File();
        DataFile dataFile = new DataFile();
        String filePath = CreateIliDataTool.getURLRelativePath(currentFile);
        file.setpath(filePath);
        dataFile.addfile(file);
        datasetMetadata.addfiles(dataFile);
        CreateIliDataTool.setTitle(datasetMetadata, currentFile);
        String id = CreateIliDataTool.getDatasetId(currentFile, baseUrl, settings);
        datasetMetadata.setid(id);
        String owner = CreateIliDataTool.getOwner(settings);
        datasetMetadata.setowner(owner);
        datasetMetadata.setversion(version);
        RepositoryAccess reposAccess = null;
        File localFile = null;
        if (CreateIliDataTool.isRemoteRepository(baseUrl)) {
            reposAccess = new RepositoryAccess();
            localFile = reposAccess.getLocalFileLocation(baseUrl, CreateIliDataTool.getURLRelativePath(currentFile), 0L, null);
            if (localFile == null) {
                throw new IllegalStateException("failed to download remote file " + baseUrl + " " + currentFile.getPath());
            }
        } else {
            localFile = new File(new File(baseUrl), currentFile.getPath());
        }
        Log2EhiLogger errHandler = new Log2EhiLogger();
        LogEventFactory errFactory = new LogEventFactory();
        errFactory.setLogger((IoxLogging)errHandler);
        List models = IoxUtility.getModels((File)localFile);
        String modelVersion = IoxUtility.getModelVersion((String[])new String[]{localFile.getPath()}, (LogEventFactory)errFactory);
        TransferDescription td = null;
        try {
            td = Validator.compileIli(modelVersion, models, null, localFile.getAbsoluteFile().getParentFile().getAbsolutePath(), Main.getAppHome(), settings);
        }
        catch (Exception e) {
            throw new Exception("Failed to read file <" + localFile.getAbsolutePath() + ">", e);
        }
        if (td == null) {
            throw new Exception("Transfer Description can not be null for the file: " + localFile.getAbsolutePath());
        }
        String md5 = RepositoryAccess.calcMD5(localFile);
        file.setmd5(md5);
        ioxReader = CreateIliDataTool.createReader(localFile);
        if (ioxReader instanceof IoxIliReader) {
            dataFile.setfileFormat(((IoxIliReader)ioxReader).getMimeType());
        } else {
            dataFile.setfileFormat("application/interlis+xml;version=2.3");
        }
        try {
            IoxEvent event = null;
            Model model = null;
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                StartBasketEvent basketEvent = (StartBasketEvent)event;
                BasketMetadata basketMetaData = new BasketMetadata();
                Topic topic = (Topic)td.getElement(basketEvent.getType());
                if (model == null) {
                    String technicalContact;
                    model = (Model)topic.getContainer();
                    String furtherInformation = model.getMetaValue("furtherInformation");
                    if (furtherInformation != null) {
                        datasetMetadata.setfurtherInformation(furtherInformation);
                    }
                    if ((technicalContact = model.getMetaValue("technicalContact")) != null) {
                        datasetMetadata.settechnicalContact(technicalContact);
                    }
                    if (addReferenceDataTag) {
                        Code_ referenceDataCode = new Code_();
                        referenceDataCode.setvalue(CODES_TYPE_REFERENCE_DATA);
                        datasetMetadata.addcategories(referenceDataCode);
                        if (reposAccess != null) {
                            this.addModelCodes(datasetMetadata, model, reposAccess.getIliFiles(baseUrl));
                        }
                    }
                }
                ModelLink modelLink = new ModelLink();
                modelLink.setname(basketEvent.getType());
                basketMetaData.setmodel(modelLink);
                basketMetaData.setowner(owner);
                basketMetaData.setversion(version);
                if (topic.getBasketOid() != null) {
                    basketMetaData.setid(basketEvent.getBid());
                } else {
                    basketMetaData.setlocalId(basketEvent.getBid());
                }
                datasetMetadata.addbaskets(basketMetaData);
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (ioxReader != null) {
                try {
                    ioxReader.close();
                }
                catch (Exception e) {
                    EhiLogger.logState((String)("An error occurred while closing the file." + e));
                }
                ioxReader = null;
            }
        }
        return datasetMetadata;
    }

    private static String getDatasetId(File currentFile, String baseUrl, Settings settings) throws MalformedURLException {
        String id = CreateIliDataTool.getFileNameWithoutPfadExtensionAndDate(currentFile, null);
        if (CreateIliDataTool.isRemoteRepository(baseUrl)) {
            URL url = new URL(baseUrl);
            String[] domains = url.getHost().split("\\.");
            StringBuffer domainName = new StringBuffer();
            String sep = "";
            for (int i = domains.length - 1; i >= 0; --i) {
                domainName.append(sep);
                domainName.append(domains[i]);
                sep = ".";
            }
            id = domainName + "." + id;
        }
        return id;
    }

    private void addModelCodes(DatasetMetadata datasetMetadata, Model modelx, IliFiles ilifiles) {
        String modelName = modelx.getName();
        double iliVersion = Double.parseDouble(modelx.getIliVersion());
        ArrayList<String> useModels = new ArrayList<String>();
        Iterator<IliFile> filei = ilifiles.iteratorFile();
        while (filei.hasNext()) {
            IliFile ilifile = filei.next();
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                if (model.getIliVersion() != iliVersion) continue;
                for (String dep : model.getDependencies()) {
                    if (!dep.equals(modelName) || useModels.contains(model.getName())) continue;
                    useModels.add(model.getName());
                }
            }
        }
        for (String model : useModels) {
            if ("INTERLIS".equals(model)) continue;
            Code_ modelCode = new Code_();
            modelCode.setvalue(CODES_MODEL + model);
            datasetMetadata.addcategories(modelCode);
        }
    }

    protected static String getOwner(Settings settings) {
        return "mailto:models@geo.admin.ch";
    }

    private static boolean isRemoteRepository(String uri) {
        String urilc = uri.toLowerCase();
        return urilc.startsWith("http:") || urilc.startsWith("https:");
    }

    protected static void setShortDescription(DatasetMetadata datasetMetadata, String documentation, String name) {
        if (documentation != null || name != null) {
            MultilingualMText mText = new MultilingualMText();
            LocalisedMText localisedMText = new LocalisedMText();
            if (documentation != null) {
                localisedMText.setText(documentation);
            } else {
                localisedMText.setText(name);
            }
            mText.addLocalisedText(localisedMText);
            datasetMetadata.setshortDescription(mText);
        }
    }

    protected static void setTitle(DatasetMetadata datasetMetadata, File currentFile) {
        if (currentFile != null) {
            String amt = currentFile.getParent();
            String name = CreateIliDataTool.getFileNameWithoutPfadExtensionAndDate(currentFile, null);
            MultilingualText mText = new MultilingualText();
            LocalisedText localisedMText = new LocalisedText();
            localisedMText.setText("Katalog " + amt + " " + name);
            mText.addLocalisedText(localisedMText);
            datasetMetadata.settitle(mText);
        }
    }

    protected static String getFileNameWithoutPfadExtensionAndDate(File currentFile, StringBuffer version) throws IllegalArgumentException {
        String filenameTmp;
        String pattern;
        Pattern compiledPattern;
        Matcher matcher;
        String filename = currentFile.getName();
        if (filename.endsWith(".xml")) {
            filename = filename.replace(".xml", "");
        } else if (filename.endsWith(".xtf")) {
            filename = filename.replace(".xtf", "");
        } else if (filename.endsWith(".itf")) {
            filename = filename.replace(".itf", "");
        } else {
            throw new IllegalArgumentException("Invalid file extension " + filename);
        }
        filename.trim();
        if (filename.length() > 10 && (matcher = (compiledPattern = Pattern.compile(pattern = "^[_][0-9]{8}$")).matcher(filenameTmp = filename.substring(filename.length() - 9, filename.length()))).matches()) {
            if (version != null) {
                version.append(filename.substring(filename.length() - 8).trim());
            }
            filename = filename.substring(0, filename.length() - 9).trim();
        }
        return filename;
    }

    protected static String getURLRelativePath(File currentFile) {
        return currentFile.getPath().replace(File.separatorChar, '/');
    }

    private void scanLocalFolder(File baseFolder, String subFolder, Set<File> visitedFiles) {
        File[] listOfFiles;
        File expectedFilePath = subFolder == null ? baseFolder : new File(baseFolder, subFolder);
        for (File file : listOfFiles = expectedFilePath.listFiles()) {
            String relativeFileName;
            String string = relativeFileName = subFolder == null ? file.getName() : subFolder + "/" + file.getName();
            if (file.isFile()) {
                if (!this.isItfORXtfFilename(file.getName())) continue;
                visitedFiles.add(new File(relativeFileName));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.scanLocalFolder(baseFolder, relativeFileName, visitedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFilelistFromFile(String srcFile, Set<File> filelist) throws IOException, FileNotFoundException {
        BufferedReader br = null;
        try {
            String readFile;
            br = new BufferedReader(new FileReader(srcFile));
            while ((readFile = br.readLine()) != null) {
                filelist.add(new File(readFile));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    protected static IoxReader createReader(File filename) throws IoxException {
        IoxReader ioxReader = new ReaderFactory().createReader(filename, new LogEventFactory());
        if (ioxReader instanceof ItfReader2) {
            ioxReader = new ItfReader(filename);
        }
        return ioxReader;
    }

    private boolean isItfORXtfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "itf".equals(xtfExt) || "xtf".equals(xtfExt);
    }
}

