/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.iox.ilisite.ILIREPOSITORY09;
import ch.ehi.iox.ilisite.ILISITE09;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata_SchemaLanguage;
import ch.ehi.iox.ilisite.IliSite09.RepositoryLocation_;
import ch.ehi.iox.ilisite.IliSite09.SiteMetadata.Site;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliResolver;
import ch.interlis.ilirepository.IliSite;
import ch.interlis.ilirepository.impl.ModelMetadata;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.models.DATASETIDX16;
import ch.interlis.models.DatasetIdx16.DataIndex.DatasetMetadata;
import ch.interlis.models.DatasetIdx16.DataIndex.Metadata;
import ch.interlis.models.ILIREPOSITORY20;
import ch.interlis.models.IliRepository20.ModelName_;
import ch.interlis.models.IliRepository20.WebService_;
import ch.interlis.models.IliRepository20.WebSite_;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RepositoryAccess {
    public static final String ILI_CACHE = "ILI_CACHE";
    public static final String ILI_CACHE_FILENAME = "ILI_CACHE_FILENAME";
    public static final String ILI_CACHE_FILENAME_MD5 = "MD5";
    private HashMap<String, IliFiles> reposIliFiles = new HashMap();
    private HashMap<String, List<DatasetMetadata>> reposIliData = new HashMap();
    private HashMap<String, IliSite> reposIliSite = new HashMap();
    private long metaMaxTTL = 86400000L;
    private File localCache = null;
    private IliResolver resolver = null;
    private boolean doHashedFilenames = false;
    private static final String REGEX_ILI_NAME = "[a-zA-Z]([a-zA-Z0-9_]*)";

    public RepositoryAccess() {
        String userDefinedCacheFolder = System.getenv(ILI_CACHE);
        this.localCache = userDefinedCacheFolder != null && userDefinedCacheFolder.trim().length() > 0 ? new File(userDefinedCacheFolder) : new File(System.getProperty("user.home"), ".ilicache");
        String hashedFilenames = System.getenv(ILI_CACHE_FILENAME);
        if (hashedFilenames != null && hashedFilenames.equalsIgnoreCase(ILI_CACHE_FILENAME_MD5)) {
            this.doHashedFilenames = true;
        }
    }

    public IliResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IliResolver resolver) {
        this.resolver = resolver;
    }

    public void setCache(File localdir) {
        this.localCache = localdir;
    }

    public void setIliFiles(String uri, IliFiles iliFiles) {
        this.reposIliFiles.put(uri, iliFiles);
    }

    public IliFiles getIliFiles(String uri) {
        IliFiles iliFiles;
        if (!this.reposIliFiles.containsKey(uri)) {
            if (this.isLegacyDir(uri)) {
                try {
                    EhiLogger.traceState((String)("scan ili-files in folder <" + uri + ">..."));
                    HashSet files = ModelScan.scanIliFileDir(new File(uri), null);
                    Iterator filei = files.iterator();
                    IliFiles iliFiles2 = new IliFiles();
                    while (filei.hasNext()) {
                        iliFiles2.addFile((IliFile)filei.next());
                    }
                    this.reposIliFiles.put(uri, iliFiles2);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                EhiLogger.traceState((String)("read ilimodels.xml from <" + uri + ">..."));
                iliFiles = this.readIlimodelsXmlAsIliFiles(uri);
            }
            catch (RepositoryAccessException e) {
                this.handleRepositoryAccessException(e, uri);
                iliFiles = null;
            }
            this.reposIliFiles.put(uri, iliFiles);
        }
        iliFiles = this.reposIliFiles.get(uri);
        return iliFiles;
    }

    @Deprecated
    public IliFiles getModelMetadata(String uri) {
        return this.getIliFiles(uri);
    }

    public List<DatasetMetadata> getIliData(String uri) {
        List<DatasetMetadata> iliFiles;
        if (!this.reposIliData.containsKey(uri)) {
            try {
                EhiLogger.traceState((String)("read ilidata.xml from <" + uri + ">..."));
                iliFiles = this.readIliDataXmlLatest(uri);
            }
            catch (RepositoryAccessException e) {
                this.handleRepositoryAccessException(e, uri);
                iliFiles = null;
            }
            this.reposIliData.put(uri, iliFiles);
        }
        iliFiles = this.reposIliData.get(uri);
        return iliFiles;
    }

    public IliSite getIliSite(String uri) {
        IliSite iliSite;
        if (!this.reposIliSite.containsKey(uri)) {
            try {
                EhiLogger.traceState((String)("read ilisite.xml from <" + uri + ">..."));
                iliSite = this.readIliSiteXml(uri);
            }
            catch (RepositoryAccessException e) {
                this.handleRepositoryAccessException(e, uri);
                iliSite = null;
            }
            this.reposIliSite.put(uri, iliSite);
        }
        iliSite = this.reposIliSite.get(uri);
        return iliSite;
    }

    private void handleRepositoryAccessException(RepositoryAccessException e, String uri) {
        if (this.reposIliSite.containsKey(uri) && this.reposIliFiles.containsKey(uri)) {
            return;
        }
        EhiLogger.logAdaption((String)("repository <" + uri + "> ignored; " + RepositoryAccess.toString(e)));
        if (!this.reposIliSite.containsKey(uri)) {
            this.reposIliSite.put(uri, null);
        }
        if (this.reposIliFiles.containsKey(uri)) {
            this.reposIliFiles.put(uri, null);
        }
    }

    public static String toString(Throwable ex) {
        Exception exTarget;
        Throwable exTarget2;
        StringBuilder ret = new StringBuilder();
        String msg = ex.getLocalizedMessage();
        if (msg != null && (msg = msg.trim()).length() == 0) {
            msg = null;
        }
        if (msg == null) {
            msg = ex.getClass().getName();
        }
        ret.append(msg);
        Throwable ex2 = ex.getCause();
        if (ex2 != null) {
            ret.append("; ");
            ret.append(RepositoryAccess.toString(ex2));
        }
        if (ex instanceof SQLException && (exTarget2 = ((SQLException)(exTarget = (SQLException)ex)).getNextException()) != null) {
            ret.append("; ");
            ret.append(RepositoryAccess.toString(exTarget2));
        }
        if (ex instanceof InvocationTargetException && (exTarget2 = ((InvocationTargetException)(exTarget = (InvocationTargetException)ex)).getTargetException()) != null) {
            ret.append("; ");
            ret.append(RepositoryAccess.toString(exTarget2));
        }
        return ret.toString();
    }

    private boolean isLegacyDir(String uri) {
        String urilc = uri.toLowerCase();
        if (urilc.startsWith("http:") || urilc.startsWith("https:")) {
            return false;
        }
        File file = new File(uri, "ilimodels.xml");
        return !file.exists();
    }

    @Deprecated
    public static IliFiles createIliFiles(String uri, Collection<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelv) throws RepositoryAccessException {
        HashMap models = new HashMap();
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model : modelv) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        IliFiles ret = new IliFiles();
        HashMap<String, IliFile> files = new HashMap<String, IliFile>();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            if (modelVersions == null) continue;
            ModelMetadata_SchemaLanguage[] cslv = new ModelMetadata_SchemaLanguage[]{ModelMetadata_SchemaLanguage.ili1, ModelMetadata_SchemaLanguage.ili2_2, ModelMetadata_SchemaLanguage.ili2_3};
            for (int csli = 0; csli < cslv.length; ++csli) {
                ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model = RepositoryAccess.getCslVersion(modelVersions, cslv[csli]);
                if (model == null) continue;
                String filename = model.getFile();
                IliFile ilifile = null;
                if (!files.containsKey(filename)) {
                    ilifile = new IliFile();
                    ilifile.setPath(filename);
                    ilifile.setRepositoryUri(uri);
                    files.put(filename, ilifile);
                    ret.addFile(ilifile);
                } else {
                    ilifile = (IliFile)files.get(filename);
                }
                IliModel iliModel = new IliModel();
                ModelMetadata_SchemaLanguage csl = model.getSchemaLanguage();
                if (csl == ModelMetadata_SchemaLanguage.ili1) {
                    iliModel.setIliVersion(1.0);
                } else if (csl == ModelMetadata_SchemaLanguage.ili2_2) {
                    iliModel.setIliVersion(2.2);
                } else if (csl == ModelMetadata_SchemaLanguage.ili2_3) {
                    iliModel.setIliVersion(2.3);
                }
                iliModel.setName(model.getName());
                ch.ehi.iox.ilisite.IliRepository09.ModelName_[] deps = model.getdependsOnModel();
                for (int depi = 0; depi < deps.length; ++depi) {
                    String depName = StringUtility.purge((String)deps[depi].getvalue());
                    if (depName == null) continue;
                    iliModel.addDepenedency(depName);
                }
                ilifile.addModel(iliModel);
            }
        }
        return ret;
    }

    public static IliFiles createIliFiles2(String uri, Collection<ModelMetadata> modelv) throws RepositoryAccessException {
        HashMap models = new HashMap();
        for (ModelMetadata model : modelv) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        IliFiles ret = new IliFiles();
        HashMap<String, IliFile> files = new HashMap<String, IliFile>();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            if (modelVersions == null) continue;
            String[] cslv = ModelMetadata.all;
            for (int csli = 0; csli < cslv.length; ++csli) {
                ModelMetadata model = RepositoryAccess.getCslVersion2(modelVersions, cslv[csli]);
                if (model == null) continue;
                String filename = model.getFile();
                IliFile ilifile = null;
                if (!files.containsKey(filename)) {
                    ilifile = new IliFile();
                    ilifile.setPath(filename);
                    ilifile.setRepositoryUri(uri);
                    files.put(filename, ilifile);
                    ret.addFile(ilifile);
                } else {
                    ilifile = (IliFile)files.get(filename);
                }
                IliModel iliModel = new IliModel();
                String csl = model.getSchemaLanguage();
                if (csl.equals("ili1")) {
                    iliModel.setIliVersion(1.0);
                } else if (csl.equals("ili2_2")) {
                    iliModel.setIliVersion(2.2);
                } else if (csl.equals("ili2_3")) {
                    iliModel.setIliVersion(2.3);
                } else if (csl.equals("ili2_4")) {
                    iliModel.setIliVersion(2.4);
                }
                iliModel.setName(model.getName());
                String[] deps = model.getDependsOnModel();
                for (int depi = 0; depi < deps.length; ++depi) {
                    String depName = StringUtility.purge((String)deps[depi]);
                    if (depName == null) continue;
                    iliModel.addDepenedency(depName);
                }
                ilifile.addModel(iliModel);
            }
        }
        return ret;
    }

    private IliFiles readIlimodelsXmlAsIliFiles(String uri) throws RepositoryAccessException {
        List<ModelMetadata> modelv = this.readIlimodelsXml2(uri);
        if (modelv == null) {
            return null;
        }
        modelv = RepositoryAccess.getLatestVersions2(modelv);
        return RepositoryAccess.createIliFiles2(uri, modelv);
    }

    @Deprecated
    public List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> readIlimodelsXml(String uri) throws RepositoryAccessException {
        File file = this.getLocalFileLocation(uri, "ilimodels.xml", this.metaMaxTTL, null);
        if (file == null) {
            return null;
        }
        List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelv = RepositoryAccess.readIliModelsXml(file);
        return modelv;
    }

    public List<ModelMetadata> readIlimodelsXml2(String uri) throws RepositoryAccessException {
        File file = this.getLocalFileLocation(uri, "ilimodels.xml", this.metaMaxTTL, null);
        if (file == null) {
            return null;
        }
        List<ModelMetadata> modelv = RepositoryAccess.readIliModelsXml2(file);
        return modelv;
    }

    public List<DatasetMetadata> readIliDataXmlLatest(String uri) throws RepositoryAccessException {
        ArrayList<DatasetMetadata> result = new ArrayList<DatasetMetadata>();
        List<DatasetMetadata> datav = this.readIliDataXml(uri);
        if (datav == null) {
            return result;
        }
        ArrayList<String> datasetIds = new ArrayList<String>();
        HashMap<String, ArrayList<DatasetMetadata>> versionsPerId = new HashMap<String, ArrayList<DatasetMetadata>>();
        for (DatasetMetadata data : datav) {
            String datasetId = data.getid();
            ArrayList<DatasetMetadata> versions = (ArrayList<DatasetMetadata>)versionsPerId.get(datasetId);
            if (versions == null) {
                datasetIds.add(datasetId);
                versions = new ArrayList<DatasetMetadata>();
                versionsPerId.put(datasetId, versions);
            }
            versions.add(data);
        }
        for (String datasetId : datasetIds) {
            List versions = (List)versionsPerId.get(datasetId);
            DatasetMetadata latest = RepositoryAccess.getLatestVersion(versions);
            if (latest == null) continue;
            result.add(latest);
        }
        return result;
    }

    public List<DatasetMetadata> readIliDataXml(String uri) throws RepositoryAccessException {
        File file = this.getLocalFileLocation(uri, "ilidata.xml", this.metaMaxTTL, null);
        if (file == null) {
            return null;
        }
        List<DatasetMetadata> modelv = RepositoryAccess.readIliDataXmlLocalFile(file);
        return modelv;
    }

    @Deprecated
    public static List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> readIliModelsXml(File file) throws RepositoryAccessException {
        ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelv = new ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata>();
        XtfReader reader = null;
        try {
            reader = new XtfReader(file);
            reader.getFactory().registerFactory(ILIREPOSITORY09.getIoxFactory());
            reader.getFactory().registerFactory(ILIREPOSITORY20.getIoxFactory());
            IoxEvent event = null;
            do {
                ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata model20;
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IomObject iomObj = ((ObjectEvent)event).getIomObject();
                if (iomObj instanceof ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata && (iomObj = RepositoryAccess.mapToIom09(RepositoryAccess.mapFromIom20(model20 = (ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata)iomObj))) == null) {
                    EhiLogger.logAdaption((String)("TID=" + model20.getobjectoid() + ": ignored; failed to migrate"));
                    continue;
                }
                if (iomObj instanceof ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata) {
                    ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model = (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)iomObj;
                    String mName = model.getName();
                    if (mName == null || mName.trim().length() == 0) {
                        EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no modelname"));
                        continue;
                    }
                    if (!mName.matches(REGEX_ILI_NAME)) {
                        EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; <" + mName + "> is not a valid modelname"));
                        continue;
                    }
                    ModelMetadata_SchemaLanguage mCsl = model.getSchemaLanguage();
                    if (mCsl == null) {
                        EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no schemalanguage"));
                        continue;
                    }
                    String mFilename = model.getFile();
                    if (mFilename == null || mFilename.trim().length() == 0) {
                        EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no filename"));
                        continue;
                    }
                    modelv.add(model);
                    continue;
                }
                EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; unknown class <" + iomObj.getobjecttag() + ">"));
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new RepositoryAccessException("failed to read ilimodels.xml", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new RepositoryAccessException((Throwable)e);
                }
                reader = null;
            }
        }
        return modelv;
    }

    public static List<ModelMetadata> readIliModelsXml2(File file) throws RepositoryAccessException {
        ArrayList<ModelMetadata> modelv = new ArrayList<ModelMetadata>();
        XtfReader reader = null;
        try {
            reader = new XtfReader(file);
            reader.getFactory().registerFactory(ILIREPOSITORY09.getIoxFactory());
            reader.getFactory().registerFactory(ILIREPOSITORY20.getIoxFactory());
            IoxEvent event = null;
            do {
                String mName;
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IomObject iomObj = ((ObjectEvent)event).getIomObject();
                ModelMetadata model = null;
                if (iomObj instanceof ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata) {
                    ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model09 = (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)iomObj;
                    model = RepositoryAccess.mapFromIom09(model09);
                    if (model == null) {
                        EhiLogger.logAdaption((String)("TID=" + model09.getobjectoid() + ": ignored; failed to map"));
                        continue;
                    }
                } else if (iomObj instanceof ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata) {
                    ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata model20 = (ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata)iomObj;
                    model = RepositoryAccess.mapFromIom20(model20);
                    if (model == null) {
                        EhiLogger.logAdaption((String)("TID=" + model20.getobjectoid() + ": ignored; failed to map"));
                        continue;
                    }
                } else {
                    EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; unknown class <" + iomObj.getobjecttag() + ">"));
                    continue;
                }
                if ((mName = model.getName()) == null || mName.trim().length() == 0) {
                    EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no modelname"));
                    continue;
                }
                if (!mName.matches(REGEX_ILI_NAME)) {
                    EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; <" + mName + "> is not a valid modelname"));
                    continue;
                }
                String mCsl = model.getSchemaLanguage();
                if (mCsl == null) {
                    EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no schemalanguage"));
                    continue;
                }
                String mFilename = model.getFile();
                if (mFilename == null || mFilename.trim().length() == 0) {
                    EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; no filename"));
                    continue;
                }
                modelv.add(model);
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new RepositoryAccessException("failed to read ilimodels.xml", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new RepositoryAccessException((Throwable)e);
                }
                reader = null;
            }
        }
        return modelv;
    }

    public static ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata mapToIom20(ModelMetadata model) {
        ModelName_ dep20;
        String nameLanguage;
        String versionComment;
        String version;
        String title;
        String technicalContact;
        String tags;
        String shortDescription;
        String csl;
        String publishingDate;
        String precursorVersion;
        String original;
        String name;
        String md5;
        String issuer;
        String file;
        String furtherMetadata;
        if (model == null) {
            return null;
        }
        ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata model20 = new ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata(model.getOid());
        boolean browseOnly = model.isBrowseOnly();
        model20.setbrowseOnly(browseOnly);
        String furtherInformation = model.getFurtherInformation();
        if (furtherInformation != null) {
            model20.setfurtherInformation(furtherInformation);
        }
        if ((furtherMetadata = model.getFurtherMetadata()) != null) {
            model20.setfurtherMetadata(furtherMetadata);
        }
        if ((file = model.getFile()) != null) {
            model20.setFile(file);
        }
        if ((issuer = model.getIssuer()) != null) {
            model20.setIssuer(issuer);
        }
        if ((md5 = model.getMd5()) != null) {
            model20.setmd5(md5);
        }
        if ((name = model.getName()) != null) {
            model20.setName(name);
        }
        if ((original = model.getOriginal()) != null) {
            model20.setOriginal(original);
        }
        if ((precursorVersion = model.getPrecursorVersion()) != null) {
            model20.setprecursorVersion(precursorVersion);
        }
        if ((publishingDate = model.getPublishingDate()) != null) {
            model20.setpublishingDate(publishingDate);
        }
        if ((csl = model.getSchemaLanguage()) != null) {
            model20.setSchemaLanguage(csl);
        }
        if ((shortDescription = model.getShortDescription()) != null) {
            model20.setshortDescription(shortDescription);
        }
        if ((tags = model.getTags()) != null) {
            model20.setTags(tags);
        }
        if ((technicalContact = model.getTechnicalContact()) != null) {
            model20.settechnicalContact(technicalContact);
        }
        if ((title = model.getTitle()) != null) {
            model20.setTitle(title);
        }
        if ((version = model.getVersion()) != null) {
            model20.setVersion(version);
        }
        if ((versionComment = model.getVersionComment()) != null) {
            model20.setVersionComment(versionComment);
        }
        if ((nameLanguage = model.getNameLanguage()) != null) {
            model20.setNameLanguage(nameLanguage);
        }
        for (String dep : model.getDependsOnModel()) {
            dep20 = new ModelName_();
            dep20.setvalue(dep);
            model20.adddependsOnModel(dep20);
        }
        for (String dep : model.getDerivedModel()) {
            dep20 = new ModelName_();
            dep20.setvalue(dep);
            model20.addderivedModel(dep20);
        }
        for (String dep : model.getFollowupModel()) {
            dep20 = new ModelName_();
            dep20.setvalue(dep);
            model20.addfollowupModel(dep20);
        }
        for (String dep : model.getKnownPortal()) {
            dep20 = new WebSite_();
            dep20.setvalue(dep);
            model20.addknownPortal((WebSite_)dep20);
        }
        for (String dep : model.getKnownWFS()) {
            dep20 = new WebService_();
            dep20.setvalue(dep);
            model20.addknownWFS((WebService_)dep20);
        }
        for (String dep : model.getKnownWMS()) {
            dep20 = new WebService_();
            dep20.setvalue(dep);
            model20.addknownWMS((WebService_)dep20);
        }
        return model20;
    }

    public static ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata mapToIom09(ModelMetadata model) {
        ch.ehi.iox.ilisite.IliRepository09.ModelName_ dep09;
        String versionComment;
        String version;
        String title;
        String technicalContact;
        String tags;
        ModelMetadata_SchemaLanguage csl;
        String publishingDate;
        String precursorVersion;
        String original;
        String name;
        String md5;
        String issuer;
        String file;
        String furtherMetadata;
        if (model == null) {
            return null;
        }
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model09 = new ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata(model.getOid());
        boolean browseOnly = model.isBrowseOnly();
        model09.setbrowseOnly(browseOnly);
        String furtherInformation = model.getFurtherInformation();
        if (furtherInformation != null) {
            model09.setfurtherInformation(furtherInformation);
        }
        if ((furtherMetadata = model.getFurtherMetadata()) != null) {
            model09.setfurtherMetadata(furtherMetadata);
        }
        if ((file = model.getFile()) != null) {
            model09.setFile(file);
        }
        if ((issuer = model.getIssuer()) != null) {
            model09.setIssuer(issuer);
        }
        if ((md5 = model.getMd5()) != null) {
            model09.setmd5(md5);
        }
        if ((name = model.getName()) != null) {
            model09.setName(name);
        }
        if ((original = model.getOriginal()) != null) {
            model09.setOriginal(original);
        }
        if ((precursorVersion = model.getPrecursorVersion()) != null) {
            model09.setprecursorVersion(precursorVersion);
        }
        if ((publishingDate = model.getPublishingDate()) != null) {
            model09.setpublishingDate(publishingDate);
        }
        if ((csl = ModelMetadata_SchemaLanguage.parseXmlCode((String)model.getSchemaLanguage())) == null) {
            return null;
        }
        model09.setSchemaLanguage(csl);
        String shortDescription = model.getShortDescription();
        if (shortDescription != null) {
            model09.setshortDescription(shortDescription);
        }
        if ((tags = model.getTags()) != null) {
            model09.setTags(tags);
        }
        if ((technicalContact = model.getTechnicalContact()) != null) {
            model09.settechnicalContact(technicalContact);
        }
        if ((title = model.getTitle()) != null) {
            model09.setTitle(title);
        }
        if ((version = model.getVersion()) != null) {
            model09.setVersion(version);
        }
        if ((versionComment = model.getVersionComment()) != null) {
            model09.setVersionComment(versionComment);
        }
        for (String dep : model.getDependsOnModel()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.ModelName_();
            dep09.setvalue(dep);
            model09.adddependsOnModel(dep09);
        }
        for (String dep : model.getDerivedModel()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.ModelName_();
            dep09.setvalue(dep);
            model09.addderivedModel(dep09);
        }
        for (String dep : model.getFollowupModel()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.ModelName_();
            dep09.setvalue(dep);
            model09.addfollowupModel(dep09);
        }
        for (String dep : model.getKnownPortal()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.WebSite_();
            dep09.setvalue(dep);
            model09.addknownPortal((ch.ehi.iox.ilisite.IliRepository09.WebSite_)dep09);
        }
        for (String dep : model.getKnownWFS()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.WebService_();
            dep09.setvalue(dep);
            model09.addknownWFS((ch.ehi.iox.ilisite.IliRepository09.WebService_)dep09);
        }
        for (String dep : model.getKnownWMS()) {
            dep09 = new ch.ehi.iox.ilisite.IliRepository09.WebService_();
            dep09.setvalue(dep);
            model09.addknownWMS((ch.ehi.iox.ilisite.IliRepository09.WebService_)dep09);
        }
        return model09;
    }

    public static ModelMetadata mapFromIom20(ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata model20) {
        String nameLanguage;
        String versionComment;
        String version;
        String title;
        String technicalContact;
        String tags;
        String publishingDate;
        String precursorVersion;
        String original;
        String name;
        String md5;
        String issuer;
        String file;
        String furtherMetadata;
        if (model20 == null) {
            return null;
        }
        ModelMetadata model = new ModelMetadata();
        model.setOid(model20.getobjectoid());
        boolean browseOnly = model20.getbrowseOnly();
        model.setBrowseOnly(browseOnly);
        String furtherInformation = model20.getfurtherInformation();
        if (furtherInformation != null) {
            model.setFurtherInformation(furtherInformation);
        }
        if ((furtherMetadata = model20.getfurtherMetadata()) != null) {
            model.setFurtherMetadata(furtherMetadata);
        }
        if ((file = model20.getFile()) != null) {
            model.setFile(file);
        }
        if ((issuer = model20.getIssuer()) != null) {
            model.setIssuer(issuer);
        }
        if ((md5 = model20.getmd5()) != null) {
            model.setMd5(md5);
        }
        if ((name = model20.getName()) != null) {
            model.setName(name);
        }
        if ((original = model20.getOriginal()) != null) {
            model.setOriginal(original);
        }
        if ((precursorVersion = model20.getprecursorVersion()) != null) {
            model.setPrecursorVersion(precursorVersion);
        }
        if ((publishingDate = model20.getpublishingDate()) != null) {
            model.setPublishingDate(publishingDate);
        }
        String csl = model20.getSchemaLanguage();
        model.setSchemaLanguage(csl);
        String shortDescription = model20.getshortDescription();
        if (shortDescription != null) {
            model.setShortDescription(shortDescription);
        }
        if ((tags = model20.getTags()) != null) {
            model.setTags(tags);
        }
        if ((technicalContact = model20.gettechnicalContact()) != null) {
            model.setTechnicalContact(technicalContact);
        }
        if ((title = model20.getTitle()) != null) {
            model.setTitle(title);
        }
        if ((version = model20.getVersion()) != null) {
            model.setVersion(version);
        }
        if ((versionComment = model20.getVersionComment()) != null) {
            model.setVersionComment(versionComment);
        }
        if ((nameLanguage = model20.getNameLanguage()) != null) {
            model.setNameLanguage(nameLanguage);
        }
        for (ModelName_ modelName_ : model20.getdependsOnModel()) {
            model.addDependsOnModel(modelName_.getvalue());
        }
        for (ModelName_ modelName_ : model20.getderivedModel()) {
            model.addDerivedModel(modelName_.getvalue());
        }
        for (ModelName_ modelName_ : model20.getfollowupModel()) {
            model.addFollowupModel(modelName_.getvalue());
        }
        for (ModelName_ modelName_ : model20.getknownPortal()) {
            model.addKnownPortal(modelName_.getvalue());
        }
        for (ModelName_ modelName_ : model20.getknownWFS()) {
            model.addKnownWFS(modelName_.getvalue());
        }
        for (ModelName_ modelName_ : model20.getknownWMS()) {
            model.addKnownWMS(modelName_.getvalue());
        }
        return model;
    }

    public static ModelMetadata mapFromIom09(ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model09) {
        String versionComment;
        String version;
        String title;
        String technicalContact;
        String tags;
        String publishingDate;
        String precursorVersion;
        String original;
        String name;
        String md5;
        String issuer;
        String file;
        String furtherMetadata;
        if (model09 == null) {
            return null;
        }
        ModelMetadata model = new ModelMetadata();
        model.setOid(model09.getobjectoid());
        boolean browseOnly = model09.getbrowseOnly();
        model.setBrowseOnly(browseOnly);
        String furtherInformation = model09.getfurtherInformation();
        if (furtherInformation != null) {
            model.setFurtherInformation(furtherInformation);
        }
        if ((furtherMetadata = model09.getfurtherMetadata()) != null) {
            model.setFurtherMetadata(furtherMetadata);
        }
        if ((file = model09.getFile()) != null) {
            model.setFile(file);
        }
        if ((issuer = model09.getIssuer()) != null) {
            model.setIssuer(issuer);
        }
        if ((md5 = model09.getmd5()) != null) {
            model.setMd5(md5);
        }
        if ((name = model09.getName()) != null) {
            model.setName(name);
        }
        if ((original = model09.getOriginal()) != null) {
            model.setOriginal(original);
        }
        if ((precursorVersion = model09.getprecursorVersion()) != null) {
            model.setPrecursorVersion(precursorVersion);
        }
        if ((publishingDate = model09.getpublishingDate()) != null) {
            model.setPublishingDate(publishingDate);
        }
        String csl = ModelMetadata_SchemaLanguage.toXmlCode((ModelMetadata_SchemaLanguage)model09.getSchemaLanguage());
        model.setSchemaLanguage(csl);
        String shortDescription = model09.getshortDescription();
        if (shortDescription != null) {
            model.setShortDescription(shortDescription);
        }
        if ((tags = model09.getTags()) != null) {
            model.setTags(tags);
        }
        if ((technicalContact = model09.gettechnicalContact()) != null) {
            model.setTechnicalContact(technicalContact);
        }
        if ((title = model09.getTitle()) != null) {
            model.setTitle(title);
        }
        if ((version = model09.getVersion()) != null) {
            model.setVersion(version);
        }
        if ((versionComment = model09.getVersionComment()) != null) {
            model.setVersionComment(versionComment);
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getdependsOnModel()) {
            model.addDependsOnModel(modelName_.getvalue());
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getderivedModel()) {
            model.addDerivedModel(modelName_.getvalue());
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getfollowupModel()) {
            model.addFollowupModel(modelName_.getvalue());
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getknownPortal()) {
            model.addKnownPortal(modelName_.getvalue());
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getknownWFS()) {
            model.addKnownWFS(modelName_.getvalue());
        }
        for (ch.ehi.iox.ilisite.IliRepository09.ModelName_ modelName_ : model09.getknownWMS()) {
            model.addKnownWMS(modelName_.getvalue());
        }
        return model;
    }

    public static List<DatasetMetadata> readIliDataXmlLocalFile(File file) throws RepositoryAccessException {
        ArrayList<DatasetMetadata> datav = new ArrayList<DatasetMetadata>();
        XtfReader reader = null;
        try {
            reader = new XtfReader(file);
            reader.getFactory().registerFactory(DATASETIDX16.getIoxFactory());
            IoxEvent event = null;
            do {
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IomObject iomObj = ((ObjectEvent)event).getIomObject();
                if (iomObj instanceof DatasetMetadata) {
                    DatasetMetadata model = (DatasetMetadata)iomObj;
                    datav.add(model);
                    continue;
                }
                if (iomObj instanceof Metadata) continue;
                EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; unknown class <" + iomObj.getobjecttag() + ">"));
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new RepositoryAccessException("failed to read ilidata.xml", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new RepositoryAccessException((Throwable)e);
                }
                reader = null;
            }
        }
        return datav;
    }

    private IliSite readIliSiteXml(String uri) throws RepositoryAccessException {
        File file = this.getLocalFileLocation(uri, "ilisite.xml", this.metaMaxTTL, null);
        if (file == null) {
            return null;
        }
        XtfReader reader = null;
        try {
            reader = new XtfReader(file);
            reader.getFactory().registerFactory(ILISITE09.getIoxFactory());
            IoxEvent event = null;
            do {
                RepositoryLocation_[] subsidiaries;
                IomObject iomObj;
                if (!((event = reader.read()) instanceof ObjectEvent) || !((iomObj = ((ObjectEvent)event).getIomObject()) instanceof Site)) continue;
                Site site = (Site)iomObj;
                IliSite ret = new IliSite();
                RepositoryLocation_[] parents = site.getparentSite();
                if (parents != null) {
                    for (int parenti = 0; parenti < parents.length; ++parenti) {
                        RepositoryLocation_ parent = parents[parenti];
                        if (parent == null) continue;
                        ret.addParentSite(parent.getvalue());
                    }
                }
                if ((subsidiaries = site.getsubsidiarySite()) != null) {
                    for (int subsidiaryi = 0; subsidiaryi < subsidiaries.length; ++subsidiaryi) {
                        RepositoryLocation_ subsidiary = subsidiaries[subsidiaryi];
                        if (subsidiary == null) continue;
                        ret.addSubsidiarySite(subsidiary.getvalue());
                    }
                }
                IliSite iliSite = ret;
                return iliSite;
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new RepositoryAccessException("failed to read ilisite.xml", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new RepositoryAccessException((Throwable)e);
                }
                reader = null;
            }
        }
        return null;
    }

    @Deprecated
    public static List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> getLatestVersions(List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelVersions1) {
        HashMap models = new HashMap();
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model : modelVersions1) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> ret = new ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata>();
        HashMap files = new HashMap();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            ModelMetadata_SchemaLanguage[] cslv = new ModelMetadata_SchemaLanguage[]{ModelMetadata_SchemaLanguage.ili1, ModelMetadata_SchemaLanguage.ili2_2, ModelMetadata_SchemaLanguage.ili2_3};
            for (int csli = 0; csli < cslv.length; ++csli) {
                ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model = RepositoryAccess.getLatestVersion(modelVersions, cslv[csli]);
                if (model == null) continue;
                ret.add(model);
            }
        }
        return ret;
    }

    public static List<ModelMetadata> getLatestVersions2(List<ModelMetadata> modelVersions1) {
        HashMap models = new HashMap();
        for (ModelMetadata model : modelVersions1) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        ArrayList<ModelMetadata> ret = new ArrayList<ModelMetadata>();
        HashMap files = new HashMap();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            String[] cslv = ModelMetadata.all;
            for (int csli = 0; csli < cslv.length; ++csli) {
                ModelMetadata model = RepositoryAccess.getLatestVersion2(modelVersions, cslv[csli]);
                if (model == null) continue;
                ret.add(model);
            }
        }
        return ret;
    }

    @Deprecated
    private static ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata getCslVersion(List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelVersions1, ModelMetadata_SchemaLanguage csl) {
        ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelVersions = new ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata>();
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model2 = null;
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model2 : modelVersions1) {
            if (!model2.getSchemaLanguage().equals(csl)) continue;
            modelVersions.add(model2);
        }
        if (modelVersions.isEmpty()) {
            return null;
        }
        if (modelVersions.size() != 1) {
            EhiLogger.logAdaption((String)("model " + model2.getName() + ": multiple versions; use version " + ((ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)modelVersions.get(0)).getVersion()));
            return null;
        }
        return (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)modelVersions.get(0);
    }

    private static ModelMetadata getCslVersion2(List<ModelMetadata> modelVersions1, String csl) {
        ArrayList<ModelMetadata> modelVersions = new ArrayList<ModelMetadata>();
        ModelMetadata model2 = null;
        for (ModelMetadata model2 : modelVersions1) {
            if (!model2.getSchemaLanguage().equals(csl)) continue;
            modelVersions.add(model2);
        }
        if (modelVersions.isEmpty()) {
            return null;
        }
        if (modelVersions.size() != 1) {
            EhiLogger.logAdaption((String)("model " + model2.getName() + ": multiple versions; use version " + ((ModelMetadata)modelVersions.get(0)).getVersion()));
            return null;
        }
        return (ModelMetadata)modelVersions.get(0);
    }

    @Deprecated
    private static ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata getLatestVersion(List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelVersions1, ModelMetadata_SchemaLanguage csl) {
        ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelVersions = new ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata>();
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model2 = null;
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata model2 : modelVersions1) {
            if (model2.getbrowseOnly() || !model2.getSchemaLanguage().equals(csl)) continue;
            modelVersions.add(model2);
        }
        if (modelVersions.isEmpty()) {
            return null;
        }
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata first = null;
        Iterator i = modelVersions.iterator();
        while (i.hasNext()) {
            model2 = (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)i.next();
            if (model2.getprecursorVersion() != null) continue;
            if (first == null) {
                if (!model2.getbrowseOnly()) {
                    first = model2;
                }
                i.remove();
                continue;
            }
            if (!model2.getbrowseOnly()) {
                EhiLogger.logAdaption((String)("model " + model2.getName() + ": duplicate version without precursor; version " + model2.getVersion() + " ignored"));
            }
            i.remove();
        }
        if (first == null) {
            EhiLogger.logAdaption((String)("model " + model2.getName() + ": no version without precursor; model ignored"));
            return null;
        }
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata lastVersion = first;
        ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata current = first;
        while (!modelVersions.isEmpty()) {
            ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata next = null;
            Iterator i2 = modelVersions.iterator();
            while (i2.hasNext()) {
                model2 = (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)i2.next();
                if (!current.getVersion().equals(model2.getprecursorVersion())) continue;
                if (next == null) {
                    next = model2;
                    i2.remove();
                    continue;
                }
                EhiLogger.logAdaption((String)("model " + model2.getName() + ": duplicate version with same precursor; version " + model2.getVersion() + " ignored"));
                i2.remove();
            }
            if (next == null) break;
            current = next;
            if (current.getbrowseOnly()) continue;
            lastVersion = current;
        }
        if (!modelVersions.isEmpty()) {
            EhiLogger.logAdaption((String)("model " + lastVersion.getName() + ": broken version chain; use version " + lastVersion.getVersion() + "; others ignored"));
        }
        return lastVersion;
    }

    private static ModelMetadata getLatestVersion2(List<ModelMetadata> modelVersions1, String csl) {
        ArrayList<ModelMetadata> modelVersions = new ArrayList<ModelMetadata>();
        ModelMetadata model2 = null;
        for (ModelMetadata model2 : modelVersions1) {
            if (model2.isBrowseOnly() || !model2.getSchemaLanguage().equals(csl)) continue;
            modelVersions.add(model2);
        }
        if (modelVersions.isEmpty()) {
            return null;
        }
        ModelMetadata first = null;
        Iterator i = modelVersions.iterator();
        while (i.hasNext()) {
            model2 = (ModelMetadata)i.next();
            if (model2.getPrecursorVersion() != null) continue;
            if (first == null) {
                if (!model2.isBrowseOnly()) {
                    first = model2;
                }
                i.remove();
                continue;
            }
            if (!model2.isBrowseOnly()) {
                EhiLogger.logAdaption((String)("model " + model2.getName() + ": duplicate version without precursor; version " + model2.getVersion() + " ignored"));
            }
            i.remove();
        }
        if (first == null) {
            EhiLogger.logAdaption((String)("model " + model2.getName() + ": no version without precursor; model ignored"));
            return null;
        }
        ModelMetadata lastVersion = first;
        ModelMetadata current = first;
        while (!modelVersions.isEmpty()) {
            ModelMetadata next = null;
            Iterator i2 = modelVersions.iterator();
            while (i2.hasNext()) {
                model2 = (ModelMetadata)i2.next();
                if (!current.getVersion().equals(model2.getPrecursorVersion())) continue;
                if (next == null) {
                    next = model2;
                    i2.remove();
                    continue;
                }
                EhiLogger.logAdaption((String)("model " + model2.getName() + ": duplicate version with same precursor; version " + model2.getVersion() + " ignored"));
                i2.remove();
            }
            if (next == null) break;
            current = next;
            if (current.isBrowseOnly()) continue;
            lastVersion = current;
        }
        if (!modelVersions.isEmpty()) {
            EhiLogger.logAdaption((String)("model " + lastVersion.getName() + ": broken version chain; use version " + lastVersion.getVersion() + "; others ignored"));
        }
        return lastVersion;
    }

    @Deprecated
    private static DatasetMetadata getLatestVersion(List<DatasetMetadata> datasetVersions1) {
        ArrayList<DatasetMetadata> datasetVersions = new ArrayList<DatasetMetadata>(datasetVersions1);
        DatasetMetadata dataset = null;
        DatasetMetadata first = null;
        Iterator<DatasetMetadata> i = datasetVersions.iterator();
        while (i.hasNext()) {
            dataset = i.next();
            if (dataset.getprecursorVersion() != null) continue;
            if (first == null) {
                first = dataset;
                i.remove();
                continue;
            }
            EhiLogger.logAdaption((String)("dataset " + dataset.getid() + ": duplicate version without precursor; version " + dataset.getversion() + " ignored"));
            i.remove();
        }
        if (first == null) {
            EhiLogger.logAdaption((String)("dataset " + dataset.getid() + ": no version without precursor; dataset ignored"));
            return null;
        }
        DatasetMetadata lastVersion = first;
        DatasetMetadata current = first;
        while (!datasetVersions.isEmpty()) {
            DatasetMetadata next = null;
            Iterator<DatasetMetadata> i2 = datasetVersions.iterator();
            while (i2.hasNext()) {
                dataset = i2.next();
                if (!current.getversion().equals(dataset.getprecursorVersion())) continue;
                if (next == null) {
                    next = dataset;
                    i2.remove();
                    continue;
                }
                EhiLogger.logAdaption((String)("dataset " + dataset.getid() + ": duplicate version with same precursor; version " + dataset.getversion() + " ignored"));
                i2.remove();
            }
            if (next == null) break;
            lastVersion = current = next;
        }
        if (!datasetVersions.isEmpty()) {
            EhiLogger.logAdaption((String)("dataset " + lastVersion.getid() + ": broken version chain; use version " + lastVersion.getversion() + "; others ignored"));
        }
        return lastVersion;
    }

    public File getLocalFileLocation(String srcUriStr) throws RepositoryAccessException {
        String localReposName = this.translateUriInclPathToFilenameInCache(srcUriStr);
        File localReposFolder = new File(this.localCache, localReposName);
        URL url = null;
        try {
            URI uri = new URI(srcUriStr);
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RepositoryAccessException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new RepositoryAccessException((Throwable)e);
        }
        File targetLocalFile = null;
        try {
            targetLocalFile = this.fetchFromHttpServer(url, localReposFolder, null);
        }
        catch (IOException e) {
            throw new RepositoryAccessException((Throwable)e);
        }
        return targetLocalFile;
    }

    /*
     * Exception decompiling
     */
    public File getLocalFileLocation(String uriStr, String srcPath, long maxTTL, String md5) throws RepositoryAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File fetchFromHttpServer(URL url, File targetFolder, String filename) throws RepositoryAccessException, IOException {
        EhiLogger.traceState((String)("fetching <" + url + "> ..."));
        URLConnection conn = null;
        conn = url.openConnection();
        if (conn.getConnectTimeout() == 0) {
            conn.setConnectTimeout(15000);
        }
        if (conn.getReadTimeout() == 0) {
            conn.setReadTimeout(40000);
        }
        BufferedInputStream in = null;
        OutputStream fos = null;
        File targetFile = null;
        try {
            boolean created;
            try {
                in = new BufferedInputStream(conn.getInputStream());
            }
            catch (FileNotFoundException e) {
                File file = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        EhiLogger.logError((Throwable)e2);
                    }
                    in = null;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        EhiLogger.logError((Throwable)e3);
                    }
                    fos = null;
                }
                return file;
            }
            if (!targetFolder.exists() && !(created = targetFolder.mkdirs())) {
                throw new IllegalArgumentException("failed to create folder " + targetFolder.toString());
            }
            if (filename == null) {
                filename = new File(url.getPath()).getName();
            }
            targetFile = new File(targetFolder, filename);
            try {
                fos = new BufferedOutputStream(new FileOutputStream(targetFile));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("failed to create file in cache", e);
            }
            try {
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = in.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to save downloaded file to cache", e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EhiLogger.logError((Throwable)e);
                }
                in = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    EhiLogger.logError((Throwable)e);
                }
                fos = null;
            }
        }
        return targetFile;
    }

    public static URI makeURI(URI uri, String pathStr) throws URISyntaxException {
        if (pathStr.startsWith("/") || pathStr.startsWith("\\")) {
            pathStr = pathStr.substring(1);
        }
        URI path = new URI(uri.getScheme(), uri.getHost(), "/" + pathStr, null);
        pathStr = path.getRawPath().substring(1);
        uri = uri.resolve(pathStr);
        return uri;
    }

    @Deprecated
    public static ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata findModelMetadata(List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelMetadatav, String name, ModelMetadata_SchemaLanguage csl) {
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata modelMetadata : modelMetadatav) {
            if (!modelMetadata.getName().equals(name) || !modelMetadata.getSchemaLanguage().equals(csl)) continue;
            return modelMetadata;
        }
        return null;
    }

    public static ModelMetadata findModelMetadata2(List<ModelMetadata> modelMetadatav, String name, String csl) {
        for (ModelMetadata modelMetadata : modelMetadatav) {
            if (!modelMetadata.getName().equals(name) || !modelMetadata.getSchemaLanguage().equals(csl)) continue;
            return modelMetadata;
        }
        return null;
    }

    @Deprecated
    public static ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata findModelMetadata(List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> modelMetadatav, String name, ModelMetadata_SchemaLanguage csl, String version) {
        for (ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata modelMetadata : modelMetadatav) {
            if (!modelMetadata.getName().equals(name) || !modelMetadata.getSchemaLanguage().equals(csl) || !modelMetadata.getVersion().equals(version)) continue;
            return modelMetadata;
        }
        return null;
    }

    public static ModelMetadata findModelMetadata2(List<ModelMetadata> modelMetadatav, String name, String csl, String version) {
        for (ModelMetadata modelMetadata : modelMetadatav) {
            if (!modelMetadata.getName().equals(name) || !modelMetadata.getSchemaLanguage().equals(csl) || !modelMetadata.getVersion().equals(version)) continue;
            return modelMetadata;
        }
        return null;
    }

    private String translateUriToFilenameInCache(String uri) {
        if (this.doHashedFilenames) {
            return RepositoryAccess.calcMD5(uri);
        }
        return RepositoryAccess.escapeUri(uri);
    }

    private String translateUriInclPathToFilenameInCache(String uri) {
        if (this.doHashedFilenames) {
            return RepositoryAccess.calcMD5(uri);
        }
        return RepositoryAccess.escapeUriInclPath(uri);
    }

    public static String escapeUri(String uri) {
        StringBuffer localFileName = new StringBuffer();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == '<' || c == '>' || c == ':' || c == '\"' || c == '\\' || c == '|' || c == '?' || c == '*' || c == '%' || c == '&') {
                localFileName.append('&');
                String str = Integer.toHexString(c);
                localFileName.append("0000".substring(str.length()) + str);
                continue;
            }
            localFileName.append(c);
        }
        return localFileName.toString();
    }

    public static String escapeUriInclPath(String uri) {
        StringBuffer localFileName = new StringBuffer();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == '<' || c == '>' || c == ':' || c == '\"' || c == '\\' || c == '/' || c == '|' || c == '?' || c == '*' || c == '%' || c == '&') {
                localFileName.append('&');
                String str = Integer.toHexString(c);
                localFileName.append("0000".substring(str.length()) + str);
                continue;
            }
            localFileName.append(c);
        }
        return localFileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calcMD5(File file) {
        FileInputStream is;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(ILI_CACHE_FILENAME_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        String signature = null;
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            do {
                if ((numRead = ((InputStream)is).read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            signature = String.format("%032x", new BigInteger(1, md.digest()));
        }
        catch (IOException e) {
            EhiLogger.logError((Throwable)e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                EhiLogger.logError((Throwable)e);
            }
        }
        return signature;
    }

    public static String calcMD5(String value) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(ILI_CACHE_FILENAME_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        String signature = String.format("%032x", new BigInteger(1, md.digest(value.getBytes())));
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File target, File src) {
        BufferedInputStream in = null;
        OutputStream fos = null;
        try {
            boolean created;
            try {
                in = new BufferedInputStream(new FileInputStream(src));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("failed to open file", e);
            }
            File dir = target.getParentFile();
            if (!dir.exists() && !(created = dir.mkdirs())) {
                throw new IllegalArgumentException("failed to create folder " + dir);
            }
            try {
                fos = new BufferedOutputStream(new FileOutputStream(target));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("failed to open file", e);
            }
            try {
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = in.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to copy file", e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EhiLogger.logError((Throwable)e);
                }
                in = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    EhiLogger.logError((Throwable)e);
                }
                fos = null;
            }
        }
    }
}

