/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import ch.interlis.models.DATASETIDX16;
import ch.interlis.models.DatasetIdx16.DataFile;
import ch.interlis.models.DatasetIdx16.DataIndex.BasketMetadata;
import ch.interlis.models.DatasetIdx16.DataIndex.DatasetMetadata;
import ch.interlis.models.DatasetIdx16.ModelLink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.interlis2.validator.CreateIliDataTool;
import org.interlis2.validator.Main;
import org.interlis2.validator.Validator;

@Deprecated
public class UpdateIliDataTool {
    public static boolean update(File newVersionOfData, Settings settings) {
        EhiLogger.logAdaption((String)"please use the new ilimanager tool");
        return new UpdateIliDataTool().updateIliData(newVersionOfData, settings);
    }

    private boolean updateIliData(File newVersionOfDataXml, Settings settings) {
        try {
            BasketMetadata[] baskets;
            String ilidataXmlFileToWrite = settings.getValue("org.interlis2.validator.ilidata");
            if (ilidataXmlFileToWrite == null || ilidataXmlFileToWrite.isEmpty()) {
                throw new Exception("Name of ouptut file required");
            }
            String datasetID = settings.getValue("org.interlis2.validator.datasetIDToUpdate");
            if (datasetID == null || datasetID.isEmpty()) {
                throw new Exception("Dataset ID should be given as a parameter!");
            }
            if (newVersionOfDataXml == null) {
                throw new Exception("New version of data file should be given as a parameter.");
            }
            String repository = settings.getValue("org.interlis2.validator.baseUrl");
            if (repository == null || repository.isEmpty()) {
                throw new Exception("Repository should be given as a parameter!");
            }
            ch.interlis.ili2c.Main.setHttpProxySystemProperties((Settings)settings);
            RepositoryAccess reposAccess = new RepositoryAccess();
            File localCopyOfRemoteOriginalIliDataXml = reposAccess.getLocalFileLocation(repository, "ilidata.xml", 0L, null);
            if (localCopyOfRemoteOriginalIliDataXml == null) {
                throw new Exception("ilidata.xml could not be found in <" + repository + ">");
            }
            IomObject[] oldIlidataContents = UpdateIliDataTool.readIliData(localCopyOfRemoteOriginalIliDataXml);
            DatasetMetadata newMetadata = this.readDataFile(newVersionOfDataXml, settings);
            newMetadata.setid(datasetID);
            long maxOid = this.getMaxOid(oldIlidataContents);
            String precursorVersion = null;
            String newVersion = this.getNewVersion(oldIlidataContents, datasetID);
            File updatedFile = null;
            IomObject latestVersion = this.getLatestVersion(oldIlidataContents, datasetID);
            if (latestVersion != null) {
                precursorVersion = latestVersion.getattrvalue("version");
                updatedFile = this.getFileName(latestVersion);
            }
            newMetadata.setobjectoid(Long.toString(maxOid + 1L));
            if (updatedFile != null) {
                IomObject files = newMetadata.getattrobj("files", 0);
                IomObject file = files.getattrobj("file", 0);
                File oldFile = new File(file.getattrvalue("path"));
                String newFile = updatedFile.getParent() + "/" + oldFile.getName();
                file.setattrvalue("path", newFile);
            }
            for (BasketMetadata basketMetaData : baskets = newMetadata.getbaskets()) {
                basketMetaData.setversion(newVersion);
            }
            newMetadata.setversion(newVersion);
            if (latestVersion != null) {
                newMetadata.setprecursorVersion(precursorVersion);
            }
            this.writeNewIliData(new File(ilidataXmlFileToWrite), newMetadata, oldIlidataContents, localCopyOfRemoteOriginalIliDataXml);
        }
        catch (Exception e) {
            EhiLogger.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private IomObject getLatestVersion(IomObject[] oldIlidataContents, String datasetID) {
        long maxVersion = 0L;
        IomObject lastIomObj = null;
        ArrayList<IomObject> tmpIomObj = new ArrayList<IomObject>();
        for (int i = 0; i < oldIlidataContents.length; ++i) {
            IomObject currentIomObj = oldIlidataContents[i];
            if (!currentIomObj.getattrvalue("id").equals(datasetID)) continue;
            try {
                tmpIomObj.add(currentIomObj);
                long currentVersion = Long.parseLong(currentIomObj.getobjectoid());
                if (currentVersion <= maxVersion) continue;
                maxVersion = currentVersion;
                lastIomObj = currentIomObj;
                continue;
            }
            catch (NumberFormatException currentVersion) {
                // empty catch block
            }
        }
        if (lastIomObj == null && tmpIomObj != null) {
            for (IomObject iomObj : tmpIomObj) {
                String versionFromCurrentIomObj;
                if (lastIomObj == null) {
                    lastIomObj = iomObj;
                    continue;
                }
                String versionFromLastIomObj = lastIomObj.getobjectoid();
                if (versionFromLastIomObj.compareTo(versionFromCurrentIomObj = iomObj.getobjectoid()) >= 0) continue;
                lastIomObj = iomObj;
            }
        }
        return lastIomObj;
    }

    private String getNewVersion(IomObject[] oldIlidataContents, String datasetID) {
        long maxVersion = 0L;
        for (int i = 0; i < oldIlidataContents.length; ++i) {
            IomObject currentIomObj = oldIlidataContents[i];
            if (!currentIomObj.getattrvalue("id").equals(datasetID)) continue;
            try {
                long currentVersion = Long.parseLong(currentIomObj.getattrvalue("version"));
                if (currentVersion <= maxVersion) continue;
                maxVersion = currentVersion;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxVersion != 0L ? String.valueOf(maxVersion + 1L) : "1";
    }

    private long getMaxOid(IomObject[] oldIlidataContents) {
        long maxOid = 0L;
        for (int i = 0; i < oldIlidataContents.length; ++i) {
            IomObject currentIomObj = oldIlidataContents[i];
            try {
                long actualOid = Long.parseLong(currentIomObj.getobjectoid());
                if (actualOid <= maxOid) continue;
                maxOid = actualOid;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxOid;
    }

    private File getFileName(IomObject iomObject) {
        IomObject files = iomObject.getattrobj("files", 0);
        IomObject file = files.getattrobj("file", 0);
        return new File(file.getattrvalue("path"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewIliData(File ilidataXmlFileToWrite, DatasetMetadata newMetadata, IomObject[] oldIlidataContents, File localCopyOfRemoteOriginalIliDataXml) throws Exception {
        XtfWriterBase ioxWriter = null;
        IoxReader ioxReader = null;
        try {
            ioxReader = CreateIliDataTool.createReader(localCopyOfRemoteOriginalIliDataXml);
            FileOutputStream outStream = new FileOutputStream(ilidataXmlFileToWrite);
            XtfWriterBase ioxWriter1 = new XtfWriterBase((OutputStream)outStream, DATASETIDX16.getIoxMapping(), "2.3");
            ioxWriter1.setModels(new XtfModel[]{DATASETIDX16.getXtfModel()});
            ioxWriter = ioxWriter1;
            IoxEvent event = ioxReader.read();
            ioxWriter.write(event);
            event = ioxReader.read();
            ioxWriter.write(event);
            for (IomObject iomObj : oldIlidataContents) {
                ioxWriter.write((IoxEvent)new ObjectEvent(iomObj));
            }
            ioxWriter.write((IoxEvent)new ObjectEvent((IomObject)newMetadata));
        }
        finally {
            ioxWriter.write((IoxEvent)new EndBasketEvent());
            ioxWriter.write((IoxEvent)new ch.interlis.iox_j.EndTransferEvent());
            if (ioxWriter != null) {
                ioxWriter.close();
            }
            if (ioxReader != null) {
                ioxReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetMetadata readDataFile(File newFileVersion, Settings settings) throws Exception {
        IoxReader ioxReader = null;
        DatasetMetadata datasetMetadata = new DatasetMetadata(Integer.toString(1));
        ch.interlis.models.DatasetIdx16.File file = new ch.interlis.models.DatasetIdx16.File();
        DataFile dataFile = new DataFile();
        String filePath = CreateIliDataTool.getURLRelativePath(newFileVersion);
        file.setpath(filePath);
        dataFile.addfile(file);
        datasetMetadata.addfiles(dataFile);
        String owner = CreateIliDataTool.getOwner(settings);
        datasetMetadata.setowner(owner);
        Log2EhiLogger errHandler = new Log2EhiLogger();
        LogEventFactory errFactory = new LogEventFactory();
        errFactory.setLogger((IoxLogging)errHandler);
        List models = IoxUtility.getModels((File)newFileVersion);
        String modelVersion = IoxUtility.getModelVersion((String[])new String[]{newFileVersion.getPath()}, (LogEventFactory)errFactory);
        TransferDescription td = null;
        try {
            td = Validator.compileIli(modelVersion, models, null, newFileVersion.getAbsoluteFile().getParentFile().getAbsolutePath(), Main.getAppHome(), settings);
        }
        catch (Exception e) {
            throw new Exception("Failed to compile models for " + newFileVersion.getAbsolutePath(), e);
        }
        if (td == null) {
            throw new Exception("Failed to compile models for " + newFileVersion.getAbsolutePath());
        }
        String md5 = RepositoryAccess.calcMD5((File)newFileVersion);
        file.setmd5(md5);
        ioxReader = CreateIliDataTool.createReader(newFileVersion);
        if (ioxReader instanceof IoxIliReader) {
            dataFile.setfileFormat(((IoxIliReader)ioxReader).getMimeType());
        } else {
            dataFile.setfileFormat("application/interlis+xml;version=2.3");
        }
        try {
            IoxEvent event = null;
            Model model = null;
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                StartBasketEvent basketEvent = (StartBasketEvent)event;
                BasketMetadata basketMetaData = new BasketMetadata();
                Topic topic = (Topic)td.getElement(basketEvent.getType());
                if (model == null) {
                    String technicalContact;
                    model = (Model)topic.getContainer();
                    String furtherInformation = model.getMetaValue("furtherInformation");
                    if (furtherInformation != null) {
                        datasetMetadata.setfurtherInformation(furtherInformation);
                    }
                    if ((technicalContact = model.getMetaValue("technicalContact")) != null) {
                        datasetMetadata.settechnicalContact(technicalContact);
                    }
                    CreateIliDataTool.setShortDescription(datasetMetadata, model.getDocumentation(), model.getName());
                }
                ModelLink modelLink = new ModelLink();
                modelLink.setname(basketEvent.getType());
                basketMetaData.setmodel(modelLink);
                basketMetaData.setowner(owner);
                basketMetaData.setversion("Test");
                if (topic.getBasketOid() != null) {
                    basketMetaData.setid(basketEvent.getBid());
                } else {
                    basketMetaData.setlocalId(basketEvent.getBid());
                }
                datasetMetadata.addbaskets(basketMetaData);
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (ioxReader != null) {
                try {
                    ioxReader.close();
                }
                catch (Exception e) {
                    EhiLogger.logState((String)("An error occurred while closing the file." + e));
                }
                ioxReader = null;
            }
        }
        return datasetMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IomObject[] readIliData(File localCopyOfRemoteOriginalIliDataXml) throws Exception {
        XtfReader reader = null;
        ArrayList<IomObject> orginalIomObject = new ArrayList<IomObject>();
        try {
            reader = new XtfReader(localCopyOfRemoteOriginalIliDataXml);
            IoxEvent event = null;
            do {
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IoxEvent event1 = event;
                IomObject iomObject = ((ObjectEvent)event1).getIomObject();
                orginalIomObject.add(iomObject);
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return orginalIomObject.toArray(new IomObject[orginalIomObject.size()]);
    }
}

