/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator.refmapping;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.parser.Ili24Parser;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.interlis2.validator.models.ILIVREFDATA;
import org.interlis2.validator.models.IliVRefData.Mapping.RefData;

public class RefMapping {
    private TransferDescription td = null;
    private Map<MappingKey, List<String>> pool = new HashMap<MappingKey, List<String>>();

    private List<RefData> readFile(File file) throws IoxException {
        if (this.td == null) {
            this.td = new TransferDescription();
            InputStreamReader stream = null;
            try {
                stream = new InputStreamReader(this.getClass().getResourceAsStream("/IliVRefData.ili"));
            }
            catch (Exception ex) {
                throw new IoxException((Throwable)ex);
            }
            if (!Ili24Parser.parseIliFile((TransferDescription)this.td, (String)"IliVRefData.ili", (Reader)stream, (boolean)false, (int)0, null)) {
                throw new IoxException("failed to read ili file");
            }
        }
        ArrayList<RefData> datav = new ArrayList<RefData>();
        Xtf24Reader reader = null;
        try {
            reader = new Xtf24Reader(file);
            reader.setModel(this.td);
            reader.getFactory().registerFactory(ILIVREFDATA.getIoxFactory());
            IoxEvent event = null;
            do {
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IomObject iomObj = ((ObjectEvent)event).getIomObject();
                if (iomObj instanceof RefData) {
                    RefData model = (RefData)iomObj;
                    datav.add(model);
                    continue;
                }
                EhiLogger.logAdaption((String)("TID=" + iomObj.getobjectoid() + ": ignored; unknown class <" + iomObj.getobjecttag() + ">"));
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new IoxException("failed to read " + file.getName(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return datav;
    }

    public void addFile(File file) throws IoxException {
        if (file == null) {
            return;
        }
        List<RefData> datav = this.readFile(file);
        for (RefData data : datav) {
            if (data.getignore() != null && data.getignore().booleanValue()) continue;
            MappingKey key = new MappingKey(data.getscope(), data.gettopic());
            ArrayList<String> values = null;
            if (this.pool.containsKey(key)) {
                values = this.pool.get(key);
            } else {
                values = new ArrayList();
                this.pool.put(key, values);
            }
            this.mergeValues(values, Arrays.asList(data.getrefdata()));
        }
    }

    private void mergeValues(List<String> values, List<String> newValues) {
        if (newValues != null) {
            for (String value : newValues) {
                if (values.contains(value)) continue;
                values.add(value);
            }
        }
    }

    public String[] getRefData(String scope, String[] topics) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String topic : topics) {
            this.mergeRefData(ret, scope, topic);
        }
        Collections.sort(ret);
        return ret.toArray(new String[ret.size()]);
    }

    private void mergeRefData(List<String> ret, String scope, String topic) {
        MappingKey key = null;
        List<String> values = null;
        key = new MappingKey(scope, topic);
        values = this.pool.get(key);
        this.mergeValues(ret, values);
        key = new MappingKey(scope, null);
        values = this.pool.get(key);
        this.mergeValues(ret, values);
        key = new MappingKey(null, topic);
        values = this.pool.get(key);
        this.mergeValues(ret, values);
    }

    static class MappingKey {
        String scope;
        String topic;

        public MappingKey(String scope, String topic) {
            this.scope = scope;
            this.topic = topic;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTopic() {
            return this.topic;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MappingKey other = (MappingKey)obj;
            if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
                return false;
            }
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }
    }
}

