/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.interlis2.ilivalid_gwr.impl.GwrDownload;

public class EgidSetCompareGwrIoxPlugin
implements InterlisFunction {
    public static final String ILI_QUALIFIED_FUNCTION_NAME = "IliValidGwr_V1_0.egidSetCompareGWR";
    private TransferDescription td = null;
    private Validator validator = null;
    private GwrDownload gwr = null;
    private IoxLogging errs = null;
    private LogEventFactory errFact = null;

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        IliManager iliManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (iliManager == null) {
            iliManager = new IliManager();
        }
        this.td = td;
        this.validator = (Validator)settings.getTransientObject("ch.interlis.iox_j.validator.Validator");
        this.gwr = new GwrDownload(iliManager);
        this.errFact = logEventFactory;
        this.errs = this.errFact.getLogger();
    }

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[1].isUndefined()) {
            return Value.createUndefined();
        }
        String attrPathArg = actualArguments[1].getValue();
        Viewable currentClass = (Viewable)this.td.getElement(mainObj.getobjecttag());
        PathEl[] attrPath = null;
        ObjectPath attrObjPath = null;
        try {
            attrObjPath = this.validator.parseObjectOrAttributePath(currentClass, attrPathArg);
            if (attrObjPath.getPathElements() != null) {
                PathEl[] surfaceAttrPathEl;
                attrPath = surfaceAttrPathEl = attrObjPath.getPathElements();
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError((Throwable)e);
        }
        String municipalityId = null;
        if (!actualArguments[2].isUndefined()) {
            municipalityId = actualArguments[2].getValue();
        }
        if (municipalityId == null) {
            this.errs.addEvent(this.errFact.logErrorMsg("IliValidGwr_V1_0.egidSetCompareGWR() municipality must be defined", new String[0]));
            return Value.createSkipEvaluation();
        }
        File gwrFile = null;
        try {
            gwrFile = this.gwr.getLocalGwrDump();
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        HashSet<Integer> xtfEgids = new HashSet<Integer>();
        for (IomObject iomObj : actualArguments[0].getComplexObjects()) {
            Value valueOfObjectPath = this.validator.getValueFromObjectPath(null, iomObj, attrPath, null);
            int egid = Integer.parseInt(valueOfObjectPath.getValue());
            xtfEgids.add(egid);
        }
        Set<Integer> gwrEgids = null;
        try {
            gwrEgids = this.getGwrEgids(municipalityId, gwrFile);
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        gwrEgids.removeAll(xtfEgids);
        if (!gwrEgids.isEmpty()) {
            this.errs.addEvent(this.errFact.logDetailInfoMsg("EGID " + this.toString(gwrEgids) + " (from GWR) not in XTF", new String[0]));
        }
        return new Value(gwrEgids.isEmpty());
    }

    private String toString(Set<Integer> egids) {
        ArrayList<Integer> egidsS = new ArrayList<Integer>(egids);
        Collections.sort(egidsS);
        String sep = "";
        StringBuffer ret = new StringBuffer();
        for (Integer egid : egidsS) {
            ret.append(sep);
            ret.append(egid.toString());
            sep = ", ";
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> getGwrEgids(String municipalityId, File gwrFile) throws SQLException {
        HashSet<Integer> egids = new HashSet<Integer>();
        Connection jdbcConnection = null;
        Statement stmt = null;
        try {
            jdbcConnection = DriverManager.getConnection("jdbc:sqlite:" + gwrFile, null, null);
            stmt = jdbcConnection.prepareStatement("SELECT EGID FROM building WHERE GGDENR=?");
            stmt.setString(1, municipalityId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                egids.add(rs.getInt(1));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (jdbcConnection != null) {
                jdbcConnection.close();
            }
        }
        return egids;
    }

    public String getQualifiedIliName() {
        return ILI_QUALIFIED_FUNCTION_NAME;
    }
}

