/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class DmavtymTopologie {
    public static final String DMAVTYM_Topologie_V1_0 = "DMAVTYM_Topologie_V1_0";
    public static final String DMAVTYM_Topologie_V1_1 = "DMAVTYM_Topologie_V1_1";
    private final TransferDescription td;
    private final IoxValidationConfig validationConfig;
    private final Validator validator;
    private final LogEventFactory logger;
    private final JtsextGeometryFactory geometryFactory = new JtsextGeometryFactory();
    private final HashMap<String, Double> pointToleranceCache = new HashMap();

    public DmavtymTopologie(Validator validator, TransferDescription td, IoxValidationConfig validationConfig, LogEventFactory logger) {
        this.validator = validator;
        this.td = td;
        this.validationConfig = validationConfig;
        this.logger = logger;
        logger.setValidationConfig(validationConfig);
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals("covers")) {
            return this.evaluateCovers(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("coversWithTolerance")) {
            return this.evaluateCoversWithTolerance(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("hasGeometrySameControlPoints")) {
            return this.evaluateHasGeometrySameControlPoints(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("isGeometrySpatiallyEqual")) {
            return this.evaluateIsGeometrySpatiallyEqual(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("isInside")) {
            return this.evaluateIsInside(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("pointInPoints")) {
            return this.evaluatePointInPoints(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateCovers(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> lines;
        CurvePolygon surface;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> surfaceObjects = actualArguments[0].getComplexObjects();
        String surfaceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        if (surfaceObjects == null || surfaceObjects.size() != 1 || surfaceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null) {
            return Value.createUndefined();
        }
        IomObject surfaceObject = surfaceObjects.iterator().next();
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (surfaceObject.getattrvaluecount(surfaceAttr) != 1 || multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        try {
            surface = this.getSurface(surfaceObject.getattrobj(surfaceAttr, 0), validationKind);
            lines = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (Exception e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        HashMap<CurveSegment, Boolean> surfaceSegments = new HashMap<CurveSegment, Boolean>();
        for (CompoundCurve line : ((CompoundCurveRing)surface.getExteriorRing()).getLines()) {
            for (CurveSegment segment : line.getSegments()) {
                surfaceSegments.put(segment, false);
            }
        }
        for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
            for (CompoundCurve line : ((CompoundCurveRing)surface.getInteriorRingN(i)).getLines()) {
                for (CurveSegment segment : line.getSegments()) {
                    surfaceSegments.put(segment, false);
                }
            }
        }
        boolean result = true;
        for (CompoundCurve line : lines) {
            for (CurveSegment segment : line.getSegments()) {
                Coordinate point;
                Boolean isSegmentVisited = (Boolean)surfaceSegments.get(segment);
                if (isSegmentVisited == null) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logErrorMsg("MultiLineAttr contains unmatched line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    result = false;
                    continue;
                }
                if (isSegmentVisited.booleanValue()) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logWarningMsg("MultiLineAttr contains duplicate line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    continue;
                }
                surfaceSegments.put(segment, true);
            }
        }
        return new Value(result);
    }

    private Value evaluateCoversWithTolerance(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> multiLine;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> referenceObjects = actualArguments[0].getComplexObjects();
        String referenceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        double tolerance = actualArguments[4].getNumeric();
        if (referenceObjects == null || referenceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null || tolerance < 0.0) {
            return Value.createUndefined();
        }
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        ArrayList<Collection<CompoundCurve>> referenceMultiLines = new ArrayList<Collection<CompoundCurve>>(referenceObjects.size());
        try {
            for (IomObject referenceObject : referenceObjects) {
                if (referenceObject.getattrvaluecount(referenceAttr) != 1) {
                    return Value.createUndefined();
                }
                IomObject iomObject = referenceObject.getattrobj(referenceAttr, 0);
                String objectTag = iomObject.getobjecttag();
                if (objectTag.equals("MULTISURFACE")) {
                    CurvePolygon surface = this.getSurface(iomObject, validationKind);
                    referenceMultiLines.add(((CompoundCurveRing)surface.getExteriorRing()).getLines());
                    for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
                        referenceMultiLines.add(((CompoundCurveRing)surface.getInteriorRingN(i)).getLines());
                    }
                    continue;
                }
                if (objectTag.equals("MULTIPOLYLINE") || objectTag.equals("POLYLINE")) {
                    referenceMultiLines.add(this.getLines(iomObject));
                    continue;
                }
                return Value.createUndefined();
            }
            multiLine = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        Envelope linesEnvelope = new Envelope();
        for (CompoundCurve compoundCurve : multiLine) {
            linesEnvelope.expandToInclude(compoundCurve.getEnvelopeInternal());
        }
        linesEnvelope.expandBy(tolerance);
        for (Collection collection : referenceMultiLines) {
            boolean envelopesIntersect = false;
            for (CompoundCurve line : collection) {
                if (!linesEnvelope.intersects(line.getEnvelopeInternal())) continue;
                envelopesIntersect = true;
                break;
            }
            if (!envelopesIntersect || !this.coversWithTolerance(collection, multiLine, tolerance)) continue;
            return new Value(true);
        }
        return new Value(false);
    }

    private boolean coversWithTolerance(Collection<CompoundCurve> referenceMultiLine, Collection<CompoundCurve> multiLine, final double tolerance) {
        STRtree tree = new STRtree();
        for (CompoundCurve referenceLine : referenceMultiLine) {
            for (final CurveSegment segment : referenceLine.getSegments()) {
                tree.insert(segment.computeEnvelopeInternal(), (Object)segment);
            }
        }
        for (CompoundCurve line : multiLine) {
            for (final CurveSegment segment : line.getSegments()) {
                final boolean[] found = new boolean[]{false};
                tree.query(segment.computeEnvelopeInternal(), new ItemVisitor(){

                    public void visitItem(Object item) {
                        if (!found[0] && item instanceof CurveSegment && segment.equals2D((CurveSegment)item, tolerance)) {
                            found[0] = true;
                        }
                    }
                });
                if (found[0]) continue;
                return false;
            }
        }
        return true;
    }

    private Value evaluateHasGeometrySameControlPoints(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        return this.evaluateGeometryEquality(validationKind, usageScope, mainObj, actualArguments, new GeometryEqualityFunction(){

            @Override
            public boolean areEqual(Geometry geom1, Geometry geom2, double tolerance) {
                geom1.normalize();
                geom2.normalize();
                return geom1.equalsExact(geom2, tolerance);
            }
        });
    }

    private Value evaluateIsGeometrySpatiallyEqual(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        return this.evaluateGeometryEquality(validationKind, usageScope, mainObj, actualArguments, new GeometryEqualityFunction(){

            @Override
            public boolean areEqual(Geometry geom1, Geometry geom2, double tolerance) {
                return geom1.buffer(tolerance).covers(geom2) && geom2.buffer(tolerance).covers(geom1);
            }
        });
    }

    private Value evaluateGeometryEquality(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments, GeometryEqualityFunction equality) {
        Geometry surface2;
        Geometry surface1;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> surface1Objects = actualArguments[0].getComplexObjects();
        String surface1Attr = actualArguments[1].getValue();
        Collection<IomObject> surface2Objects = actualArguments[2].getComplexObjects();
        String surface2Attr = actualArguments[3].getValue();
        double tolerance = actualArguments[4].getNumeric();
        if (surface1Objects == null || surface1Attr == null || surface2Objects == null || surface2Attr == null || tolerance < 0.0) {
            return Value.createUndefined();
        }
        try {
            surface1 = this.unionSurfaces(surface1Objects, surface1Attr, validationKind);
            surface2 = this.unionSurfaces(surface2Objects, surface2Attr, validationKind);
            if (surface1 == null || surface2 == null) {
                return Value.createUndefined();
            }
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        Envelope envelope1 = surface1.getEnvelopeInternal();
        Envelope envelope2 = surface2.getEnvelopeInternal();
        Envelope expandedEnvelope1 = new Envelope(envelope1);
        expandedEnvelope1.expandBy(tolerance);
        Envelope expandedEnvelope2 = new Envelope(envelope2);
        expandedEnvelope2.expandBy(tolerance);
        if (!expandedEnvelope1.covers(envelope2) || !expandedEnvelope2.covers(envelope1)) {
            return new Value(false);
        }
        return new Value(equality.areEqual(surface1, surface2, tolerance));
    }

    private Geometry unionSurfaces(Collection<IomObject> objects, String attribute, String validationKind) throws IoxException {
        Geometry[] surfaces = new Geometry[objects.size()];
        int i = 0;
        for (IomObject surfaceObject : objects) {
            if (surfaceObject.getattrvaluecount(attribute) != 1) {
                return null;
            }
            surfaces[i] = this.getSurface(surfaceObject.getattrobj(attribute, 0), validationKind);
            ++i;
        }
        GeometryCollection collection = new GeometryCollection(surfaces, (GeometryFactory)this.geometryFactory);
        return collection.buffer(0.0);
    }

    private Value evaluateIsInside(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Point point;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> pointObjects = actualArguments[0].getComplexObjects();
        String pointAttr = actualArguments[1].getValue();
        Collection<IomObject> surfaceObjects = actualArguments[2].getComplexObjects();
        String surfaceAttr = actualArguments[3].getValue();
        if (pointObjects == null || pointObjects.size() != 1 || pointAttr == null || surfaceObjects == null || surfaceAttr == null) {
            return Value.createUndefined();
        }
        IomObject pointObject = pointObjects.iterator().next();
        if (pointObject.getattrvaluecount(pointAttr) != 1) {
            return Value.createUndefined();
        }
        ArrayList<CurvePolygon> surfaces = new ArrayList<CurvePolygon>(surfaceObjects.size());
        try {
            for (IomObject surfaceObject : surfaceObjects) {
                if (surfaceObject.getattrvaluecount(surfaceAttr) != 1) {
                    return Value.createUndefined();
                }
                surfaces.add(this.getSurface(surfaceObject.getattrobj(surfaceAttr, 0), validationKind));
            }
            point = this.getPoint(pointObject.getattrobj(pointAttr, 0));
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        double tolerance = this.getPointTolerance(this.td, pointObject, pointAttr);
        for (CurvePolygon surface : surfaces) {
            Envelope envelope = surface.getEnvelopeInternal();
            envelope.expandBy(tolerance);
            if (!envelope.contains(point.getCoordinate()) || !surface.buffer(tolerance).covers((Geometry)point)) continue;
            return new Value(true);
        }
        return new Value(false);
    }

    private double getPointTolerance(TransferDescription td, IomObject object, String pointAttribute) {
        String className = object.getobjecttag();
        String qualifiedAttributeName = className + "." + pointAttribute;
        Double cached = this.pointToleranceCache.get(qualifiedAttributeName);
        if (cached != null) {
            return cached;
        }
        int accuracy = this.getPointAccuracy(td, className, pointAttribute);
        double precision = Math.pow(10.0, -accuracy);
        double tolerance = precision * Math.sqrt(2.0) / 2.0;
        this.pointToleranceCache.put(qualifiedAttributeName, tolerance);
        return tolerance;
    }

    private int getPointAccuracy(TransferDescription td, String className, String pointAttribute) {
        NumericType numericType;
        NumericalType firstDimension;
        Type attrType;
        Viewable viewable;
        LocalAttribute attrElement;
        Element classElement = td.getElement(className);
        if (classElement instanceof Viewable && (attrElement = (LocalAttribute)(viewable = (Viewable)classElement).getElement(LocalAttribute.class, pointAttribute)) != null && (attrType = attrElement.getDomainResolvingAliases()) instanceof CoordType && (firstDimension = ((CoordType)attrType).getDimensions()[0]) instanceof NumericType && (numericType = (NumericType)firstDimension).getMinimum() != null) {
            return numericType.getMinimum().getAccuracy();
        }
        this.logger.addEvent(this.logger.logWarningMsg("Cannot determine accuracy for point attribute '{0}' in class '{1}'.", pointAttribute, className));
        return 0;
    }

    private Point getPoint(IomObject point) throws IoxException {
        Coordinate coordinate = Iox2jtsext.coord2JTS(point);
        return this.geometryFactory.createPoint(coordinate);
    }

    private Collection<CompoundCurve> getLines(IomObject multiLine) throws IoxException {
        if (multiLine.getobjecttag().equals("POLYLINE")) {
            ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(1);
            lines.add(this.getLine(multiLine));
            return lines;
        }
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(multiLine.getattrvaluecount("polyline"));
        for (int i = 0; i < multiLine.getattrvaluecount("polyline"); ++i) {
            lines.add(this.getLine(multiLine.getattrobj("polyline", i)));
        }
        return lines;
    }

    private CompoundCurve getLine(IomObject line) throws IoxException {
        return Iox2jtsext.polyline2JTS(line, false, 0.0, (OutParam<Boolean>)new OutParam(), this.logger, 0.0, "warning", "warning");
    }

    private CurvePolygon getSurface(IomObject surface, String validationKind) throws IoxException {
        return (CurvePolygon)Iox2jtsext.surface2JTS(surface, 0.0, (OutParam<Boolean>)new OutParam(), this.logger, 0.0, validationKind);
    }

    private Value evaluatePointInPoints(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Value argPointObjects = actualArguments[0];
        Value argPointAttr = actualArguments[1];
        Value argReferencePointObjects = actualArguments[2];
        Value argReferencePointAttr = actualArguments[3];
        if (argPointObjects.isUndefined() && argReferencePointObjects.isUndefined()) {
            return Value.createUndefined();
        }
        if (argPointObjects.isUndefined()) {
            return new Value(true);
        }
        if (argReferencePointObjects.isUndefined()) {
            return new Value(false);
        }
        Collection<IomObject> pointObjects = this.getAttribute(argPointObjects, argPointAttr);
        Collection<IomObject> referencePoints = this.getAttribute(argReferencePointObjects, argReferencePointAttr);
        if (pointObjects == null || referencePoints == null) {
            return Value.createUndefined();
        }
        try {
            String objectTag;
            HashSet<Coordinate> referencePointSet = new HashSet<Coordinate>();
            for (IomObject referencePoint : referencePoints) {
                objectTag = referencePoint.getobjecttag();
                if (objectTag.equals("COORD")) {
                    referencePointSet.add(Iox2jtsext.coord2JTS(referencePoint));
                    continue;
                }
                this.logger.addEvent(this.logger.logErrorMsg("Reference Point with unexpected type: {0}.", objectTag));
                return Value.createUndefined();
            }
            for (IomObject point : pointObjects) {
                objectTag = point.getobjecttag();
                if (objectTag.equals("COORD")) {
                    Coordinate coord = Iox2jtsext.coord2JTS(point);
                    if (referencePointSet.contains(coord)) continue;
                    return new Value(false);
                }
                if (objectTag.equals("MULTISURFACE")) {
                    CurvePolygon surface = this.getSurface(point, validationKind);
                    CompoundCurveRing exteriorRing = (CompoundCurveRing)surface.getExteriorRing();
                    for (CompoundCurve line : exteriorRing.getLines()) {
                        for (CurveSegment segment : line.getSegments()) {
                            if (referencePointSet.contains(segment.getStartPoint()) && referencePointSet.contains(segment.getEndPoint())) continue;
                            return new Value(false);
                        }
                    }
                    for (int ringIndex = 0; ringIndex < surface.getNumInteriorRing(); ++ringIndex) {
                        CompoundCurveRing interiorRing = (CompoundCurveRing)surface.getInteriorRingN(ringIndex);
                        for (CompoundCurve line : interiorRing.getLines()) {
                            for (CurveSegment segment : line.getSegments()) {
                                if (referencePointSet.contains(segment.getStartPoint()) && referencePointSet.contains(segment.getEndPoint())) continue;
                                return new Value(false);
                            }
                        }
                    }
                    continue;
                }
                if (objectTag.equals("MULTIPOLYLINE") || objectTag.equals("POLYLINE")) {
                    Collection<CompoundCurve> lines = this.getLines(point);
                    for (CompoundCurve line : lines) {
                        for (CurveSegment segment : line.getSegments()) {
                            if (referencePointSet.contains(segment.getStartPoint()) && referencePointSet.contains(segment.getEndPoint())) continue;
                            return new Value(false);
                        }
                    }
                    continue;
                }
                this.logger.addEvent(this.logger.logErrorMsg("Point with unexpected type: {0}.", objectTag));
                return Value.createUndefined();
            }
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        return new Value(true);
    }

    private Collection<IomObject> getAttribute(Value objectsValue, Value attrValue) {
        Collection<IomObject> objects = objectsValue.getComplexObjects();
        if (objects == null) {
            return null;
        }
        if (attrValue.isUndefined()) {
            return objects;
        }
        String attribute = attrValue.getValue();
        if (attribute == null) {
            return null;
        }
        ArrayList<IomObject> result = new ArrayList<IomObject>();
        for (IomObject object : objects) {
            for (int i = 0; i < object.getattrvaluecount(attribute); ++i) {
                result.add(object.getattrobj(attribute, i));
            }
        }
        return result;
    }

    private static interface GeometryEqualityFunction {
        public boolean areEqual(Geometry var1, Geometry var2, double var3);
    }
}

