/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iom2java;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.iom2java.Iom2JavaTool;
import java.io.File;
import java.util.ResourceBundle;

public class Main {
    public static final String APP_NAME = "iom2java";
    public static final String APP_JAR = "iom2java.jar";
    private static String version = null;

    public static void main(String[] args) {
        int dataFileCount;
        int argi;
        if (args.length == 0) {
            return;
        }
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("--help")) {
                Main.printVersion();
                System.err.println();
                Main.printDescription();
                System.err.println();
                Main.printUsage();
                System.err.println();
                System.err.println("OPTIONS");
                System.err.println("  --help                Display this help text.");
                System.err.println("  --version             Display the version of iom2java.");
                System.err.println();
                return;
            }
            if (!arg.startsWith("-")) break;
            EhiLogger.logAdaption((String)(arg + ": unknown option; ignored"));
        }
        if ((dataFileCount = args.length - argi) > 0) {
            File xtfFile = new File(Main.getDataFiles(args, argi, dataFileCount));
            Iom2JavaTool iom2java = new Iom2JavaTool();
            try {
                iom2java.xtf2java(xtfFile);
            }
            catch (Exception e) {
                System.exit(1);
            }
        } else {
            EhiLogger.logError((String)"iom2java: wrong number of arguments");
            System.exit(2);
        }
    }

    private static String getDataFiles(String[] args, int argi, int dataFileCount) {
        String xtfFile = null;
        while (argi < args.length) {
            xtfFile = args[argi];
            ++argi;
        }
        return xtfFile;
    }

    protected static void printVersion() {
        System.err.println("iom2java, Version " + Main.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3400 Burgdorf");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  read from set Xtf file and write down a java formatted test to console.");
    }

    protected static void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar iom2java.jar [Options] in.xtf");
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch/interlis/iox_j/Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }
}

