/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.TranslatedElementNameComparator;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LineType
extends Type {
    protected PrecisionDecimal maxOverlap = null;
    protected LineForm[] lineForms = new LineForm[0];
    protected Domain controlPointDomain = null;

    @Override
    public boolean isAbstract(StringBuilder err) {
        if (this.getLineForms().length == 0) {
            err.append("missing line form");
            return true;
        }
        if (this.getControlPointDomain() == null) {
            err.append("missing VERTEX");
            return true;
        }
        if (this.getControlPointDomain().isAbstract()) {
            err.append("DomainDef " + this.getControlPointDomain().getName() + " is abstract");
            return true;
        }
        return false;
    }

    public PrecisionDecimal getMaxOverlap() {
        if (this.maxOverlap == null && this.extending != null) {
            return ((LineType)this.extending.resolveAliases()).getMaxOverlap();
        }
        return this.maxOverlap;
    }

    public PrecisionDecimal getDefinedMaxOverlap() {
        return this.maxOverlap;
    }

    public void setMaxOverlap(PrecisionDecimal maxOverlap) throws PropertyVetoException {
        PrecisionDecimal oldValue = this.maxOverlap;
        PrecisionDecimal newValue = maxOverlap;
        if (oldValue == newValue) {
            return;
        }
        if (this.extending != null && newValue != null) {
            throw new IllegalArgumentException(rsrc.getString("err_lineType_overlapInExtension"));
        }
        this.fireVetoableChange("maxOverlap", oldValue, newValue);
        this.maxOverlap = newValue;
        this.firePropertyChange("maxOverlap", oldValue, newValue);
    }

    public LineForm[] getLineForms() {
        if (this.lineForms.length == 0 && this.extending != null) {
            return ((LineType)this.extending.resolveAliases()).getLineForms();
        }
        return this.lineForms;
    }

    public LineForm[] getDefinedLineForms() {
        return this.lineForms;
    }

    public void setLineForms(LineForm[] lineForms) throws PropertyVetoException {
        LineForm[] oldValue = this.lineForms;
        LineForm[] newValue = lineForms;
        if (oldValue == newValue) {
            return;
        }
        if (newValue == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        if (this.extending != null) {
            throw new IllegalStateException("This order is not implemented; call setExtending() later");
        }
        this.fireVetoableChange("lineForms", oldValue, newValue);
        this.lineForms = newValue;
        this.firePropertyChange("lineForms", oldValue, newValue);
    }

    public Domain getControlPointDomain() {
        if (this.controlPointDomain == null && this.extending != null) {
            return ((LineType)this.extending.resolveAliases()).getControlPointDomain();
        }
        return this.controlPointDomain;
    }

    public Domain getDefinedControlPointDomain() {
        return this.controlPointDomain;
    }

    public void setControlPointDomain(Domain controlPointDomain) throws PropertyVetoException {
        Domain oldValue = this.controlPointDomain;
        Domain newValue = controlPointDomain;
        if (oldValue == newValue) {
            return;
        }
        if (this.extending != null) {
            throw new IllegalStateException("This order is not implemented; call setExtending() later");
        }
        Type newValueType = newValue == null ? null : newValue.getType();
        if (newValueType != null) {
            newValueType = newValueType.resolveAliases();
        }
        if (newValueType != null && !(newValueType instanceof CoordType)) {
            throw new IllegalArgumentException(LineType.formatMessage("err_lineType_vertexNotCoordType", newValue.toString()));
        }
        this.fireVetoableChange("controlPointDomain", oldValue, newValue);
        this.controlPointDomain = newValue;
        this.firePropertyChange("controlPointDomain", oldValue, newValue);
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        LineType general = (LineType)wantToExtend;
        if (general.lineForms.length > 0) {
            for (int i = 0; i < this.lineForms.length; ++i) {
                boolean found = false;
                for (int j = 0; j < general.lineForms.length; ++j) {
                    if (this.lineForms[i] != general.lineForms[j]) continue;
                    found = true;
                }
                if (found) continue;
                throw new IllegalArgumentException(LineType.formatMessage("err_lineType_addedlineFormToInherited", this.lineForms[i].toString()));
            }
        }
        if (this.controlPointDomain != null && general.controlPointDomain != null && !this.controlPointDomain.isExtendingIndirectly(general.controlPointDomain)) {
            throw new IllegalArgumentException(LineType.formatMessage("err_lineType_controlPtDomainNotExtending", this.controlPointDomain.toString(), general.controlPointDomain.toString()));
        }
        PrecisionDecimal generalMaxOverlap = general.getMaxOverlap();
        if (this.maxOverlap != null && generalMaxOverlap != null && generalMaxOverlap.compareTo(this.maxOverlap) == -1) {
            throw new Ili2cSemanticException(LineType.formatMessage("err_lineType_moreOverlapInExtension"));
        }
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        LineType origin = (LineType)this.getTranslationOf();
        if (origin == null) {
            return;
        }
        if (!PrecisionDecimal.equals(this.maxOverlap, origin.maxOverlap)) {
            throw new Ili2cSemanticException();
        }
        if (this.lineForms != null || origin.lineForms != null) {
            if (this.lineForms == null || origin.lineForms == null) {
                throw new Ili2cSemanticException();
            }
            if (this.lineForms.length != origin.lineForms.length) {
                throw new Ili2cSemanticException();
            }
            ArrayList lf = new ArrayList(this.lineForms.length);
            Collections.addAll(lf, this.lineForms);
            ArrayList originLf = new ArrayList(origin.lineForms.length);
            Collections.addAll(originLf, origin.lineForms);
            Collections.sort(lf, new TranslatedElementNameComparator());
            Collections.sort(originLf, new TranslatedElementNameComparator());
            for (int i = 0; i < this.lineForms.length; ++i) {
                if (!Element.equalElementRef((Element)lf.get(i), (Element)originLf.get(i))) {
                    throw new Ili2cSemanticException();
                }
                if (Element.equalElementRef(((LineForm)lf.get(i)).getSegmentStructure(), ((LineForm)originLf.get(i)).getSegmentStructure())) continue;
                throw new Ili2cSemanticException();
            }
        }
        if (this.controlPointDomain != origin.controlPointDomain) {
            if (this.controlPointDomain == null || origin.controlPointDomain == null) {
                throw new Ili2cSemanticException();
            }
            if (this.controlPointDomain.getTranslationOfOrSame() != origin.controlPointDomain.getTranslationOfOrSame()) {
                throw new Ili2cSemanticException();
            }
        }
    }

    @Override
    public LineType clone() {
        return (LineType)super.clone();
    }

    public double getP() {
        CoordType coordType = (CoordType)this.getControlPointDomain().getType();
        NumericalType[] dimv = coordType.getDimensions();
        int accuracy = ((NumericType)dimv[0]).getMaximum().getAccuracy();
        double p = accuracy == 0 ? 0.5 : Math.pow(10.0, -accuracy);
        return p;
    }
}

