/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.StdLogEvent;

public class CompilerLogEvent
extends StdLogEvent {
    private int line = 0;
    private String filename = null;
    private static boolean passWarnings = true;

    public CompilerLogEvent(int kind, String msg, Throwable ex, StackTraceElement origin) {
        super(kind, msg, ex, origin);
    }

    public CompilerLogEvent(String filename, int line, int kind, String msg, Throwable ex, StackTraceElement origin) {
        super(kind, msg, ex, origin);
        this.filename = filename;
        this.line = line;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public static void logError(String filename, int line, String errmsg) {
        EhiLogger.getInstance().logEvent((LogEvent)new CompilerLogEvent(filename, line, 7, errmsg, null, CompilerLogEvent.getCallerOrigin()));
    }

    public static void logError(String filename, int line, String errmsg, Throwable ex) {
        EhiLogger.getInstance().logEvent((LogEvent)new CompilerLogEvent(filename, line, 7, errmsg, ex, CompilerLogEvent.getCallerOrigin()));
    }

    public static void logError(String filename, int line, Throwable ex) {
        EhiLogger.getInstance().logEvent((LogEvent)new CompilerLogEvent(filename, line, 7, null, ex, CompilerLogEvent.getCallerOrigin()));
    }

    public static void logAdaption(String filename, int line, String adaption) {
        EhiLogger.getInstance().logEvent((LogEvent)new CompilerLogEvent(filename, line, 6, adaption, null, CompilerLogEvent.getCallerOrigin()));
    }

    public static void enableWarnings(boolean val) {
        passWarnings = val;
    }

    public static void logWarning(String filename, int line, String adaption) {
        if (passWarnings) {
            EhiLogger.getInstance().logEvent((LogEvent)new CompilerLogEvent(filename, line, 6, adaption, null, CompilerLogEvent.getCallerOrigin()));
        }
    }

    private static StackTraceElement getCallerOrigin() {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        if (2 < stack.length) {
            StackTraceElement st = stack[2];
            return st;
        }
        return null;
    }

    public String getEventMsg() {
        String msg = super.getEventMsg();
        if (msg == null) {
            msg = this.getException().getLocalizedMessage();
            if (msg != null && (msg = msg.trim()).length() == 0) {
                msg = null;
            }
            if (msg == null) {
                msg = this.getException().getClass().getName();
            }
        }
        String fn = this.getFilename();
        int line = this.getLine();
        return (fn != null ? fn + ":" : "") + (line != 0 ? Integer.toString(line) + ":" : "") + msg;
    }

    public String getRawEventMsg() {
        return super.getEventMsg();
    }
}

