/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr.impl;

import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iox.IoxException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class GwrDownload {
    private static final String ENV_ILIVALID_GWR_DUMP = "ILIVALID_GWR_DUMP";
    private static final String ENV_ILIVALID_GWR_DUMP_HARDFILE = "ILIVALID_GWR_DUMP_HARDFILE";
    private static final String ILIVALID_GWR_DUMP_DEFAULT = "https://public.madd.bfs.admin.ch/ch.zip";
    private final long MAX_TTL = 43200000L;
    private IliManager iliManager = null;

    public GwrDownload(IliManager iliManager) {
        this.iliManager = iliManager;
    }

    public File getLocalGwrDump() throws IoxException {
        String fileName = System.getenv(ENV_ILIVALID_GWR_DUMP_HARDFILE);
        if (fileName != null) {
            return new File(fileName);
        }
        fileName = System.getenv(ENV_ILIVALID_GWR_DUMP);
        if (fileName == null) {
            fileName = ILIVALID_GWR_DUMP_DEFAULT;
        }
        File ret = null;
        try {
            ret = IliManager.getLocalCopyOfReposFile((IliManager)this.iliManager, (String)fileName, (long)43200000L);
        }
        catch (Ili2cException e) {
            throw new IoxException("failed to get GWR dump file", (Throwable)e);
        }
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            try {
                zipFile = new ZipFile(ret);
            }
            catch (ZipException e1) {
                zipFile = null;
            }
            if (zipFile != null && (entry = zipFile.getEntry("data.sqlite")) != null) {
                File sqliteFile = new File(ret.getPath() + "-data.sqlite");
                if (sqliteFile.lastModified() < ret.lastModified()) {
                    InputStream input = zipFile.getInputStream(entry);
                    GwrDownload.copyStream(sqliteFile, input);
                }
                ret = sqliteFile;
            }
        }
        catch (IOException e) {
            throw new IoxException("failed to get GWR dump file", (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    private static void copyStream(File outFile, InputStream in) throws IOException {
        int i;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        byte[] bt = new byte[1024];
        while ((i = in.read(bt)) != -1) {
            out.write(bt, 0, i);
        }
        out.close();
    }
}

