/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.interlis2.ilivalid_gwr.impl.GwrDownload;

public class GebaeudeCountEdidGwrPlugin
implements InterlisFunction {
    public static final String ILI_QUALIFIED_FUNCTION_NAME = "IliValidGwr_V1_0.gebaeudeCountEdidGWR";
    private TransferDescription td = null;
    private GwrDownload gwr = null;

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        IliManager iliManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (iliManager == null) {
            iliManager = new IliManager();
        }
        this.td = td;
        this.gwr = new GwrDownload(iliManager);
    }

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        int egid = Integer.parseInt(actualArguments[0].getValue());
        File gwrFile = null;
        try {
            gwrFile = this.gwr.getLocalGwrDump();
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        Integer stat = null;
        try {
            stat = this.gebaeudeCountEdidGWR(egid, gwrFile);
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        if (stat != null) {
            return new Value((Type)new NumericType(), stat.toString());
        }
        return Value.createUndefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer gebaeudeCountEdidGWR(int egid, File gwrFile) throws SQLException {
        Connection jdbcConnection = null;
        Statement stmt = null;
        try {
            jdbcConnection = DriverManager.getConnection("jdbc:sqlite:" + gwrFile, null, null);
            stmt = jdbcConnection.prepareStatement("SELECT count(*) FROM entrance WHERE EGID=?");
            stmt.setInt(1, egid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                Integer n = count;
                return n;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (jdbcConnection != null) {
                jdbcConnection.close();
            }
        }
        return null;
    }

    public String getQualifiedIliName() {
        return ILI_QUALIFIED_FUNCTION_NAME;
    }
}

