/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.interlis2.ilivalid_gwr.impl.GwrDownload;

public class ExpectAdresseGwrPlugin
implements InterlisFunction {
    public static final String ILI_QUALIFIED_FUNCTION_NAME = "IliValidGwr_V1_0.expectAdresseGWR";
    private TransferDescription td = null;
    private GwrDownload gwr = null;

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        IliManager iliManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (iliManager == null) {
            iliManager = new IliManager();
        }
        this.td = td;
        this.gwr = new GwrDownload(iliManager);
    }

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[2].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[3].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[4].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[5].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[6].isUndefined()) {
            return Value.createUndefined();
        }
        String[] lokalisation = actualArguments[0].getValues();
        String hausnummer = actualArguments[1].isUndefined() ? null : actualArguments[1].getValue();
        int plz = Integer.parseInt(actualArguments[2].getValue());
        String ortschaft = actualArguments[3].getValue();
        int egid = Integer.parseInt(actualArguments[4].getValue());
        int edid = Integer.parseInt(actualArguments[5].getValue());
        int[] gstatNotEqual = this.parseInts(actualArguments[6].getValues());
        File gwrFile = null;
        try {
            gwrFile = this.gwr.getLocalGwrDump();
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        boolean exists = false;
        try {
            exists = this.expectAdresseGWR(lokalisation, hausnummer, plz, ortschaft, egid, edid, gstatNotEqual, gwrFile);
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        return new Value(exists);
    }

    private int[] parseInts(String[] values) {
        int[] ret = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = Integer.parseInt(values[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expectAdresseGWR(String[] lokalisation, String hausnummer, int plz, String ortschaft, int egid, int edid, int[] gstatNotEqual, File gwrFile) throws SQLException {
        Connection jdbcConnection = null;
        Statement stmt = null;
        try {
            int idx;
            jdbcConnection = DriverManager.getConnection("jdbc:sqlite:" + gwrFile, null, null);
            StringBuffer stmtS = new StringBuffer();
            stmtS.append("SELECT entrance.STRNAME,entrance.DEINR,entrance.DPLZ4,entrance.DPLZNAME FROM entrance inner join building on entrance.egid=building.egid WHERE ");
            stmtS.append("entrance.egid=?");
            stmtS.append(" and ");
            stmtS.append("entrance.edid=?");
            stmtS.append(" and ");
            stmtS.append("building.GSTAT not in (");
            String sep = "";
            for (idx = 0; idx < gstatNotEqual.length; ++idx) {
                stmtS.append(sep);
                stmtS.append("?");
                sep = ",";
            }
            stmtS.append(")");
            stmt = jdbcConnection.prepareStatement(stmtS.toString());
            int pi = 1;
            stmt.setInt(pi++, egid);
            stmt.setInt(pi++, edid);
            for (idx = 0; idx < gstatNotEqual.length; ++idx) {
                stmt.setInt(pi++, gstatNotEqual[idx]);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                HashSet<String> lokv = new HashSet<String>();
                for (String lok : lokalisation) {
                    if (lok == null || lok.length() <= 0) continue;
                    lokv.add(lok);
                }
                if (!lokv.contains(rs.getString(1))) {
                    boolean bl = false;
                    return bl;
                }
                String nr = StringUtility.purge((String)rs.getString(2));
                if ((hausnummer = StringUtility.purge((String)hausnummer)) != null && !hausnummer.equals(nr)) {
                    boolean bl = false;
                    return bl;
                }
                if (hausnummer == null && nr != null) {
                    boolean bl = false;
                    return bl;
                }
                if (plz != rs.getInt(3)) {
                    boolean bl = false;
                    return bl;
                }
                if (!ortschaft.equals(rs.getString(4))) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (jdbcConnection != null) {
                jdbcConnection.close();
            }
        }
        return false;
    }

    public String getQualifiedIliName() {
        return ILI_QUALIFIED_FUNCTION_NAME;
    }
}

