/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.interlis2.ilivalid_gwr.impl.GwrDownload;

public class StrassenbezeichnungExistsInGwrPlugin
implements InterlisFunction {
    public static final String ILI_QUALIFIED_FUNCTION_NAME = "IliValidGwr_V1_0.strassenbezeichnungExistsInGWR";
    private TransferDescription td = null;
    private GwrDownload gwr = null;

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        IliManager iliManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (iliManager == null) {
            iliManager = new IliManager();
        }
        this.td = td;
        this.gwr = new GwrDownload(iliManager);
    }

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[1].isUndefined()) {
            return Value.createUndefined();
        }
        String[] names = actualArguments[0].getValues();
        if (names == null) {
            names = new String[]{actualArguments[0].getValue()};
        }
        String municipalityId = null;
        if (!actualArguments[1].isUndefined()) {
            municipalityId = actualArguments[1].getValue();
        }
        File gwrFile = null;
        try {
            gwrFile = this.gwr.getLocalGwrDump();
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        boolean nameExists = false;
        try {
            nameExists = this.strassenbezeichnungExistsInGWR(names, municipalityId, gwrFile);
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        return new Value(nameExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean strassenbezeichnungExistsInGWR(String[] names, String municipalityId, File gwrFile) throws SQLException {
        Connection jdbcConnection = null;
        Statement stmt = null;
        try {
            int idx;
            jdbcConnection = DriverManager.getConnection("jdbc:sqlite:" + gwrFile, null, null);
            StringBuffer stmtS = new StringBuffer();
            stmtS.append("SELECT count(strname) FROM entrance inner join building on entrance.egid=building.egid WHERE GGDENR=? and strname in (");
            String sep = "";
            for (idx = 0; idx < names.length; ++idx) {
                stmtS.append(sep);
                stmtS.append("?");
                sep = ",";
            }
            stmtS.append(")");
            stmt = jdbcConnection.prepareStatement(stmtS.toString());
            stmt.setString(1, municipalityId);
            for (idx = 0; idx < names.length; ++idx) {
                stmt.setString(2 + idx, names[idx]);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) >= 1;
                return bl;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (jdbcConnection != null) {
                jdbcConnection.close();
            }
        }
        return false;
    }

    public String getQualifiedIliName() {
        return ILI_QUALIFIED_FUNCTION_NAME;
    }
}

