/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.ilivalid_gwr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.interlis2.ilivalid_gwr.impl.GwrDownload;

public class ExpectEgidEdidGwrPlugin
implements InterlisFunction {
    public static final String ILI_QUALIFIED_FUNCTION_NAME = "IliValidGwr_V1_0.expectEgidEdidGWR";
    private TransferDescription td = null;
    private GwrDownload gwr = null;

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        IliManager iliManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (iliManager == null) {
            iliManager = new IliManager();
        }
        this.td = td;
        this.gwr = new GwrDownload(iliManager);
    }

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[1].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[2].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[4].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[5].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[6].isUndefined()) {
            return Value.createUndefined();
        }
        int egid = Integer.parseInt(actualArguments[0].getValue());
        int edid = Integer.parseInt(actualArguments[1].getValue());
        String[] lokalisation = actualArguments[2].getValues();
        String hausnummer = actualArguments[3].isUndefined() ? null : actualArguments[3].getValue();
        int plz = Integer.parseInt(actualArguments[4].getValue());
        String ortschaft = actualArguments[5].getValue();
        int[] gstatEqual = this.parseInts(actualArguments[6].getValues());
        File gwrFile = null;
        try {
            gwrFile = this.gwr.getLocalGwrDump();
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        boolean exists = false;
        try {
            exists = this.expectEgidEdidGWR(egid, edid, lokalisation, hausnummer, plz, ortschaft, gstatEqual, gwrFile);
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createSkipEvaluation();
        }
        return new Value(exists);
    }

    private int[] parseInts(String[] values) {
        int[] ret = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = Integer.parseInt(values[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expectEgidEdidGWR(int egid, int edid, String[] lokalisation, String hausnummer, int plz, String ortschaft, int[] gstatEqual, File gwrFile) throws SQLException {
        Connection jdbcConnection = null;
        Statement stmt = null;
        try {
            int idx;
            jdbcConnection = DriverManager.getConnection("jdbc:sqlite:" + gwrFile, null, null);
            StringBuffer stmtS = new StringBuffer();
            stmtS.append("SELECT entrance.egid,entrance.edid FROM entrance inner join building on entrance.egid=building.egid WHERE ");
            if (hausnummer != null) {
                stmtS.append("entrance.DEINR=?");
            } else {
                stmtS.append("entrance.DEINR=''");
            }
            stmtS.append(" and ");
            stmtS.append("entrance.DPLZ4=?");
            stmtS.append(" and ");
            stmtS.append("entrance.DPLZNAME=?");
            stmtS.append(" and ");
            stmtS.append("entrance.STRNAME in (");
            String sep = "";
            for (idx = 0; idx < lokalisation.length; ++idx) {
                stmtS.append(sep);
                stmtS.append("?");
                sep = ",";
            }
            stmtS.append(")");
            stmtS.append(" and ");
            stmtS.append("building.GSTAT in (");
            sep = "";
            for (idx = 0; idx < gstatEqual.length; ++idx) {
                stmtS.append(sep);
                stmtS.append("?");
                sep = ",";
            }
            stmtS.append(")");
            stmt = jdbcConnection.prepareStatement(stmtS.toString());
            int pi = 1;
            if (hausnummer != null) {
                stmt.setString(pi++, hausnummer);
            }
            stmt.setInt(pi++, plz);
            stmt.setString(pi++, ortschaft);
            for (idx = 0; idx < lokalisation.length; ++idx) {
                stmt.setString(pi++, lokalisation[idx]);
            }
            for (idx = 0; idx < gstatEqual.length; ++idx) {
                stmt.setInt(pi++, gstatEqual[idx]);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) == egid && rs.getInt(2) == edid;
                return bl;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (jdbcConnection != null) {
                jdbcConnection.close();
            }
        }
        return false;
    }

    public String getQualifiedIliName() {
        return ILI_QUALIFIED_FUNCTION_NAME;
    }
}

