/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.util.Arrays;

public class ElementsFunctions {
    private static final String FUNCTION_VALUES_OF_PATH = "valuesOfPath";
    private static final String FUNCTION_VALUES_OF_PATH_N = "valuesOfPathN";
    private static final String FUNCTION_EXISTS_IN_LIST = "existsInList";
    private static final String FUNCTION_EXISTS_IN_LIST_N = "existsInListN";
    private static final String FUNCTION_VALUES = "values";
    private static final String FUNCTION_VALUES_N = "valuesN";
    private static final String FUNCTION_COALESCE = "coalesce";
    private static final String FUNCTION_COALESCE_N = "coalesceN";
    public static final String ELEMENTS_V1_0 = "Elements_V1_0";
    private final TransferDescription td;
    private final IoxValidationConfig validationConfig;
    private final Validator validator;
    private final LogEventFactory logger;

    public ElementsFunctions(Validator validator, TransferDescription td, IoxValidationConfig validationConfig, LogEventFactory logger) {
        this.validator = validator;
        this.td = td;
        this.validationConfig = validationConfig;
        this.logger = logger;
        logger.setValidationConfig(validationConfig);
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_OF_PATH)) {
            return this.evaluateValuesOfPath(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_OF_PATH_N)) {
            return this.evaluateValuesOfPath(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_EXISTS_IN_LIST)) {
            return this.evaluateExistsInList(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_EXISTS_IN_LIST_N)) {
            return this.evaluateExistsInList(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES)) {
            return this.evaluateValues(validationKind, usageScope, iomObj, actualArguments, (Type)new TextType());
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_N)) {
            return this.evaluateValues(validationKind, usageScope, iomObj, actualArguments, (Type)new NumericType());
        }
        if (currentFunction.getName().equals(FUNCTION_COALESCE)) {
            return this.evaluateCoalesce(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_COALESCE_N)) {
            return this.evaluateCoalesce(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateValuesOfPath(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        String attrPathArg = actualArguments[0].getValue();
        Viewable currentClass = (Viewable)this.td.getElement(mainObj.getobjecttag());
        PathEl[] attrPath = null;
        ObjectPath attrObjPath = null;
        try {
            attrObjPath = this.validator.parseObjectOrAttributePath(currentClass, attrPathArg);
            if (attrObjPath.getPathElements() != null) {
                PathEl[] surfaceAttrPathEl;
                attrPath = surfaceAttrPathEl = attrObjPath.getPathElements();
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError((Throwable)e);
        }
        Value valueOfObjectPath = this.validator.getValueFromObjectPath(null, mainObj, attrPath, null);
        return valueOfObjectPath;
    }

    private Value evaluateExistsInList(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[1].isUndefined()) {
            return new Value(false);
        }
        String valueArg = actualArguments[0].getValue();
        Value listArg = actualArguments[1];
        if (listArg.getValues() != null) {
            Object[] values = listArg.getValues();
            Arrays.sort(values);
            if (Arrays.binarySearch(values, valueArg) >= 0) {
                return new Value(true);
            }
        } else if (listArg.getValue() != null && valueArg.equals(listArg.getValue())) {
            return new Value(true);
        }
        return new Value(false);
    }

    private Value evaluateValues(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments, Type type) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        String listArg = actualArguments[0].getValue();
        String[] values = listArg.split(";");
        Value ret = new Value(type, values);
        return ret;
    }

    private Value evaluateCoalesce(String validationKind, String usageScope, IomObject iomObj, Value[] actualArguments) {
        Value input = actualArguments[0];
        Value defaultValue = actualArguments[1];
        if (input.isUndefined()) {
            return defaultValue;
        }
        return input;
    }
}

