/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DmavtymTopologie {
    public static final String DMAVTYM_Topologie_V1_0 = "DMAVTYM_Topologie_V1_0";
    public static final String DMAVTYM_Topologie_V1_1 = "DMAVTYM_Topologie_V1_1";
    private final TransferDescription td;
    private final IoxValidationConfig validationConfig;
    private final Validator validator;
    private final LogEventFactory logger;

    public DmavtymTopologie(Validator validator, TransferDescription td, IoxValidationConfig validationConfig, LogEventFactory logger) {
        this.validator = validator;
        this.td = td;
        this.validationConfig = validationConfig;
        this.logger = logger;
        logger.setValidationConfig(validationConfig);
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals("covers")) {
            return this.evaluateCovers(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("coversWithTolerance")) {
            return this.evaluateCoversWithTolerance(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateCovers(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> lines;
        CurvePolygon surface;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> surfaceObjects = actualArguments[0].getComplexObjects();
        String surfaceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        if (surfaceObjects == null || surfaceObjects.size() != 1 || surfaceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null) {
            return Value.createUndefined();
        }
        IomObject surfaceObject = surfaceObjects.iterator().next();
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (surfaceObject.getattrvaluecount(surfaceAttr) != 1 || multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        try {
            surface = this.getSurface(surfaceObject.getattrobj(surfaceAttr, 0), validationKind);
            lines = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (Exception e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        HashMap<CurveSegment, Boolean> surfaceSegments = new HashMap<CurveSegment, Boolean>();
        for (CompoundCurve line : ((CompoundCurveRing)surface.getExteriorRing()).getLines()) {
            for (CurveSegment segment : line.getSegments()) {
                surfaceSegments.put(segment, false);
            }
        }
        for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
            for (CompoundCurve line : ((CompoundCurveRing)surface.getInteriorRingN(i)).getLines()) {
                for (CurveSegment segment : line.getSegments()) {
                    surfaceSegments.put(segment, false);
                }
            }
        }
        boolean result = true;
        for (CompoundCurve line : lines) {
            for (CurveSegment segment : line.getSegments()) {
                Coordinate point;
                Boolean isSegmentVisited = (Boolean)surfaceSegments.get(segment);
                if (isSegmentVisited == null) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logErrorMsg("MultiLineAttr contains unmatched line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    result = false;
                    continue;
                }
                if (isSegmentVisited.booleanValue()) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logWarningMsg("MultiLineAttr contains duplicate line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    continue;
                }
                surfaceSegments.put(segment, true);
            }
        }
        return new Value(result);
    }

    private Value evaluateCoversWithTolerance(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> multiLine;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> referenceObjects = actualArguments[0].getComplexObjects();
        String referenceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        double tolerance = actualArguments[4].getNumeric();
        if (referenceObjects == null || referenceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null || tolerance < 0.0) {
            return Value.createUndefined();
        }
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        ArrayList<Collection<CompoundCurve>> referenceMultiLines = new ArrayList<Collection<CompoundCurve>>(referenceObjects.size());
        try {
            for (IomObject referenceObject : referenceObjects) {
                if (referenceObject.getattrvaluecount(referenceAttr) != 1) {
                    return Value.createUndefined();
                }
                IomObject iomObject = referenceObject.getattrobj(referenceAttr, 0);
                String objectTag = iomObject.getobjecttag();
                if (objectTag.equals("MULTISURFACE")) {
                    CurvePolygon surface = this.getSurface(iomObject, validationKind);
                    referenceMultiLines.add(((CompoundCurveRing)surface.getExteriorRing()).getLines());
                    for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
                        referenceMultiLines.add(((CompoundCurveRing)surface.getInteriorRingN(i)).getLines());
                    }
                    continue;
                }
                if (objectTag.equals("MULTIPOLYLINE") || objectTag.equals("POLYLINE")) {
                    referenceMultiLines.add(this.getLines(iomObject));
                    continue;
                }
                return Value.createUndefined();
            }
            multiLine = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (IoxException e) {
            EhiLogger.logError((Throwable)e);
            return Value.createUndefined();
        }
        Envelope linesEnvelope = new Envelope();
        for (CompoundCurve compoundCurve : multiLine) {
            linesEnvelope.expandToInclude(compoundCurve.getEnvelopeInternal());
        }
        linesEnvelope.expandBy(tolerance);
        for (Collection collection : referenceMultiLines) {
            boolean envelopesIntersect = false;
            for (CompoundCurve line : collection) {
                if (!linesEnvelope.intersects(line.getEnvelopeInternal())) continue;
                envelopesIntersect = true;
                break;
            }
            if (!envelopesIntersect || !this.coversWithTolerance(collection, multiLine, tolerance)) continue;
            return new Value(true);
        }
        return new Value(false);
    }

    private boolean coversWithTolerance(Collection<CompoundCurve> referenceMultiLine, Collection<CompoundCurve> multiLine, final double tolerance) {
        STRtree tree = new STRtree();
        for (CompoundCurve referenceLine : referenceMultiLine) {
            for (final CurveSegment segment : referenceLine.getSegments()) {
                tree.insert(segment.computeEnvelopeInternal(), (Object)segment);
            }
        }
        for (CompoundCurve line : multiLine) {
            for (final CurveSegment segment : line.getSegments()) {
                final boolean[] found = new boolean[]{false};
                tree.query(segment.computeEnvelopeInternal(), new ItemVisitor(){

                    public void visitItem(Object item) {
                        if (!found[0] && item instanceof CurveSegment && segment.equals2D((CurveSegment)item, tolerance)) {
                            found[0] = true;
                        }
                    }
                });
                if (found[0]) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<CompoundCurve> getLines(IomObject multiLine) throws IoxException {
        if (multiLine.getobjecttag().equals("POLYLINE")) {
            ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(1);
            lines.add(this.getLine(multiLine));
            return lines;
        }
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(multiLine.getattrvaluecount("polyline"));
        for (int i = 0; i < multiLine.getattrvaluecount("polyline"); ++i) {
            lines.add(this.getLine(multiLine.getattrobj("polyline", i)));
        }
        return lines;
    }

    private CompoundCurve getLine(IomObject line) throws IoxException {
        return Iox2jtsext.polyline2JTS(line, false, 0.0, (OutParam<Boolean>)new OutParam(), this.logger, 0.0, "warning", "warning");
    }

    private CurvePolygon getSurface(IomObject surface, String validationKind) throws IoxException {
        return (CurvePolygon)Iox2jtsext.surface2JTS(surface, 0.0, (OutParam<Boolean>)new OutParam(), this.logger, 0.0, validationKind);
    }
}

