/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl.btree;

import ch.ehi.iox.objpool.impl.btree.BTree;
import ch.ehi.iox.objpool.impl.btree.Node;
import ch.ehi.iox.objpool.impl.btree.NodeId;
import java.util.Stack;

public class BTreeCursor<Key, Value> {
    protected BTree<Key, Value> tree;
    protected Stack<NodeId> nodes = new Stack();
    protected Stack<Integer> entries = new Stack();
    protected boolean beforeFirst;

    public BTreeCursor(BTree<Key, Value> btree) {
        this.tree = btree;
        this.initFirst(btree.getNode(btree.getRoot()), btree.height());
        this.entries.pop();
        this.entries.push(-1);
    }

    private void initFirst(Node h, int ht) {
        this.nodes.push(h.getNodeId());
        if (ht == 0) {
            this.entries.push(0);
            return;
        }
        this.entries.push(0);
        this.initFirst(this.tree.getNode(h.getEntry(0).getChildNode()), ht - 1);
    }

    public Key getKey() {
        return this.tree.getNode(this.nodes.peek()).getEntry(this.entries.peek()).getKey();
    }

    public Value getValue() {
        return this.tree.getNode(this.nodes.peek()).getEntry(this.entries.peek()).getVal();
    }

    public void next() {
        Node<Key, Value> currentNode = this.tree.getNode(this.nodes.peek());
        int i = this.entries.peek();
        if (i + 1 < currentNode.getEntryCount()) {
            this.entries.pop();
            this.entries.push(++i);
            return;
        }
        int ht = 0;
        do {
            this.nodes.pop();
            this.entries.pop();
            if (this.nodes.size() == 0) {
                return;
            }
            currentNode = this.tree.getNode(this.nodes.peek());
            i = this.entries.peek();
            ++ht;
        } while (i + 1 == currentNode.getEntryCount());
        this.entries.pop();
        this.entries.push(++i);
        this.initFirst(this.tree.getNode(currentNode.getEntry(i).getChildNode()), ht - 1);
    }

    public boolean hasNext() {
        if (this.nodes.size() == 0) {
            return false;
        }
        Node<Key, Value> currentNode = this.tree.getNode(this.nodes.peek());
        int i = this.entries.peek();
        if (i + 1 < currentNode.getEntryCount()) {
            return true;
        }
        int ht = this.nodes.size() - 1;
        do {
            if (--ht < 0) {
                return false;
            }
            currentNode = this.tree.getNode((NodeId)this.nodes.get(ht));
        } while ((i = ((Integer)this.entries.get(ht)).intValue()) + 1 == currentNode.getEntryCount());
        return true;
    }
}

