/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2pg;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgCustomStrategy;
import ch.ehi.ili2pg.PgDbPanelDescriptor;
import ch.ehi.ili2pg.PgSequenceBasedIdGen;
import ch.ehi.ili2pg.converter.PostgisColumnConverter;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorPostgresql;
import java.text.ParseException;

public class PgMain
extends AbstractMain {
    @Override
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(PostgisColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorPostgresql.class.getName());
        config.setJdbcDriver("org.postgresql.Driver");
        config.setIdGenerator(PgSequenceBasedIdGen.class.getName());
        config.setIli2dbCustomStrategy(PgCustomStrategy.class.getName());
        config.setUuidDefaultValue("uuid_generate_v4()");
    }

    @Override
    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            @Override
            public String makeUrl(Config config) {
                if (config.getDbdatabase() != null) {
                    if (config.getDbhost() != null) {
                        if (config.getDbport() != null) {
                            return "jdbc:postgresql://" + config.getDbhost() + ":" + config.getDbport() + "/" + config.getDbdatabase();
                        }
                        return "jdbc:postgresql://" + config.getDbhost() + "/" + config.getDbdatabase();
                    }
                    if (config.getDbport() != null) {
                        return "jdbc:postgresql://localhost:" + config.getDbport() + "/" + config.getDbdatabase();
                    }
                    return "jdbc:postgresql:" + config.getDbdatabase();
                }
                return null;
            }
        };
    }

    @Override
    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return new PgDbPanelDescriptor();
    }

    public static void main(String[] args) {
        new PgMain().domain(args);
    }

    @Override
    public String getAPP_NAME() {
        return "ili2pg";
    }

    @Override
    public String getDB_PRODUCT_NAME() {
        return "postgis";
    }

    @Override
    public String getJAR_NAME() {
        return "ili2pg.jar";
    }

    @Override
    protected void printConnectOptions() {
        System.err.println("--dbhost  host         The host name of the server. Defaults to localhost.");
        System.err.println("--dbport  port         The port number the server is listening on. Defaults to 5432.");
        System.err.println("--dbdatabase database  The database name.");
        System.err.println("--dbusr  username      User name to access database.");
        System.err.println("--dbpwd  password      Password of user used to access database.");
    }

    @Override
    protected void printSpecificOptions() {
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
        System.err.println("--oneGeomPerTable      If more than one geometry per table, create secondary table.");
        System.err.println("--setupPgExt           create extensions 'uuid-ossp' and 'postgis'.");
    }

    @Override
    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbhost")) {
            config.setDbhost(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbport")) {
            config.setDbport(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbdatabase")) {
            config.setDbdatabase(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbusr")) {
            config.setDbusr(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbpwd")) {
            config.setDbpwd(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbschema")) {
            config.setDbschema(args[++argi]);
            ++argi;
        } else if (this.isOption(arg, "--oneGeomPerTable")) {
            config.setOneGeomPerTable(this.parseBooleanArgument(arg));
            ++argi;
        } else if (this.isOption(arg, "--setupPgExt")) {
            config.setSetupPgExt(this.parseBooleanArgument(arg));
            ++argi;
        }
        return argi;
    }
}

