/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.logging.AbstractXtfErrorsLogger;
import java.io.File;
import org.interlis2.validator.models.ILIVERRORS;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error;

public class XtfErrorsLogger
extends AbstractXtfErrorsLogger {
    IoxWriter out = null;

    public XtfErrorsLogger(File logFile, String sender) {
        try {
            this.out = new XtfWriterBase(logFile, ILIVERRORS.getIoxMapping(), "2.3");
            ((XtfWriterBase)this.out).setModels(new XtfModel[]{ILIVERRORS.getXtfModel()});
            StartTransferEvent startTransferEvent = new StartTransferEvent();
            startTransferEvent.setSender(sender);
            this.out.write((IoxEvent)startTransferEvent);
            StartBasketEvent startBasketEvent = new StartBasketEvent("IliVErrors.ErrorLog", "b1");
            this.out.write((IoxEvent)startBasketEvent);
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeObject(Error iomObj) {
        try {
            this.out.write((IoxEvent)new ObjectEvent(iomObj));
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.write((IoxEvent)new EndBasketEvent());
                this.out.write((IoxEvent)new EndTransferEvent());
                this.out.flush();
                this.out.close();
            }
            catch (IoxException e) {
                throw new IllegalStateException(e);
            }
            this.out = null;
        }
    }
}

