/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2ora.OraDbPanelDescriptor;
import ch.ehi.ili2ora.OraSequenceBasedIdGen;
import ch.ehi.ili2ora.OracleCustomStrategy;
import ch.ehi.ili2ora.converter.OracleSpatialColumnConverter;
import ch.ehi.ili2ora.converter.OracleWKBColumnConverter;
import ch.ehi.ili2ora.converter.OracleWKTColumnConverter;
import ch.ehi.ili2ora.sqlgen.GeneratorOracleSpatial;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorOracleWKB;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorOracleWKT;
import java.text.ParseException;

public class OraMain
extends AbstractMain {
    private static final String DB_PORT = "1521";
    private static final String DB_HOST = "localhost";
    private String dbservice = "";

    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(OracleSpatialColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorOracleSpatial.class.getName());
        config.setJdbcDriver("oracle.jdbc.driver.OracleDriver");
        config.setIdGenerator(OraSequenceBasedIdGen.class.getName());
        config.setIli2dbCustomStrategy(OracleCustomStrategy.class.getName());
        config.setValue("ch.ehi.ili2db.modelsTabModelnameColSize", "400");
    }

    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            public String makeUrl(Config config) {
                String sid = config.getDbdatabase();
                if (OraMain.this.isNullOrEmpty(sid) && OraMain.this.isNullOrEmpty(OraMain.this.dbservice)) {
                    EhiLogger.logError((String)"SID or Service must be specified");
                    return null;
                }
                if (!OraMain.this.isNullOrEmpty(sid) && !OraMain.this.isNullOrEmpty(OraMain.this.dbservice)) {
                    EhiLogger.logError((String)"SID or Service must be specified but not both");
                    return null;
                }
                String strDbHost = !OraMain.this.isNullOrEmpty(config.getDbhost()) ? config.getDbhost() : OraMain.DB_HOST;
                String strPort = !OraMain.this.isNullOrEmpty(config.getDbport()) ? config.getDbport() : OraMain.DB_PORT;
                String strDbdatabase = !OraMain.this.isNullOrEmpty(sid) ? ":" + sid : "";
                String strService = !OraMain.this.isNullOrEmpty(OraMain.this.dbservice) ? "/" + OraMain.this.dbservice : "";
                String subProtocol = "jdbc:oracle:thin:@";
                if (!strService.isEmpty()) {
                    subProtocol = subProtocol + "//";
                }
                return subProtocol + strDbHost + ":" + strPort + strDbdatabase + strService;
            }
        };
    }

    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return new OraDbPanelDescriptor();
    }

    public static void main(String[] args) {
        new OraMain().domain(args);
    }

    public String getAPP_NAME() {
        return "ili2ora";
    }

    public String getDB_PRODUCT_NAME() {
        return "oracle";
    }

    public String getJAR_NAME() {
        return "ili2ora.jar";
    }

    protected void printConnectOptions() {
        System.err.println("--dbhost  host         The host name of the server. Defaults to localhost.");
        System.err.println("--dbport  port         The port number the server is listening on. Defaults to 1521.");
        System.err.println("--dbdatabase sid       The database name.");
        System.err.println("--dbservice servicename The Oracle service name.");
        System.err.println("--dbusr  username      User name to access database.");
        System.err.println("--dbpwd  password      Password of user used to access database.");
        System.err.println("--geomwkb              Geometry as WKB (to be used if no Oracle Spatial).");
        System.err.println("--geomwkt              Geometry as WKT (to be used if no Oracle Spatial).");
    }

    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbhost")) {
            config.setDbhost(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbport")) {
            config.setDbport(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbdatabase")) {
            config.setDbdatabase(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbusr")) {
            config.setDbusr(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbpwd")) {
            config.setDbpwd(args[++argi]);
            ++argi;
        } else if (this.isOption(arg, "--geomwkb")) {
            ++argi;
            if (this.parseBooleanArgument(arg)) {
                config.setGeometryConverter(OracleWKBColumnConverter.class.getName());
                config.setDdlGenerator(GeneratorOracleWKB.class.getName());
            }
        } else if (this.isOption(arg, "--geomwkt")) {
            ++argi;
            if (this.parseBooleanArgument(arg)) {
                config.setGeometryConverter(OracleWKTColumnConverter.class.getName());
                config.setDdlGenerator(GeneratorOracleWKT.class.getName());
            }
        } else if (arg.equals("--dbservice")) {
            this.dbservice = args[++argi];
            ++argi;
        } else if (arg.equals("--dbschema")) {
            config.setDbschema(args[++argi]);
            ++argi;
        } else if (arg.equals("--generalTablespace")) {
            config.setValue("generalTablespace", args[++argi]);
            ++argi;
        } else if (arg.equals("--indexTablespace")) {
            config.setValue("indexTablespace", args[++argi]);
            ++argi;
        } else if (arg.equals("--lobTablespace")) {
            config.setValue("lobTableSpace", args[++argi]);
            ++argi;
        }
        return argi;
    }

    protected void printSpecificOptions() {
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
        System.err.println("--generalTablespace tablespace  Tablespace to be used in general: tables, indexes, and large objects (lobs).");
        System.err.println("--indexTablespace tablespace    Tablespace for indexes: unique constraints and primary keys. Overrides general tablespace for index.");
        System.err.println("--lobTablespace tablespace      Tablespace for large objects: blob, clob, nclob, and bfile datatypes. Overrides general tablespace for lobs.");
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

