/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIuds;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIdcb
extends T4CTTIMsg {
    T4C8TTIuds[] uds;
    int numuds;
    String[] colnames;
    int colOffset;
    byte[] ignoreBuff;
    StringBuffer colNameSB = null;
    OracleStatement statement = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    T4CTTIdcb(T4CMAREngine t4CMAREngine) throws IOException, SQLException {
        super((byte)16);
        this.setMarshalingEngine(t4CMAREngine);
        this.ignoreBuff = new byte[40];
    }

    void init(OracleStatement oracleStatement, int n) {
        this.statement = oracleStatement;
        this.colOffset = n;
    }

    Accessor[] receive(Accessor[] accessorArray) throws SQLException, IOException {
        short s = this.meg.unmarshalUB1();
        if (this.ignoreBuff.length < s) {
            this.ignoreBuff = new byte[s];
        }
        this.meg.unmarshalNBytes(this.ignoreBuff, 0, s);
        int n = (int)this.meg.unmarshalUB4();
        accessorArray = this.receiveCommon(accessorArray, false);
        return accessorArray;
    }

    Accessor[] receiveFromRefCursor(Accessor[] accessorArray) throws SQLException, IOException {
        short s = this.meg.unmarshalUB1();
        short s2 = this.meg.unmarshalUB1();
        accessorArray = this.receiveCommon(accessorArray, false);
        return accessorArray;
    }

    Accessor[] receiveCommon(Accessor[] accessorArray, boolean bl) throws SQLException, IOException {
        int n;
        int n2;
        this.numuds = this.meg.unmarshalUB2();
        if (!bl && this.numuds > 0) {
            n2 = this.meg.unmarshalUB1();
        }
        this.uds = new T4C8TTIuds[this.numuds];
        this.colnames = new String[this.numuds];
        for (n2 = 0; n2 < this.numuds; ++n2) {
            this.uds[n2] = new T4C8TTIuds(this.meg);
            this.uds[n2].unmarshal();
            if (this.meg.versionNumber >= 10000) {
                n = (int)this.meg.unmarshalUB4();
            }
            this.colnames[n2] = new String(this.decodeColName(this.uds[n2].getColumName(), this.uds[n2].getColumNameByteLength()));
        }
        if (!bl) {
            this.meg.unmarshalDALC();
            if (this.meg.versionNumber >= 10000) {
                n2 = (int)this.meg.unmarshalUB4();
                n = (int)this.meg.unmarshalUB4();
            }
        }
        if (this.statement.need_to_prepare_define_buffer) {
            if (accessorArray == null || accessorArray.length != this.numuds + this.colOffset) {
                Accessor[] accessorArray2 = new Accessor[this.numuds + this.colOffset];
                if (accessorArray != null && accessorArray.length == this.colOffset) {
                    System.arraycopy(accessorArray, 0, accessorArray2, 0, this.colOffset);
                }
                accessorArray = accessorArray2;
            }
            this.fillupAccessors(accessorArray, this.colOffset);
            if (!bl) {
                this.statement.describedWithNames = true;
                this.statement.described = true;
                this.statement.number_of_define_positions = this.numuds;
                this.statement.accessors = accessorArray;
                if (this.statement.connection.useFetchSizeWithLongColumn) {
                    this.statement.prepareAccessors();
                    this.statement.allocateTmpByteArray();
                }
            }
        }
        return accessorArray;
    }

    String decodeColName(byte[] byArray, short s) throws SQLException {
        String string = this.meg.conv.CharBytesToString(byArray, s);
        char[] cArray = string.toCharArray();
        if (this.colNameSB == null) {
            this.colNameSB = new StringBuffer(50);
        } else {
            this.colNameSB.delete(0, this.colNameSB.length());
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\'') continue;
            this.colNameSB.append(cArray[i]);
        }
        return this.colNameSB.substring(0, this.colNameSB.length());
    }

    void fillupAccessors(Accessor[] accessorArray, int n) throws SQLException {
        int[] nArray = this.statement.definedColumnType;
        int[] nArray2 = this.statement.definedColumnSize;
        for (int i = 0; i < this.numuds; ++i) {
            int n2 = 0;
            int n3 = 0;
            if (nArray != null && nArray.length > n + i && nArray[n + i] != 0) {
                n2 = nArray[n + i];
            }
            if (nArray2 != null && nArray2.length > n + i && nArray2[n + i] > 0) {
                n3 = nArray2[n + i];
            }
            T4C8TTIuds t4C8TTIuds = this.uds[i];
            String string = new String(this.decodeColName(this.uds[i].getTypeName(), this.uds[i].getTypeCharLength()));
            String string2 = new String(this.decodeColName(this.uds[i].getSchemaName(), this.uds[i].getSchemaCharLength()));
            String string3 = string2 + "." + string;
            int n4 = t4C8TTIuds.udsoac.oacmxl;
            switch (t4C8TTIuds.udsoac.oacdty) {
                case 96: {
                    if (t4C8TTIuds.udsoac.oacmxlc != 0 && t4C8TTIuds.udsoac.oacmxlc < n4) {
                        n4 = 2 * t4C8TTIuds.udsoac.oacmxlc;
                    }
                    int n5 = n4;
                    if (n2 != 0 && (n2 == 1 || n2 == 12) && n3 < n4) {
                        n5 = n3;
                    }
                    accessorArray[n + i] = new T4CCharAccessor(this.statement, n5, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n4, n2, n3, this.meg);
                    if ((t4C8TTIuds.udsoac.oacfl2 & 0x1000) != 4096 && t4C8TTIuds.udsoac.oacmxlc == 0) break;
                    accessorArray[this.colOffset + i].setDisplaySize(t4C8TTIuds.udsoac.oacmxlc);
                    break;
                }
                case 2: {
                    accessorArray[n + i] = new T4CNumberAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 1: {
                    if (t4C8TTIuds.udsoac.oacmxlc != 0 && t4C8TTIuds.udsoac.oacmxlc < n4) {
                        n4 = 2 * t4C8TTIuds.udsoac.oacmxlc;
                    }
                    int n5 = n4;
                    if (n2 != 0 && (n2 == 1 || n2 == 12) && n3 < n4) {
                        n5 = n3;
                    }
                    accessorArray[n + i] = new T4CVarcharAccessor(this.statement, n5, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n4, n2, n3, this.meg);
                    if ((t4C8TTIuds.udsoac.oacfl2 & 0x1000) != 4096 && t4C8TTIuds.udsoac.oacmxlc == 0) break;
                    accessorArray[this.colOffset + i].setDisplaySize(t4C8TTIuds.udsoac.oacmxlc);
                    break;
                }
                case 8: {
                    int n5;
                    if (n2 != 0 && (n2 == 1 || n2 == 12) && n3 < 4001) {
                        n5 = n3;
                        if (n5 == 0) {
                            n5 = 4000;
                        }
                        n4 = -1;
                        accessorArray[n + i] = new T4CVarcharAccessor(this.statement, n5, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n4, n2, n3, this.meg);
                        accessorArray[n + i].c_type = 8;
                        break;
                    }
                    n4 = 0;
                    accessorArray[n + i] = new T4CLongAccessor(this.statement, n + i + 1, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 6: {
                    accessorArray[n + i] = new T4CVarnumAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 100: {
                    accessorArray[n + i] = new T4CBinaryFloatAccessor(this.statement, 4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 101: {
                    accessorArray[n + i] = new T4CBinaryDoubleAccessor(this.statement, 8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 23: {
                    accessorArray[n + i] = new T4CRawAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 24: {
                    if (n2 != 0 && n2 == -2 && n3 < 2001) {
                        n4 = -1;
                        accessorArray[n + i] = new T4CRawAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                        accessorArray[n + i].c_type = 24;
                        break;
                    }
                    accessorArray[n + i] = new T4CLongRawAccessor(this.statement, n + i + 1, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 104: 
                case 208: {
                    accessorArray[n + i] = new T4CRowidAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    if (t4C8TTIuds.udsoac.oacdty != 208) break;
                    accessorArray[i].c_type = t4C8TTIuds.udsoac.oacdty;
                    break;
                }
                case 102: {
                    accessorArray[n + i] = new T4CResultSetAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 12: {
                    accessorArray[n + i] = new T4CDateAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 113: {
                    accessorArray[n + i] = new T4CBlobAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 112: {
                    accessorArray[n + i] = new T4CClobAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 114: {
                    accessorArray[n + i] = new T4CBfileAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 109: {
                    accessorArray[n + i] = new T4CNamedTypeAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, string3, n2, n3, this.meg);
                    break;
                }
                case 111: {
                    accessorArray[n + i] = new T4CRefTypeAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, string3, n2, n3, this.meg);
                    break;
                }
                case 180: {
                    accessorArray[n + i] = new T4CTimestampAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 181: {
                    accessorArray[n + i] = new T4CTimestamptzAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 231: {
                    accessorArray[n + i] = new T4CTimestampltzAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 182: {
                    accessorArray[n + i] = new T4CIntervalymAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                case 183: {
                    accessorArray[n + i] = new T4CIntervaldsAccessor(this.statement, n4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.formOfUse, n2, n3, this.meg);
                    break;
                }
                default: {
                    accessorArray[n + i] = null;
                }
            }
            accessorArray[n + i].t_otype = new OracleTypeADT(t4C8TTIuds.udsoac.oactoid, t4C8TTIuds.udsoac.oacvsn, t4C8TTIuds.udsoac.ncs, t4C8TTIuds.udsoac.formOfUse, string2 + "." + string);
            accessorArray[n + i].columnName = this.colnames[i];
            if (this.uds[i].udsoac.oacmxl != 0) continue;
            accessorArray[i].isNullByDescribe = true;
        }
        this.colNameSB = null;
    }
}

