/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean m_atLeastOneOrdinalParameter = false;
    boolean m_atLeastOneNamedParameter = false;
    String[] m_namedParas = new String[8];
    int m_paraCount = 0;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n, int n2) throws SQLException {
        this(physicalConnection, string, n, n2, 1003, 1007);
    }

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(physicalConnection, string, 1, n2, n3, n4);
        this.statementType = 2;
    }

    void registerOutParameterInternal(int n, int n2, int n3, int n4, String string) throws SQLException {
        int n5 = n - 1;
        if (n5 < 0 || n > this.number_of_bind_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 == 0) {
            DatabaseError.throwSqlException(4);
        }
        int n6 = this.get_internal_type(n2);
        this.resetBatch();
        this.current_row_need_to_prepare_binds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.number_of_bind_positions];
        }
        this.currentRowBindAccessors[n5] = this.allocateAccessor(n6, n2, n5 + 1, n4, this.currentRowFormOfUse[n5], string, true);
    }

    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            DatabaseError.throwSqlException(60, "empty Object name");
        }
        this.registerOutParameterInternal(n, n2, 0, 0, string);
    }

    public synchronized void registerOutParameterBytes(int n, int n2, int n3, int n4) throws SQLException {
        this.registerOutParameterInternal(n, n2, n3, n4, null);
    }

    public synchronized void registerOutParameterChars(int n, int n2, int n3, int n4) throws SQLException {
        this.registerOutParameterInternal(n, n2, n3, n4, null);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        this.registerOutParameterInternal(n, n2, n3, n4, null);
    }

    public synchronized void registerOutParameter(String string, int n, int n2, int n3) throws SQLException {
        int n4 = this.addNamedPara(string);
        this.registerOutParameter(n4, n, n2, n3);
    }

    void resetBatch() {
        this.batch = 1;
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
    }

    public synchronized int sendBatch() throws SQLException {
        return this.valid_rows;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2, n3, -1);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    public String getString(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getString(this.m_currentRank);
    }

    public Datum getOracleObject(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getOracleObject(this.m_currentRank);
    }

    public ROWID getROWID(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getROWID(this.m_currentRank);
    }

    public NUMBER getNUMBER(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getNUMBER(this.m_currentRank);
    }

    public DATE getDATE(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDATE(this.m_currentRank);
    }

    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getINTERVALYM(this.m_currentRank);
    }

    public INTERVALDS getINTERVALDS(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getINTERVALDS(this.m_currentRank);
    }

    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTIMESTAMP(this.m_currentRank);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTIMESTAMPTZ(this.m_currentRank);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTIMESTAMPLTZ(this.m_currentRank);
    }

    public REF getREF(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getREF(this.m_currentRank);
    }

    public ARRAY getARRAY(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getARRAY(this.m_currentRank);
    }

    public STRUCT getSTRUCT(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getSTRUCT(this.m_currentRank);
    }

    public OPAQUE getOPAQUE(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getOPAQUE(this.m_currentRank);
    }

    public CHAR getCHAR(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCHAR(this.m_currentRank);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCharacterStream(this.m_currentRank);
    }

    public RAW getRAW(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getRAW(this.m_currentRank);
    }

    public BLOB getBLOB(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBLOB(this.m_currentRank);
    }

    public CLOB getCLOB(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCLOB(this.m_currentRank);
    }

    public BFILE getBFILE(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBFILE(this.m_currentRank);
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBoolean(this.m_currentRank);
    }

    public byte getByte(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getByte(this.m_currentRank);
    }

    public short getShort(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getShort(this.m_currentRank);
    }

    public int getInt(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getInt(this.m_currentRank);
    }

    public long getLong(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getLong(this.m_currentRank);
    }

    public float getFloat(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getFloat(this.m_currentRank);
    }

    public double getDouble(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDouble(this.m_currentRank);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBigDecimal(this.m_currentRank);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBytes(this.m_currentRank);
    }

    public Date getDate(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDate(this.m_currentRank);
    }

    public Time getTime(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTime(this.m_currentRank);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTimestamp(this.m_currentRank);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getAsciiStream(this.m_currentRank);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getUnicodeStream(this.m_currentRank);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBinaryStream(this.m_currentRank);
    }

    public Object getObject(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getObject(this.m_currentRank);
    }

    public Object getAnyDataEmbeddedObject(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getAnyDataEmbeddedObject(this.m_currentRank);
    }

    public Object getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCustomDatum(this.m_currentRank, customDatumFactory);
    }

    public Object getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getORAData(this.m_currentRank, oRADataFactory);
    }

    public ResultSet getCursor(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCursor(this.m_currentRank);
    }

    public synchronized void clearParameters() throws SQLException {
        super.clearParameters();
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getObject(this.m_currentRank, map);
    }

    public Ref getRef(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getREF(this.m_currentRank);
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBLOB(this.m_currentRank);
    }

    public Clob getClob(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCLOB(this.m_currentRank);
    }

    public Array getArray(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getARRAY(this.m_currentRank);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBigDecimal(this.m_currentRank);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDate(this.m_currentRank, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTime(this.m_currentRank, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTimestamp(this.m_currentRank, calendar);
    }

    public void addBatch() throws SQLException {
        if (this.currentRowBindAccessors != null) {
            DatabaseError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    protected void alwaysOnClose() throws SQLException {
        this.m_sql.resetNamedParameters();
        this.m_paraCount = 0;
        this.m_atLeastOneOrdinalParameter = false;
        this.m_atLeastOneNamedParameter = false;
        super.alwaysOnClose();
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(string, n, 0, -1);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(string, n, n2, -1);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.registerOutParameter(n2, n, string2);
    }

    public URL getURL(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getURL(this.m_currentRank);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        int n = this.addNamedPara(string);
        this.setURLInternal(n, uRL);
    }

    public void setNull(String string, int n) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNullInternal(n2, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBooleanInternal(n, bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        int n = this.addNamedPara(string);
        this.setByteInternal(n, by);
    }

    public void setShort(String string, short s) throws SQLException {
        int n = this.addNamedPara(string);
        this.setShortInternal(n, s);
    }

    public void setInt(String string, int n) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setIntInternal(n2, n);
    }

    public void setLong(String string, long l) throws SQLException {
        int n = this.addNamedPara(string);
        this.setLongInternal(n, l);
    }

    public void setFloat(String string, float f) throws SQLException {
        int n = this.addNamedPara(string);
        this.setFloatInternal(n, f);
    }

    public void setBinaryFloat(String string, float f) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBinaryFloatInternal(n, f);
    }

    public void setBinaryFloat(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBinaryFloatInternal(n, bINARY_FLOAT);
    }

    public void setDouble(String string, double d) throws SQLException {
        int n = this.addNamedPara(string);
        this.setDoubleInternal(n, d);
    }

    public void setBinaryDouble(String string, double d) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n, d);
    }

    public void setBinaryDouble(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n, bINARY_DOUBLE);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBigDecimalInternal(n, bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        int n = this.addNamedPara(string);
        this.setStringInternal(n, string2);
    }

    public void setStringForClob(String string, String string2) throws SQLException {
        int n = this.addNamedPara(string);
        this.setStringForClobInternal(n, string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        int n = this.addNamedPara(string);
        this.setBytesInternal(n, byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        int n = this.addNamedPara(string);
        this.setDateInternal(n, date);
    }

    public void setTime(String string, Time time) throws SQLException {
        int n = this.addNamedPara(string);
        this.setTimeInternal(n, time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.addNamedPara(string);
        this.setTimestampInternal(n, timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setAsciiStreamInternal(n2, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryStreamInternal(n2, inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setObjectInternal(n3, object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(string, object, n, 0);
    }

    public void setObject(String string, Object object) throws SQLException {
        int n = this.addNamedPara(string);
        this.setObjectInternal(n, object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCharacterStreamInternal(n2, reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        int n = this.addNamedPara(string);
        this.setDateInternal(n, date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        int n = this.addNamedPara(string);
        this.setTimeInternal(n, time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n = this.addNamedPara(string);
        this.setTimestampInternal(n, timestamp, calendar);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNullInternal(n2, n, string2);
    }

    public String getString(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getString(this.m_currentRank);
    }

    public boolean getBoolean(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBoolean(this.m_currentRank);
    }

    public byte getByte(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getByte(this.m_currentRank);
    }

    public short getShort(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getShort(this.m_currentRank);
    }

    public int getInt(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getInt(this.m_currentRank);
    }

    public long getLong(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getLong(this.m_currentRank);
    }

    public float getFloat(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getFloat(this.m_currentRank);
    }

    public double getDouble(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDouble(this.m_currentRank);
    }

    public byte[] getBytes(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBytes(this.m_currentRank);
    }

    public Date getDate(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDate(this.m_currentRank);
    }

    public Time getTime(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTime(this.m_currentRank);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTimestamp(this.m_currentRank);
    }

    public Object getObject(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getObject(this.m_currentRank);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBigDecimal(this.m_currentRank);
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getObject(this.m_currentRank, map);
    }

    public Ref getRef(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getREF(this.m_currentRank);
    }

    public Blob getBlob(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getBLOB(this.m_currentRank);
    }

    public Clob getClob(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getCLOB(this.m_currentRank);
    }

    public Array getArray(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getARRAY(this.m_currentRank);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getDate(this.m_currentRank, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTime(this.m_currentRank, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getTimestamp(this.m_currentRank, calendar);
    }

    public URL getURL(String string) throws SQLException {
        int n;
        if (!this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        for (n = 0; n < this.m_paraCount && string2 != this.m_namedParas[n]; ++n) {
        }
        Accessor accessor = null;
        if (++n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getURL(this.m_currentRank);
    }

    public synchronized void registerIndexTableOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        int n5 = n - 1;
        if (n5 < 0 || n > this.number_of_bind_positions) {
            DatabaseError.throwSqlException(3);
        }
        int n6 = this.get_internal_type(n3);
        this.resetBatch();
        this.current_row_need_to_prepare_binds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.number_of_bind_positions];
        }
        this.currentRowBindAccessors[n5] = this.allocateIndexTableAccessor(n3, n6, n4, n2, this.currentRowFormOfUse[n5], true);
        this.hasIbtBind = true;
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int n, int n2, int n3, int n4, short s, boolean bl) throws SQLException {
        return new PlsqlIndexTableAccessor(this, n, n2, n3, n4, s, bl);
    }

    public synchronized Object getPlsqlIndexTable(int n) throws SQLException {
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n);
        PlsqlIndexTableAccessor plsqlIndexTableAccessor = (PlsqlIndexTableAccessor)this.outBindAccessors[n - 1];
        int n2 = plsqlIndexTableAccessor.element_internal_type;
        Object[] objectArray = null;
        switch (n2) {
            case 9: {
                objectArray = new String[datumArray.length];
                break;
            }
            case 6: {
                objectArray = new BigDecimal[datumArray.length];
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "Invalid column type");
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].toJdbc() : null;
        }
        return objectArray;
    }

    public synchronized Object getPlsqlIndexTable(int n, Class clazz) throws SQLException {
        String string;
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n);
        if (clazz == null || !clazz.isPrimitive()) {
            DatabaseError.throwSqlException(68);
        }
        if ((string = clazz.getName()).equals("byte")) {
            byte[] byArray = new byte[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                byArray[i] = datumArray[i] != null ? datumArray[i].byteValue() : (byte)0;
            }
            return byArray;
        }
        if (string.equals("char")) {
            char[] cArray = new char[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                cArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? (char)datumArray[i].intValue() : (char)'\u0000';
            }
            return cArray;
        }
        if (string.equals("double")) {
            double[] dArray = new double[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                dArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].doubleValue() : 0.0;
            }
            return dArray;
        }
        if (string.equals("float")) {
            float[] fArray = new float[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                fArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].floatValue() : 0.0f;
            }
            return fArray;
        }
        if (string.equals("int")) {
            int[] nArray = new int[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                nArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].intValue() : 0;
            }
            return nArray;
        }
        if (string.equals("long")) {
            long[] lArray = new long[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                lArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].longValue() : 0L;
            }
            return lArray;
        }
        if (string.equals("short")) {
            short[] sArray = new short[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                sArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? (short)datumArray[i].intValue() : (short)0;
            }
            return sArray;
        }
        if (string.equals("boolean")) {
            boolean[] blArray = new boolean[datumArray.length];
            for (int i = 0; i < datumArray.length; ++i) {
                blArray[i] = datumArray[i] != null && datumArray[i].getLength() != 0L ? datumArray[i].booleanValue() : false;
            }
            return blArray;
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int n) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n <= 0 || n > this.number_of_bind_positions || (accessor = this.outBindAccessors[n - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.last_index = n;
        if (this.streamList != null) {
            this.closeUsedStreams(n);
        }
        return accessor.getOraclePlsqlIndexTable(this.m_currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                if (this.m_atLeastOneNamedParameter && this.m_atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (this.m_sql.setNamedParameters(this.m_paraCount, this.m_namedParas)) {
                    this.need_to_parse = true;
                }
                return super.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                if (this.m_atLeastOneNamedParameter && this.m_atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (this.m_sql.setNamedParameters(this.m_paraCount, this.m_namedParas)) {
                    this.need_to_parse = true;
                }
                return super.executeUpdate();
            }
        }
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setNullInternal(n, n2, string);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setNullInternal(n, n2);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBooleanInternal(n, bl);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setByteInternal(n, by);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setShortInternal(n, s);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setIntInternal(n, n2);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setLongInternal(n, l);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setFloatInternal(n, f);
    }

    public synchronized void setBinaryFloat(int n, float f) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(n, f);
    }

    public synchronized void setBinaryFloat(int n, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(n, bINARY_FLOAT);
    }

    public synchronized void setBinaryDouble(int n, double d) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(n, d);
    }

    public synchronized void setBinaryDouble(int n, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(n, bINARY_DOUBLE);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setDoubleInternal(n, d);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBigDecimalInternal(n, bigDecimal);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setStringInternal(n, string);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setFixedCHARInternal(n, string);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setCursorInternal(n, resultSet);
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setROWIDInternal(n, rOWID);
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setArrayInternal(n, array);
    }

    public synchronized void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setARRAYInternal(n, aRRAY);
    }

    public synchronized void setOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setOPAQUEInternal(n, oPAQUE);
    }

    public synchronized void setStructDescriptor(int n, StructDescriptor structDescriptor) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setStructDescriptorInternal(n, structDescriptor);
    }

    public synchronized void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setSTRUCTInternal(n, sTRUCT);
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setRAWInternal(n, rAW);
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setCHARInternal(n, cHAR);
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setDATEInternal(n, dATE);
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setNUMBERInternal(n, nUMBER);
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBLOBInternal(n, bLOB);
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBlobInternal(n, blob);
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setCLOBInternal(n, cLOB);
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setClobInternal(n, clob);
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBFILEInternal(n, bFILE);
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBfileInternal(n, bFILE);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBytesInternal(n, byArray);
    }

    public synchronized void setInternalBytes(int n, byte[] byArray, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setInternalBytesInternal(n, byArray, n2);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setDateInternal(n, date);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTimeInternal(n, time);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(n, timestamp);
    }

    public synchronized void setINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setINTERVALYMInternal(n, iNTERVALYM);
    }

    public synchronized void setINTERVALDS(int n, INTERVALDS iNTERVALDS) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setINTERVALDSInternal(n, iNTERVALDS);
    }

    public synchronized void setTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPInternal(n, tIMESTAMP);
    }

    public synchronized void setTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPTZInternal(n, tIMESTAMPTZ);
    }

    public synchronized void setTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPLTZInternal(n, tIMESTAMPLTZ);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setAsciiStreamInternal(n, inputStream, n2);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setBinaryStreamInternal(n, inputStream, n2);
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setUnicodeStreamInternal(n, inputStream, n2);
    }

    public synchronized void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setCustomDatumInternal(n, customDatum);
    }

    public synchronized void setORAData(int n, ORAData oRAData) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setORADataInternal(n, oRAData);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n, object, n2, n3);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n, object, n2);
    }

    public synchronized void setRefType(int n, REF rEF) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setRefTypeInternal(n, rEF);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setRefInternal(n, ref);
    }

    public synchronized void setREF(int n, REF rEF) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setREFInternal(n, rEF);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n, object);
    }

    public synchronized void setOracleObject(int n, Datum datum) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setOracleObjectInternal(n, datum);
    }

    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setCharacterStreamInternal(n, reader, n2);
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setDateInternal(n, date, calendar);
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTimeInternal(n, time, calendar);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(n, timestamp, calendar);
    }

    public synchronized void setURL(int n, URL uRL) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setURLInternal(n, uRL);
    }

    public synchronized void setPlsqlIndexTable(int n, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        this.m_atLeastOneOrdinalParameter = true;
        this.setPlsqlIndexTableInternal(n, object, n2, n3, n4, n5);
    }

    int addNamedPara(String string) throws SQLException {
        String string2 = string.toUpperCase().intern();
        for (int i = 0; i < this.m_paraCount; ++i) {
            if (string2 != this.m_namedParas[i]) continue;
            return i + 1;
        }
        if (this.m_paraCount >= this.m_namedParas.length) {
            String[] stringArray = new String[this.m_namedParas.length * 2];
            System.arraycopy(this.m_namedParas, 0, stringArray, 0, this.m_namedParas.length);
            this.m_namedParas = stringArray;
        }
        this.m_namedParas[this.m_paraCount++] = string2;
        this.m_atLeastOneNamedParameter = true;
        return this.m_paraCount;
    }
}

