/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora.converter;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.converter.AbstractWKBColumnConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.gui.Config;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.wkb.Iox2wkb;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import ch.interlis.iox_j.wkb.Wkb2iox;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class OracleSpatialColumnConverter
extends AbstractWKBColumnConverter {
    private boolean strokeArcs = true;
    private boolean repairTouchingLines;
    private String geomFromWkbFunction;
    private static final String GEOM_FROM_WKB_FUNCTION = "ILI2ORA_SDO_GEOMETRY";
    private static final String GEOM_TO_WKB_FUNCTION = "SDO_UTIL.TO_WKBGEOMETRY";

    @Override
    public void setup(Connection conn, Settings config) {
        String dbschema;
        super.setup(conn, config);
        this.strokeArcs = "enable".equals(Config.getStrokeArcs(config));
        this.repairTouchingLines = ((Config)config).getRepairTouchingLines();
        this.geomFromWkbFunction = GEOM_FROM_WKB_FUNCTION;
        if (config instanceof Config && (dbschema = ((Config)config).getDbschema()) != null) {
            this.geomFromWkbFunction = dbschema + "." + this.geomFromWkbFunction;
        }
    }

    @Override
    public String getInsertValueWrapperCoord(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getInsertValueWrapperPolyline(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getInsertValueWrapperSurface(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiSurface(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiPolyline(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiCoord(String wkfValue, int srid) {
        return this.geomFromWkbFunction + "(" + wkfValue + ", " + Integer.toString(srid) + ")";
    }

    @Override
    public String getSelectValueWrapperCoord(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperPolyline(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperSurface(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiSurface(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiPolyline(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiCoord(String dbNativeValue) {
        return "SDO_UTIL.TO_WKBGEOMETRY(" + dbNativeValue + ")";
    }

    @Override
    public Object fromIomSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.surface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public Object fromIomMultiSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.multisurface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public Object fromIomCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.coord2wkb(value);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public Object fromIomMultiCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.multicoord2wkb(value);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public Object fromIomPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.polyline2wkb(value, false, !this.strokeArcs, p);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public Object fromIomMultiPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            byte[] geomObj;
            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
            try {
                geomObj = conv.multiline2wkb(value, !this.strokeArcs, p);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
            return this.createBlobFromBytes(geomObj);
        }
        return null;
    }

    @Override
    public IomObject toIomMultiCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public IomObject toIomSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public IomObject toIomMultiSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public IomObject toIomCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public IomObject toIomPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public IomObject toIomMultiPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        return this.toIomGeometry((Blob)geomobj);
    }

    @Override
    public Integer getSrsid(String crsAuthority, String crsCode, Connection conn) throws ConverterException {
        int srsid = Integer.parseInt(crsCode);
        return srsid;
    }

    private Blob createBlobFromBytes(byte[] geomObject) throws SQLException, ConverterException {
        Blob data = this.conn.createBlob();
        OutputStream stream = data.setBinaryStream(1L);
        try {
            stream.write(geomObject);
            stream.flush();
        }
        catch (IOException ex) {
            throw new ConverterException(ex);
        }
        return data;
    }

    private IomObject toIomGeometry(Blob geom) throws SQLException, ConverterException {
        int blobLenght = (int)geom.length();
        byte[] bv = geom.getBytes(1L, blobLenght);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }
}

