/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OraSequenceBasedIdGen
implements DbIdGen {
    public static final String SQL_ILI2DB_SEQ_NAME = "t_ili2db_seq";
    Connection conn = null;
    String dbusr = null;
    String schema = null;
    Long minValue = null;
    Long maxValue = null;
    Long startWith;
    long lastLocalId = 0L;

    public void init(String schema, Config config) {
        this.schema = schema;
        this.minValue = config.getMinIdSeqValue();
        this.maxValue = config.getMaxIdSeqValue();
        this.startWith = 1L;
    }

    public void initDb(Connection conn, String dbusr) {
        this.conn = conn;
        this.dbusr = dbusr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDbDefs(Generator gen) {
        DbTableName sqlName = new DbTableName(this.schema, SQL_ILI2DB_SEQ_NAME);
        String stmt = "CREATE SEQUENCE " + sqlName.getQName() + " START WITH " + this.startWith;
        if (this.minValue != null) {
            stmt = stmt + " MINVALUE " + this.minValue;
        }
        if (this.maxValue != null) {
            stmt = stmt + " MAXVALUE " + this.maxValue;
        }
        if (gen instanceof GeneratorJdbc) {
            GeneratorJdbc generatorJdbc = (GeneratorJdbc)gen;
            GeneratorJdbc generatorJdbc2 = (GeneratorJdbc)gen;
            generatorJdbc2.getClass();
            generatorJdbc.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc2, stmt));
            GeneratorJdbc generatorJdbc3 = (GeneratorJdbc)gen;
            GeneratorJdbc generatorJdbc4 = (GeneratorJdbc)gen;
            generatorJdbc4.getClass();
            generatorJdbc3.addDropLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc4, "DROP SEQUENCE " + sqlName.getQName()));
        }
        if (this.conn != null) {
            EhiLogger.traceBackendCmd((String)stmt);
            PreparedStatement updstmt = null;
            try {
                try {
                    updstmt = this.conn.prepareStatement(stmt);
                    updstmt.execute();
                }
                finally {
                    if (updstmt != null) {
                        updstmt.close();
                    }
                }
            }
            catch (SQLException ex) {
                EhiLogger.logError((String)("Failed to create sequence " + sqlName.getQName()), (Throwable)ex);
            }
        }
    }

    public long newObjSqlId() {
        this.lastLocalId = this.getSeqCount();
        return this.lastLocalId;
    }

    public long getLastSqlId() {
        return this.lastLocalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSeqCount() {
        String sqlName = SQL_ILI2DB_SEQ_NAME;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        try {
            Statement getstmt = null;
            ResultSet res = null;
            try {
                String stmt = "select " + sqlName + ".nextval from dual";
                EhiLogger.traceBackendCmd((String)stmt);
                getstmt = this.conn.prepareStatement(stmt);
                res = getstmt.executeQuery();
                long ret = 0L;
                if (!res.next()) throw new IllegalStateException("no nextval " + sqlName);
                long l = ret = res.getLong(1);
                return l;
            }
            finally {
                if (res != null) {
                    res.close();
                    res = null;
                }
                if (getstmt != null) {
                    getstmt.close();
                    getstmt = null;
                }
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("Failed to query " + sqlName), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public String getDefaultValueSql() {
        String sqlName = SQL_ILI2DB_SEQ_NAME;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        return sqlName + ".nextval ";
    }

    public void addMappingTable(DbSchema schema) {
    }
}

