/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.AbstractJdbcMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.sqlgen.generator.TextFileUtility;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleCustomStrategy
extends AbstractJdbcMapping {
    private static final String WRAPPER_FUNCTION = "ILI2ORA_SDO_GEOMETRY";
    private Connection conn = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromIliInit(Config config) {
        String schema = config.getDbschema();
        String strWrapperFunction = WRAPPER_FUNCTION;
        TextFileUtility txtOut = new TextFileUtility();
        if (schema != null && !schema.isEmpty()) {
            strWrapperFunction = schema + "." + strWrapperFunction;
        }
        StringBuilder stmt = new StringBuilder();
        stmt.append(txtOut.getIndent() + "CREATE OR REPLACE FUNCTION " + strWrapperFunction);
        stmt.append("(geom_input BLOB, srid NUMBER)" + txtOut.newline());
        txtOut.inc_ind();
        stmt.append(txtOut.getIndent() + "RETURN MDSYS.SDO_GEOMETRY IS geom MDSYS.SDO_GEOMETRY;" + txtOut.newline());
        txtOut.dec_ind();
        stmt.append(txtOut.getIndent() + "BEGIN" + txtOut.newline());
        txtOut.inc_ind();
        stmt.append(txtOut.getIndent() + "geom := NULL;" + txtOut.newline());
        stmt.append(txtOut.getIndent() + "IF geom_input IS NOT NULL THEN" + txtOut.newline());
        txtOut.inc_ind();
        stmt.append(txtOut.getIndent() + "geom := SDO_GEOMETRY(geom_input, srid);" + txtOut.newline());
        txtOut.dec_ind();
        stmt.append(txtOut.getIndent() + "END IF;" + txtOut.newline());
        stmt.append(txtOut.getIndent() + "RETURN(geom);" + txtOut.newline());
        txtOut.dec_ind();
        stmt.append(txtOut.getIndent() + "END;");
        String strStmt = stmt.toString();
        if (this.conn != null) {
            try (Statement dbstmt = null;){
                dbstmt = this.conn.createStatement();
                EhiLogger.traceBackendCmd((String)strStmt);
                dbstmt.execute(strStmt);
            }
            catch (SQLException e) {
                EhiLogger.logError((Throwable)e);
                throw new IllegalStateException("Failed to add function " + strWrapperFunction);
            }
        }
    }

    public void postConnect(Connection conn, Config config) {
        this.conn = conn;
    }
}

