/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.ROWID;

class RowidAccessor
extends Accessor {
    static final int max_length = 128;

    RowidAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 104, 9, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    RowidAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 104, 9, s, false);
        this.initForDescribe(104, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 128;
        this.byteLength = this.t_max_length + 2;
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            string = new String(this.rowSpaceByte, n2 + 2, (int)s);
        }
        return string;
    }

    Object getObject(int n) throws SQLException {
        return this.getROWID(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getROWID(n);
    }

    ROWID getROWID(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new ROWID(byArray);
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2 + 2, byArray, 0, s);
        }
        return byArray;
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getROWID(n);
    }
}

