/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBConversion db_conversion;
    long lob_offset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    boolean endOfStream;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    public OracleClobReader(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getInternalConnection()).getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobReader(CLOB cLOB, int n, long l) throws SQLException {
        if (cLOB == null || n <= 0 || cLOB.getInternalConnection() == null || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_conversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lob_offset = l;
        this.markedChar = -1L;
        this.buf = new char[n];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n;
        this.isClosed = false;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n3 = n;
        int n4 = n3 + Math.min(n2, cArray.length - n);
        n3 += this.writeChars(cArray, n3, n4 - n3);
        while (n3 < n4 && this.needChars()) {
            n3 += this.writeChars(cArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        long l2 = 0L;
        if ((long)(this.count - this.pos) >= l) {
            this.pos = (int)((long)this.pos + l);
            l2 += l;
        } else {
            l2 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l3 = this.clob.length() - this.lob_offset + 1L;
                if (l3 >= l - l2) {
                    this.lob_offset += l - l2;
                    l2 += l - l2;
                } else {
                    this.lob_offset += l3;
                    l2 += l3;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
        return l2;
    }
}

