/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora.sqlgen;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeneratorOracleSpatial
extends GeneratorJdbc {
    public static final String GENERAL_TABLESPACE = "generalTablespace";
    public static final String INDEX_TABLESPACE = "indexTablespace";
    public static final String LOB_TABLESPACE = "lobTableSpace";
    private static final int MAJOR_VERSION_SUPPORT_SEQ_AS_DEFAULT = 12;
    private static final int MINOR_VERSION_SUPPORT_SEQ_AS_DEFAULT = 1;
    private String generalTableSpace;
    private String indexTablespace;
    private String lobTablespace;
    private boolean useTriggerToSetTId = true;
    private DbColumn primaryKeyDefaultValue = null;
    private DbColumn primaryKeyCol = null;
    private List<DbColumn> lobCols;

    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String name;
        String isNull;
        String type = this.getOraType(column);
        String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        if (column instanceof DbColId && ((DbColId)column).isPrimaryKey()) {
            this.primaryKeyCol = column;
        }
        String defaultValue = "";
        if (column.getDefaultValue() != null) {
            defaultValue = " DEFAULT " + column.getDefaultValue();
            if (column.isPrimaryKey() && this.useTriggerToSetTId) {
                defaultValue = "";
                this.primaryKeyDefaultValue = column;
            }
        }
        if ((name = column.getName()).equals("file") && dbTab.getName().getName().equals("T_ILI2DB_MODEL")) {
            name = "\"" + name + "\"";
        }
        this.out.write(this.getIndent() + this.colSep + name + " " + type + defaultValue + " " + isNull + this.newline());
        this.colSep = ",";
    }

    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        this.generalTableSpace = config.getValue(GENERAL_TABLESPACE);
        this.indexTablespace = config.getValue(INDEX_TABLESPACE);
        this.lobTablespace = config.getValue(LOB_TABLESPACE);
        this.lobCols = new ArrayList<DbColumn>();
        if (this.conn != null) {
            try {
                DatabaseMetaData meta = this.conn.getMetaData();
                this.useTriggerToSetTId = true;
                int majorVersion = meta.getDatabaseMajorVersion();
                int minorVersion = meta.getDatabaseMinorVersion();
                this.useTriggerToSetTId = majorVersion < 12 || majorVersion == 12 && minorVersion < 1;
            }
            catch (SQLException e) {
                IOException iox = new IOException("It was not possible to get the Oracle version.");
                iox.initCause(e);
                throw iox;
            }
        }
    }

    public void visitIndex(DbIndex idx) throws IOException {
        if (!idx.isPrimary() && idx.isUnique()) {
            StringBuilder out = new StringBuilder();
            DbTable tab = idx.getTable();
            String tableName = tab.getName().getQName();
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            out.append(this.getIndent() + "ALTER TABLE " + tableName + " ADD CONSTRAINT " + constraintName + " UNIQUE (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                out.append(sep + attr.getName());
                sep = ",";
            }
            String tableSpace = "";
            if (this.indexTablespace != null) {
                tableSpace = " USING INDEX TABLESPACE " + this.indexTablespace;
            } else if (this.generalTableSpace != null) {
                tableSpace = " USING INDEX TABLESPACE " + this.generalTableSpace;
            }
            out.append(")" + tableSpace);
            String stmt = out.toString();
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, stmt));
            if (this.conn != null && this.createdTables.contains(tab.getName())) {
                this.executeUpdateStatement(stmt, "failed to add UNIQUE to table " + tab.getName());
            }
        }
    }

    public void visitTableBeginConstraint(DbTable dbTab) throws IOException {
        super.visitTableBeginConstraint(dbTab);
        Iterator dbColi = dbTab.iteratorColumn();
        while (dbColi.hasNext()) {
            DbColumn dbCol = (DbColumn)dbColi.next();
            if (dbCol.getReferencedTable() != null) {
                this.writeForeignKey(dbTab, dbCol);
            }
            this.writeValueRangeNumber(dbTab, dbCol);
        }
    }

    public void visit1TableEnd(DbTable tab) throws IOException {
        boolean tableExists = DbUtility.tableExists((Connection)this.conn, (DbTableName)tab.getName());
        this.executeCreateTable(tab);
        this.writePrimaryKey(tab);
        if (this.primaryKeyDefaultValue != null) {
            this.writeDefaultValueForPrimaryKey(tab);
            this.primaryKeyDefaultValue = null;
        }
        String sqlTabName = tab.getName().toString();
        String cmt = tab.getComment();
        if (cmt != null) {
            cmt = "COMMENT ON TABLE " + sqlTabName + " IS '" + GeneratorOracleSpatial.escapeString(cmt) + "'";
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, cmt));
            if (this.conn != null && !tableExists) {
                this.executeStatement(cmt, "Failed to add comment to table " + tab.getName());
            }
        }
        Iterator coli = tab.iteratorColumn();
        while (coli.hasNext()) {
            DbColumn col = (DbColumn)coli.next();
            cmt = col.getComment();
            if (cmt == null) continue;
            cmt = "COMMENT ON COLUMN " + sqlTabName + "." + col.getName() + " IS '" + GeneratorOracleSpatial.escapeString(cmt) + "'";
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, cmt));
            if (this.conn == null || tableExists) continue;
            this.executeStatement(cmt, "Failed to add comment to column " + tab.getName());
        }
    }

    protected String getTableEndOptions(DbTable dbTab) {
        String generalTablespacePart = "";
        StringBuilder lobTablespacePart = new StringBuilder();
        if (this.generalTableSpace != null) {
            generalTablespacePart = this.newline() + "TABLESPACE " + this.generalTableSpace;
        }
        if (this.lobTablespace != null && !this.lobCols.isEmpty()) {
            for (DbColumn lobColi : this.lobCols) {
                lobTablespacePart.append(this.newline() + "LOB (" + lobColi.getName() + ") STORE AS (TABLESPACE " + this.lobTablespace + ")");
            }
        }
        return generalTablespacePart + lobTablespacePart;
    }

    private void executeCreateTable(DbTable tab) throws IOException {
        this.dec_ind();
        String cmt = this.getTableEndOptions(tab);
        this.lobCols = new ArrayList<DbColumn>();
        this.out.write(this.getIndent() + ")" + cmt);
        String stmt = this.out.toString();
        this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, stmt));
        this.addDropLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, "DROP TABLE " + tab.getName()));
        this.out = null;
        if (this.conn != null) {
            if (DbUtility.tableExists((Connection)this.conn, (DbTableName)tab.getName())) {
                if (tab.isDeleteDataIfTableExists()) {
                    String delStmt = "DELETE FROM " + tab.getName();
                    this.executeUpdateStatement(delStmt, "Failed to delete data from table " + tab.getName());
                }
            } else {
                this.executeUpdateStatement(stmt, "Failed to create table " + tab.getName());
                this.createdTables.add(tab.getName());
            }
        }
    }

    private void writePrimaryKey(DbTable tab) throws IOException {
        String[] constraintCols = null;
        Iterator idxi = tab.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = (DbIndex)idxi.next();
            if (!idx.isPrimary()) continue;
            constraintCols = new String[idx.sizeAttr()];
            int coli = 0;
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                constraintCols[coli++] = attr.getName();
            }
        }
        if (this.primaryKeyCol != null) {
            constraintCols = new String[]{this.primaryKeyCol.getName()};
            this.primaryKeyCol = null;
        }
        if (constraintCols != null) {
            String constraintName = this.createConstraintName(tab, "pkey", constraintCols);
            String createstmt = "ALTER TABLE " + tab.getName() + " ADD CONSTRAINT " + constraintName + " PRIMARY KEY(" + this.stringJoin(",", constraintCols) + ")";
            if (this.indexTablespace != null) {
                createstmt = createstmt + " USING INDEX TABLESPACE " + this.indexTablespace;
            } else if (this.generalTableSpace != null) {
                createstmt = createstmt + " USING INDEX TABLESPACE " + this.generalTableSpace;
            }
            String dropstmt = "ALTER TABLE " + tab.getName() + " DROP CONSTRAINT " + constraintName;
            this.addConstraint(tab, constraintName, createstmt, dropstmt);
        }
    }

    private void writeDefaultValueForPrimaryKey(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().toString();
        String fieldName = this.primaryKeyDefaultValue.getName();
        String triggerName = "trg_" + tab.getName().getName() + "_" + fieldName;
        if (tab.getName().getSchema() != null) {
            triggerName = tab.getName().getSchema() + "." + triggerName;
        }
        StringBuilder trgQuery = new StringBuilder();
        trgQuery.append(this.getIndent() + "CREATE OR REPLACE TRIGGER " + triggerName + this.newline());
        trgQuery.append(this.getIndent() + "BEFORE INSERT ON " + sqlTabName + this.newline());
        trgQuery.append(this.getIndent() + "FOR EACH ROW" + this.newline());
        trgQuery.append(this.getIndent() + "BEGIN" + this.newline());
        this.inc_ind();
        trgQuery.append(this.getIndent() + "IF (:NEW." + fieldName + " is NULL) THEN" + this.newline());
        this.inc_ind();
        trgQuery.append(this.getIndent() + ":NEW." + fieldName + " := " + this.primaryKeyDefaultValue.getDefaultValue() + ";" + this.newline());
        this.dec_ind();
        trgQuery.append(this.getIndent() + "END IF;" + this.newline());
        this.dec_ind();
        trgQuery.append(this.getIndent() + "END;");
        String strTrgQuery = trgQuery.toString();
        this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, strTrgQuery));
        if (this.conn != null) {
            this.executeStatement(strTrgQuery, "Failed to add default value to " + tab.getName() + "." + fieldName);
        }
    }

    private String stringJoin(String sep, String[] eles) {
        StringBuilder ret = new StringBuilder();
        ret.append(eles[0]);
        for (int i = 1; i < eles.length; ++i) {
            ret.append(sep);
            ret.append(eles[i]);
        }
        return ret.toString();
    }

    private void writeForeignKey(DbTable dbTab, DbColumn dbCol) throws IOException {
        String createstmt = null;
        String action = "";
        String sqlTabName = dbTab.getName().getQName();
        if (dbCol.getOnUpdateAction() != null) {
            action = action + " ON UPDATE " + dbCol.getOnUpdateAction();
        }
        if (dbCol.getOnDeleteAction() != null) {
            action = action + " ON DELETE " + dbCol.getOnDeleteAction();
        }
        String constraintName = this.createConstraintName(dbTab, "fkey", new String[]{dbCol.getName()});
        createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " FOREIGN KEY ( " + dbCol.getName() + " ) REFERENCES " + dbCol.getReferencedTable().getQName() + action;
        createstmt = createstmt + " INITIALLY DEFERRED";
        String dropstmt = null;
        dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
        this.addConstraint(dbTab, constraintName, createstmt, dropstmt);
    }

    private void writeValueRangeNumber(DbTable dbTab, DbColumn dbCol) throws IOException {
        String min = this.getMinValue(dbCol);
        String max = this.getMaxValue(dbCol);
        if (min != null || max != null) {
            String sqlTabName = dbTab.getName().getQName();
            String action = "";
            action = max == null ? ">=" + min : (min == null ? "<=" + max : "BETWEEN " + min + " AND " + max);
            String constraintName = this.createConstraintName(dbTab, "check", new String[]{dbCol.getName()});
            String createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " CHECK( " + dbCol.getName() + " " + action + ")";
            String dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
            this.addConstraint(dbTab, constraintName, createstmt, dropstmt);
        }
    }

    private String getMinValue(DbColumn dbCol) {
        String result = null;
        if (dbCol instanceof DbColNumber) {
            Long minVal = ((DbColNumber)dbCol).getMinValue();
            result = minVal != null ? minVal.toString() : null;
        } else if (dbCol instanceof DbColDecimal) {
            Double minVal = ((DbColDecimal)dbCol).getMinValue();
            result = minVal != null ? minVal.toString() : null;
        }
        return result;
    }

    private String getMaxValue(DbColumn dbCol) {
        String result = null;
        if (dbCol instanceof DbColNumber) {
            Long maxVal = ((DbColNumber)dbCol).getMaxValue();
            result = maxVal != null ? maxVal.toString() : null;
        } else if (dbCol instanceof DbColDecimal) {
            Double maxVal = ((DbColDecimal)dbCol).getMaxValue();
            result = maxVal != null ? maxVal.toString() : null;
        }
        return result;
    }

    private String getOraType(DbColumn column) {
        String type;
        if (column instanceof DbColBoolean) {
            type = "NUMBER(1)";
        } else if (column instanceof DbColDateTime) {
            type = "TIMESTAMP";
        } else if (column instanceof DbColDate) {
            type = "DATE";
        } else if (column instanceof DbColTime) {
            type = "TIME";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DECIMAL(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            type = "MDSYS.SDO_GEOMETRY";
        } else if (column instanceof DbColId) {
            type = "NUMBER(9)";
        } else if (column instanceof DbColUuid) {
            type = "VARCHAR2(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "NUMBER(" + Integer.toString(col.getSize()) + ")";
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            if (colsize != -1) {
                type = "VARCHAR2(" + Integer.toString(colsize) + ")";
            } else {
                type = "CLOB";
                this.lobCols.add(column);
            }
        } else {
            type = "VARCHAR2(20)";
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(String cmt, String errorMessage) throws IOException {
        Statement dbstmt = null;
        try {
            try {
                dbstmt = this.conn.createStatement();
                EhiLogger.traceBackendCmd((String)cmt);
                dbstmt.execute(cmt);
            }
            finally {
                if (dbstmt != null) {
                    dbstmt.close();
                }
            }
        }
        catch (SQLException ex) {
            IOException iox = new IOException(errorMessage);
            iox.initCause(ex);
            throw iox;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateStatement(String stmt, String errorMessage) throws IOException {
        Statement dbstmt = null;
        try {
            try {
                dbstmt = this.conn.createStatement();
                EhiLogger.traceBackendCmd((String)stmt);
                dbstmt.executeUpdate(stmt);
            }
            finally {
                if (dbstmt != null) {
                    dbstmt.close();
                }
            }
        }
        catch (SQLException ex) {
            IOException iox = new IOException(errorMessage);
            iox.initCause(ex);
            throw iox;
        }
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }
}

