/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.view.GenericFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends JFileChooser {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(FileChooser.class);
    private boolean isOutputDirDialog = false;

    public FileChooser() {
    }

    public FileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public FileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public FileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public FileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public FileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    @Override
    public void approveSelection() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        FileFilter filter = this.getFileFilter();
        if (filter instanceof GenericFileFilter && GenericFileFilter.getFileExtension(selectedFile) == null) {
            selectedFile = new File(selectedFile.getAbsolutePath() + "." + ((GenericFileFilter)filter).getExtension());
            this.setSelectedFile(selectedFile);
        }
        if (this.getDialogType() == 0) {
            if (!selectedFile.isFile()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTfiledoesntexist"), this.getDialogTitle(), 0);
                return;
            }
        } else if (this.getDialogType() == 1) {
            if (selectedFile.exists()) {
                if (!selectedFile.canWrite()) {
                    JOptionPane.showMessageDialog(this, rsrc.getString("CTfileisntwriteable"), this.getDialogTitle(), 0);
                    return;
                }
                int response = JOptionPane.showConfirmDialog(this, rsrc.getString("CTfileexists"), this.getDialogTitle(), 1, 3);
                if (response == -1 || response == 2) {
                    this.cancelSelection();
                    return;
                }
                if (response != 0) {
                    return;
                }
            }
        } else if (this.isOutputDirDialog && selectedFile.exists()) {
            if (!selectedFile.canWrite()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTdirisntwriteable"), this.getDialogTitle(), 0);
                return;
            }
            int response = JOptionPane.showConfirmDialog(this, MessageFormat.format(rsrc, "CTdirexists", selectedFile.getAbsolutePath()), this.getDialogTitle(), 1, 3);
            if (response == -1 || response == 2) {
                this.cancelSelection();
                return;
            }
            if (response != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    public static boolean approveFile(String filename, Component parent, String dialogTitle) {
        File selectedFile = new File(filename);
        if (!selectedFile.exists()) {
            return true;
        }
        if (!selectedFile.canWrite()) {
            JOptionPane.showMessageDialog(parent, rsrc.getString("CTfileisntwriteable"), dialogTitle, 0);
            return false;
        }
        int response = JOptionPane.showConfirmDialog(parent, rsrc.getString("CTfileexists"), dialogTitle, 1, 3);
        if (response == -1 || response == 2) {
            return false;
        }
        return response == 0;
    }

    public int showOutputDirDialog(Component parent) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CToutputDirTitle"));
        this.isOutputDirDialog = true;
        int ret = 1;
        try {
            ret = this.showDialog(parent, rsrc.getString("CTdirectoryApproveButton"));
        }
        finally {
            this.isOutputDirDialog = false;
        }
        return ret;
    }

    public int showInputDirDialog(Component parent) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CTinputDirTitle"));
        return this.showDialog(parent, rsrc.getString("CTdirectoryApproveButton"));
    }
}

