/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2mysql;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2mysql.GeneratorMysql;
import ch.ehi.ili2mysql.MySqlIdGen;
import ch.ehi.ili2mysql.MysqlColumnConverter;
import ch.ehi.ili2mysql.MysqlCustomStrategy;
import java.text.ParseException;

public class MysqlMain
extends AbstractMain {
    @Override
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(MysqlColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorMysql.class.getName());
        config.setJdbcDriver("com.mysql.jdbc.Driver");
        config.setIdGenerator(MySqlIdGen.class.getName());
        config.setIli2dbCustomStrategy(MysqlCustomStrategy.class.getName());
        config.setUuidDefaultValue("uuid()");
        config.setValue("ch.ehi.ili2db.modelsTabModelnameColSize", "400");
        config.setValue("ch.ehi.ili2db.attrTabSqlnameColSize", "95");
        config.setValue("ch.ehi.ili2db.attrTabOwnerColSize", "95");
        config.setValue("ch.ehi.ili2db.classnameTabIlinameColSize", "766");
        config.setValue("ch.ehi.ili2db.inheritTabThisColSize", "766");
    }

    @Override
    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            @Override
            public String makeUrl(Config config) {
                if (config.getDbdatabase() != null) {
                    if (config.getDbhost() != null) {
                        if (config.getDbport() != null) {
                            return "jdbc:mysql://" + config.getDbhost() + ":" + config.getDbport() + "/" + config.getDbdatabase();
                        }
                        return "jdbc:mysql://" + config.getDbhost() + "/" + config.getDbdatabase();
                    }
                    return "jdbc:mysql:///" + config.getDbdatabase();
                }
                return null;
            }
        };
    }

    @Override
    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return null;
    }

    public static void main(String[] args) {
        new MysqlMain().domain(args);
    }

    @Override
    public String getAPP_NAME() {
        return "ili2mysql";
    }

    @Override
    public String getDB_PRODUCT_NAME() {
        return "mysql";
    }

    @Override
    public String getJAR_NAME() {
        return "ili2mysql.jar";
    }

    @Override
    protected void printConnectOptions() {
        System.err.println("--dbhost  host         The host name of the server. Defaults to localhost.");
        System.err.println("--dbport  port         The port number the server is listening on. Defaults to 3306.");
        System.err.println("--dbdatabase database  The database name.");
        System.err.println("--dbusr  username      User name to access database.");
        System.err.println("--dbpwd  password      Password of user used to access database.");
    }

    @Override
    protected void printSpecificOptions() {
        System.err.println("--oneGeomPerTable      If more than one geometry per table, create secondary table.");
    }

    @Override
    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbhost")) {
            config.setDbhost(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbport")) {
            config.setDbport(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbdatabase")) {
            config.setDbdatabase(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbusr")) {
            config.setDbusr(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbpwd")) {
            config.setDbpwd(args[++argi]);
            ++argi;
        } else if (this.isOption(arg, "--oneGeomPerTable")) {
            config.setOneGeomPerTable(this.parseBooleanArgument(arg));
            ++argi;
        }
        return argi;
    }
}

