/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.gui.Config;
import ch.interlis.ilirepository.IliResolver;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;

public class IliFromDb
implements IliResolver {
    private String uri = null;
    private Connection conn = null;
    private String schema = null;
    private boolean isVer3_export = false;

    public IliFromDb(String dburi, Connection conn, String schema, Config config) {
        this.uri = dburi;
        this.conn = conn;
        this.schema = schema;
        this.isVer3_export = config.isVer3_export();
    }

    public InputStream resolveIliFile(String dburi, String filename) throws IOException {
        String file = null;
        try {
            file = TransferFromIli.readIliFile(this.conn, this.schema, filename, this.isVer3_export);
        }
        catch (Ili2dbException e) {
            throw new IOException(e);
        }
        if (file == null) {
            throw new FileNotFoundException("file <" + filename + "> not found in " + dburi);
        }
        return new ByteArrayInputStream(file.getBytes("UTF-8"));
    }

    public boolean resolvesUri(String uri) {
        return uri != null && uri.equals(this.uri);
    }
}

