/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.json;

import ch.ehi.ili2db.json.Iox2jsonUtility;
import ch.interlis.ili2c.metamodel.AbstractSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class Iox2json {
    protected JsonGenerator jg = null;
    protected TransferDescription td = null;

    @Deprecated
    public static void write(JsonGenerator jg, IomObject[] objs, TransferDescription td) throws IOException {
        Iox2jsonUtility.write(jg, objs, td);
    }

    @Deprecated
    public static void writeRaw(JsonGenerator jg, IomObject[] objs) throws IOException {
        Iox2jsonUtility.writeRaw(jg, objs);
    }

    @Deprecated
    public static void writeRaw(JsonGenerator jg, IomObject obj, TransferDescription td) throws IOException {
        Iox2jsonUtility.writeRaw(jg, obj, td);
    }

    @Deprecated
    public static void writeArray(JsonGenerator jg, String[] iomValues, AttributeDef attr, boolean isEnumInt) throws IOException {
        Iox2jsonUtility.writeArray(jg, iomValues, attr, isEnumInt);
    }

    @Deprecated
    public static IomObject[] read(JsonParser jg) throws IOException {
        return Iox2jsonUtility.read(jg);
    }

    @Deprecated
    public static IomObject readOneObject(JsonParser jg) throws IOException {
        return Iox2jsonUtility.readOneObject(jg);
    }

    @Deprecated
    public static String[] readArray(JsonParser jg) throws IOException {
        return Iox2jsonUtility.readArray(jg);
    }

    public Iox2json(JsonGenerator jg, TransferDescription td) throws IOException {
        this.jg = jg;
        this.td = td;
    }

    public void write(IomObject[] objs) throws IOException {
        if (objs.length == 1) {
            Iox2jsonUtility.writeRaw(this.jg, objs[0], null);
        } else {
            this.jg.writeStartArray();
            for (IomObject obj : objs) {
                Iox2jsonUtility.writeRaw(this.jg, obj, null);
            }
            this.jg.writeEndArray();
        }
    }

    public void write(IomObject obj) throws IOException {
        this.write(obj, null, null);
    }

    public void write(IomObject obj, String bid, String topic) throws IOException {
        String refoid;
        String refbid;
        int op;
        this.jg.writeStartObject();
        String className = obj.getobjecttag();
        this.jg.writeStringField("@type", className);
        String oid = obj.getobjectoid();
        if (oid != null) {
            this.jg.writeStringField("@id", oid);
        }
        if (bid != null && bid.length() > 0) {
            this.jg.writeStringField("@bid", bid);
        }
        if (topic != null && topic.length() > 0) {
            this.jg.writeStringField("@topic", topic);
        }
        if ((op = obj.getobjectoperation()) == 2) {
            this.jg.writeStringField("@operation", "DELETE");
        } else if (op == 1) {
            this.jg.writeStringField("@operation", "UPDATE");
        }
        int consistency = obj.getobjectconsistency();
        if (consistency == 2) {
            this.jg.writeStringField("@consistency", "INCONSISTENT");
        } else if (consistency == 1) {
            this.jg.writeStringField("@consistency", "INCOMPLETE");
        } else if (consistency == 3) {
            this.jg.writeStringField("@consistency", "ADAPTED");
        }
        long orderpos = obj.getobjectreforderpos();
        if (orderpos != 0L) {
            this.jg.writeNumberField("@orderpos", orderpos);
        }
        if ((refbid = obj.getobjectrefbid()) != null) {
            this.jg.writeStringField("@refbid", refbid);
        }
        if ((refoid = obj.getobjectrefoid()) != null) {
            this.jg.writeStringField("@ref", refoid);
        }
        Viewable aclass = null;
        if (this.td != null) {
            aclass = (Viewable)this.td.getElement(className);
        }
        if (aclass != null) {
            Iterator attri = aclass.getAttributesAndRoles2();
            while (attri.hasNext()) {
                String propName;
                ViewableTransferElement propDef = (ViewableTransferElement)attri.next();
                if (propDef.obj instanceof AttributeDef) {
                    Type proxyType;
                    AttributeDef attr = (AttributeDef)propDef.obj;
                    if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                    propName = attr.getName();
                    if (attr.isDomainBoolean()) {
                        this.writeBooleanAttr(obj, propName);
                        continue;
                    }
                    Type type = attr.getDomainResolvingAll();
                    if (type instanceof CompositionType) {
                        this.writeStructAttr(obj, propName);
                        continue;
                    }
                    if (type instanceof NumericType) {
                        this.writeNumericAttr(obj, propName);
                        continue;
                    }
                    if (type instanceof CoordType) {
                        this.writeCoordAttr(obj, propName);
                        continue;
                    }
                    if (type instanceof AbstractSurfaceOrAreaType) {
                        this.writeSurfaceAttr(obj, propName, (AbstractSurfaceOrAreaType)type);
                        continue;
                    }
                    if (type instanceof PolylineType || type instanceof MultiPolylineType) {
                        this.writeLineAttr(obj, propName, (LineType)type);
                        continue;
                    }
                    this.writeStringAttr(obj, propName);
                    continue;
                }
                if (propDef.obj instanceof RoleDef) {
                    RoleDef role = (RoleDef)propDef.obj;
                    AssociationDef roleOwner = (AssociationDef)role.getContainer();
                    if (roleOwner.getDerivedFrom() != null) continue;
                    propName = role.getName();
                    this.writeStructAttr(obj, propName);
                    continue;
                }
                throw new IllegalStateException("unexpected property " + propDef.obj);
            }
        } else {
            int i;
            boolean isNumeric = false;
            if (className.equals("COORD") || className.equals("ARC")) {
                isNumeric = true;
            }
            int attrc = obj.getattrcount();
            Object[] propNames = new String[attrc];
            for (i = 0; i < attrc; ++i) {
                propNames[i] = obj.getattrname(i);
            }
            Arrays.sort(propNames);
            for (i = 0; i < attrc; ++i) {
                Object propName = propNames[i];
                int propc = obj.getattrvaluecount((String)propName);
                if (propc <= 0) continue;
                this.jg.writeFieldName((String)propName);
                if (propc > 1) {
                    this.jg.writeStartArray();
                }
                for (int propi = 0; propi < propc; ++propi) {
                    String value = obj.getattrprim((String)propName, propi);
                    if (value != null) {
                        if (isNumeric) {
                            this.jg.writeNumber(value);
                            continue;
                        }
                        this.jg.writeString(value);
                        continue;
                    }
                    IomObject structvalue = obj.getattrobj((String)propName, propi);
                    this.write(structvalue);
                }
                if (propc <= 1) continue;
                this.jg.writeEndArray();
            }
        }
        this.jg.writeEndObject();
    }

    protected void writeStringAttr(IomObject obj, String propName) throws IOException {
        String value = obj.getattrprim(propName, 0);
        if (value != null) {
            this.jg.writeStringField(propName, value);
        }
    }

    protected void writeCoordAttr(IomObject obj, String propName) throws IOException {
        IomObject structvalue = obj.getattrobj(propName, 0);
        if (structvalue != null) {
            this.jg.writeFieldName(propName);
            this.write(structvalue);
        }
    }

    protected void writeLineAttr(IomObject obj, String propName, LineType type) throws IOException {
        IomObject structvalue = obj.getattrobj(propName, 0);
        if (structvalue != null) {
            this.jg.writeFieldName(propName);
            this.write(structvalue);
        }
    }

    protected void writeSurfaceAttr(IomObject obj, String propName, AbstractSurfaceOrAreaType type) throws IOException {
        IomObject structvalue = obj.getattrobj(propName, 0);
        if (structvalue != null) {
            this.jg.writeFieldName(propName);
            this.write(structvalue);
        }
    }

    protected void writeNumericAttr(IomObject obj, String propName) throws IOException {
        String value = obj.getattrprim(propName, 0);
        if (value != null) {
            this.jg.writeFieldName(propName);
            this.jg.writeNumber(value);
        }
    }

    protected void writeStructAttr(IomObject obj, String propName) throws IOException {
        int propc = obj.getattrvaluecount(propName);
        if (propc > 0) {
            this.jg.writeFieldName(propName);
            if (propc > 1) {
                this.jg.writeStartArray();
            }
            for (int propi = 0; propi < propc; ++propi) {
                IomObject structvalue = obj.getattrobj(propName, propi);
                this.write(structvalue);
            }
            if (propc > 1) {
                this.jg.writeEndArray();
            }
        }
    }

    protected void writeBooleanAttr(IomObject obj, String propName) throws IOException {
        String value = obj.getattrprim(propName, 0);
        if (value != null) {
            if (value.equals("true")) {
                this.jg.writeBooleanField(propName, true);
            } else {
                this.jg.writeBooleanField(propName, false);
            }
        }
    }
}

