/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.toxtf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.fromxtf.BasketStat;
import ch.ehi.ili2db.fromxtf.ClassStat;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.StructAttrPath;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.ili2db.toxtf.AbstractStructWrapper;
import ch.ehi.ili2db.toxtf.EmbeddedLinkWrapper;
import ch.ehi.ili2db.toxtf.FixIomObjectRefs;
import ch.ehi.ili2db.toxtf.FixIomObjectRefsSerializer;
import ch.ehi.ili2db.toxtf.SqlidPool;
import ch.ehi.ili2db.toxtf.StructWrapper;
import ch.ehi.ili2db.toxtf.ToXtfRecordConverter;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.ArrayPoolImpl;
import ch.ehi.iox.objpool.impl.Serializer;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.generator.IndentPrintWriter;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.iligml.Iligml10Writer;
import ch.interlis.iom_j.iligml.Iligml20Writer;
import ch.interlis.iom_j.itf.ItfWriter;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.filter.ReduceToBaseModel;
import ch.interlis.iox_j.filter.Rounder;
import ch.interlis.iox_j.filter.TranslateToTranslation;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.plugins.PluginLoader;
import ch.interlis.iox_j.validator.ValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransferToXtf {
    private NameMapping ili2sqlName = null;
    private TransferDescription td = null;
    private Connection conn = null;
    private String schema = null;
    private String colT_ID = null;
    private boolean createTypeDiscriminator = false;
    private boolean writeIliTid = false;
    private boolean hasIliTidCol = false;
    private SqlColumnConverter geomConv = null;
    private ToXtfRecordConverter recConv = null;
    private Viewable2TableMapping class2wrapper = null;
    private Config config = null;
    private CustomMapping customMapping = null;
    private Validator validator = null;
    private HashMap tag2class = null;
    private SqlidPool sqlidPool = new SqlidPool();
    private ObjectPoolManager recman = null;
    private ArrayPoolImpl<FixIomObjectRefs> delayedObjects = null;
    private IndentPrintWriter expgen = null;
    private TranslateToTranslation languageFilter = null;
    private Rounder rounder = null;
    private ReduceToBaseModel exportBaseModelFilter = null;
    private Integer defaultCrsCode = null;
    private Map<Element, Element> crsFilter = null;
    private Map<Element, Element> crsFilterToTarget = null;
    boolean ignoreUnresolvedReferences = false;
    private Integer fetchSize = null;
    private ArrayList enumTypes = new ArrayList();
    private ArrayList addanyLines = new ArrayList();
    private Map<String, BasketStat> basketStat = null;
    private HashMap<String, ClassStat> objStat = new HashMap();

    public TransferToXtf(NameMapping ili2sqlName1, TransferDescription td1, Connection conn1, SqlColumnConverter geomConv, Config config, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1) {
        this.ili2sqlName = ili2sqlName1;
        this.td = td1;
        this.class2wrapper = class2wrapper1;
        this.tag2class = XSDGenerator.getTagMap((TransferDescription)this.td);
        this.conn = conn1;
        this.schema = config.getDbschema();
        this.colT_ID = config.getColT_ID();
        if (this.colT_ID == null) {
            this.colT_ID = "T_Id";
        }
        if (config.getDefaultSrsCode() != null) {
            this.defaultCrsCode = Integer.parseInt(config.getDefaultSrsCode());
        }
        this.fetchSize = config.getFetchSize();
        this.createTypeDiscriminator = "always".equals(config.getCreateTypeDiscriminator());
        this.writeIliTid = config.isExportTid();
        this.hasIliTidCol = "property".equals(config.getTidHandling());
        this.geomConv = geomConv;
        this.recConv = new ToXtfRecordConverter(this.td, this.ili2sqlName, config, null, geomConv, this.conn, this.sqlidPool, trafoConfig, this.class2wrapper, this.schema);
        this.config = config;
        this.recman = new ObjectPoolManager();
    }

    public void doit(int function, String datasource, IoxWriter iomFile, String sender, String[] exportParamModelnames, long[] basketSqlIds, Map<String, BasketStat> stat, CustomMapping customMapping1) throws IoxException, Ili2dbException {
        this.basketStat = stat;
        this.customMapping = customMapping1;
        boolean referrs = false;
        this.ignoreUnresolvedReferences = this.config.isSkipReferenceErrors();
        if (!this.hasIliTidCol && this.writeIliTid) {
            throw new Ili2dbException("TID export requires a T_Ili_Tid column");
        }
        if (function != 8 && iomFile instanceof ItfWriter) {
            this.config.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
        }
        if (!this.config.isVer3_translation() || this.config.getIli1Translation() != null) {
            this.languageFilter = new TranslateToTranslation(this.td, (Settings)this.config);
        }
        this.rounder = this.config.isDisableRounding() ? null : new Rounder(this.td, this.config);
        String srsAssignment = this.config.getSrsModelAssignment();
        if (srsAssignment != null) {
            this.crsFilter = TransferFromIli.getSrsMappingToOriginal(this.td, srsAssignment);
            this.crsFilterToTarget = TransferFromIli.getSrsMappingToAlternate(this.td, srsAssignment);
        }
        if (this.config.getExportModels() != null) {
            List<Model> exportModels = Ili2db.getModels(this.config.getExportModels(), this.td);
            this.exportBaseModelFilter = new ReduceToBaseModel(exportModels, this.td, (Settings)this.config);
        }
        if (this.config.isValidation()) {
            ValidationConfig modelConfig = new ValidationConfig();
            modelConfig.mergeIliMetaAttrs(this.td);
            String[] configFilename = this.config.getValidConfigFile();
            if (configFilename != null) {
                try {
                    modelConfig.mergeConfigFile(new File((String)configFilename));
                }
                catch (IOException e) {
                    EhiLogger.logError((String)("failed to read validator config file <" + (String)configFilename + ">"));
                }
            }
            modelConfig.setConfigValue("PARAMETER", "areaOverlapValidation", this.config.isDisableAreaValidation() ? "off" : null);
            modelConfig.setConfigValue("PARAMETER", "defaultGeometryTypeValidation", this.config.isSkipGeometryErrors() ? "off" : null);
            modelConfig.setConfigValue("PARAMETER", "allowOnlyMultiplicityReduction", this.config.isOnlyMultiplicityReduction() ? "on" : null);
            if (this.rounder == null) {
                modelConfig.setConfigValue("PARAMETER", "disableRounding", "true");
            }
            Log2EhiLogger errHandler = new Log2EhiLogger();
            LogEventFactory errFactory = new LogEventFactory();
            errFactory.setDataSource(datasource);
            if (iomFile instanceof Iligml10Writer || iomFile instanceof Iligml20Writer) {
                String crsAuthority = this.config.getDefaultSrsAuthority();
                String crsCode = this.config.getDefaultSrsCode();
                if (crsAuthority != null && crsCode != null && function != 8) {
                    if (iomFile instanceof Iligml10Writer) {
                        ((Iligml10Writer)iomFile).setDefaultCrs(crsAuthority + ":" + crsCode);
                    } else if (iomFile instanceof Iligml20Writer) {
                        ((Iligml20Writer)iomFile).setDefaultCrs(crsAuthority + ":" + crsCode);
                    }
                }
            }
            PipelinePool pipelinePool = new PipelinePool();
            TransferToXtf.AddFunctionsFromPluginFolder(this.config, this.config.getPluginsFolder());
            this.validator = new Validator(this.td, (IoxValidationConfig)modelConfig, (IoxLogging)errHandler, errFactory, pipelinePool, (Settings)this.config);
        }
        StartTransferEvent startEvent = new StartTransferEvent();
        startEvent.setSender(sender);
        if (this.languageFilter != null) {
            startEvent = (StartTransferEvent)this.languageFilter.filter((IoxEvent)startEvent);
        }
        if (this.exportBaseModelFilter != null) {
            startEvent = (StartTransferEvent)this.exportBaseModelFilter.filter((IoxEvent)startEvent);
        }
        if (this.rounder != null) {
            startEvent = (StartTransferEvent)this.rounder.filter((IoxEvent)startEvent);
        }
        if (this.validator != null) {
            this.validator.validate((IoxEvent)startEvent);
        }
        if (function != 8) {
            iomFile.write((IoxEvent)startEvent);
        }
        if (basketSqlIds != null) {
            for (String basketSqlId : (String[])basketSqlIds) {
                StringBuilder basketXtfId = new StringBuilder();
                Map<String, String> genericDomains = new HashMap<String, String>();
                Topic topic = this.getTopicByBasketId((long)basketSqlId, basketXtfId, genericDomains);
                if (this.config.getDomainAssignments() != null) {
                    EhiLogger.logState((String)("domain assignments <" + this.config.getDomainAssignments() + ">"));
                    genericDomains = Xtf24Reader.parseDomains((String)this.config.getDomainAssignments());
                }
                if (topic == null) {
                    throw new IoxException("no basketId " + (long)basketSqlId + " in db");
                }
                if (basketXtfId.length() == 0) {
                    basketXtfId.append((long)basketSqlId);
                }
                referrs = referrs || this.doBasket(function, datasource, iomFile, topic, (long)basketSqlId, basketXtfId.toString(), genericDomains);
            }
        } else {
            for (String modelName : exportParamModelnames) {
                Element mObj = this.td.getElement(Model.class, modelName);
                if (mObj == null || !(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
                Model model = (Model)mObj;
                for (Object tObj : model) {
                    if (!(tObj instanceof Topic) || this.suppressTopic((Topic)tObj)) continue;
                    Topic topic = (Topic)tObj;
                    String basketXtfId = topic.getScopedName();
                    Map<String, String> genericDomains = new HashMap<String, String>();
                    if (topic.getBasketOid() != null && (basketXtfId = this.getBasketSqlIdsFromTopic(topic.getScopedName(), genericDomains)) == null) continue;
                    if (this.config.getDomainAssignments() != null) {
                        EhiLogger.logState((String)("domain assignments <" + this.config.getDomainAssignments() + ">"));
                        genericDomains = Xtf24Reader.parseDomains((String)this.config.getDomainAssignments());
                    }
                    referrs = referrs || this.doBasket(function, datasource, iomFile, topic, null, basketXtfId, genericDomains);
                }
            }
        }
        if (referrs) {
            throw new IoxException("dangling references");
        }
        EndTransferEvent endEvent = new EndTransferEvent();
        if (this.languageFilter != null) {
            endEvent = (EndTransferEvent)this.languageFilter.filter((IoxEvent)endEvent);
        }
        if (this.exportBaseModelFilter != null) {
            endEvent = (EndTransferEvent)this.exportBaseModelFilter.filter((IoxEvent)endEvent);
        }
        if (this.rounder != null) {
            endEvent = (EndTransferEvent)this.rounder.filter((IoxEvent)endEvent);
        }
        if (this.validator != null) {
            this.validator.validate((IoxEvent)endEvent);
        }
        if (function != 8) {
            iomFile.write((IoxEvent)endEvent);
        }
        if (this.validator != null) {
            this.validator.close();
        }
        if (this.languageFilter != null) {
            this.languageFilter.close();
        }
        if (this.exportBaseModelFilter != null) {
            this.exportBaseModelFilter.close();
        }
        this.recman.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBasketSqlIdsFromTopic(String topicName, Map<String, String> genericDomains) throws IoxException {
        String sqlName = "T_ILI2DB_BASKET";
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        String bid = null;
        String domains = null;
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT T_Ili_Tid,domains FROM " + sqlName + " WHERE " + "topic" + "= ?";
            if (this.config.isVer3_export()) {
                stmt = "SELECT T_Ili_Tid FROM " + sqlName + " WHERE " + "topic" + "= ?";
            }
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            getstmt.setString(1, topicName);
            res = getstmt.executeQuery();
            if (res.next()) {
                bid = res.getString(1);
                if (!this.config.isVer3_export()) {
                    domains = res.getString(2);
                }
            }
            if (res.next()) {
                throw new IoxException("multiple Baskets of Topic " + topicName + " in table " + sqlName);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + sqlName), (Throwable)ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                    res = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                    getstmt = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        if (bid != null) {
            Topic topic = TransferToXtf.getTopicDef(this.td, topicName);
            if (topic == null) {
                throw new IoxException("unknown Topic " + topicName + " in table " + sqlName);
            }
            if (this.config.getCrsExportModels() != null) {
                Topic crsTranslatedTopic1 = (Topic)this.crsFilter.get(topic);
                Topic crsTranslatedTopic2 = (Topic)this.crsFilterToTarget.get(topic);
                if (crsTranslatedTopic1 != null && crsTranslatedTopic1.getContainer().getName().equals(this.config.getCrsExportModels())) {
                    topic = crsTranslatedTopic1;
                } else if (crsTranslatedTopic2 != null && crsTranslatedTopic2.getContainer().getName().equals(this.config.getCrsExportModels())) {
                    topic = crsTranslatedTopic2;
                }
            }
            if (domains != null) {
                genericDomains.putAll(Xtf24Reader.parseDomains(domains));
            }
            return bid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic getTopicByBasketId(long basketSqlId, StringBuilder basketXtfId, Map<String, String> genericDomains) throws IoxException {
        String sqlName = "T_ILI2DB_BASKET";
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        String topicName = null;
        String bid = null;
        String domains = null;
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT topic,T_Ili_Tid,domains FROM " + sqlName + " WHERE " + this.colT_ID + "= ?";
            if (this.config.isVer3_export()) {
                stmt = "SELECT topic,T_Ili_Tid FROM " + sqlName + " WHERE " + this.colT_ID + "= ?";
            }
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            getstmt.setLong(1, basketSqlId);
            res = getstmt.executeQuery();
            if (res.next()) {
                topicName = res.getString(1);
                bid = res.getString(2);
                if (!this.config.isVer3_export()) {
                    domains = res.getString(3);
                }
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + sqlName), (Throwable)ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                res = null;
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                getstmt = null;
            }
        }
        if (topicName != null) {
            Topic topic = TransferToXtf.getTopicDef(this.td, topicName);
            if (topic == null) {
                throw new IoxException("unknown Topic " + topicName + " in table " + sqlName);
            }
            if (this.config.getCrsExportModels() != null) {
                Topic crsTranslatedTopic1 = (Topic)this.crsFilter.get(topic);
                Topic crsTranslatedTopic2 = (Topic)this.crsFilterToTarget.get(topic);
                if (crsTranslatedTopic1 != null && crsTranslatedTopic1.getContainer().getName().equals(this.config.getCrsExportModels())) {
                    topic = crsTranslatedTopic1;
                } else if (crsTranslatedTopic2 != null && crsTranslatedTopic2.getContainer().getName().equals(this.config.getCrsExportModels())) {
                    topic = crsTranslatedTopic2;
                }
            }
            if (bid != null) {
                basketXtfId.append(bid);
            }
            if (domains != null) {
                genericDomains.putAll(Xtf24Reader.parseDomains(domains));
            }
            return topic;
        }
        return null;
    }

    public static Topic getTopicDef(TransferDescription td, String topicQName) {
        String modelName = null;
        String topicName = null;
        int endModelName = topicQName.indexOf(46);
        if (endModelName <= 0) {
            topicName = topicQName;
        } else {
            modelName = topicQName.substring(0, endModelName);
            topicName = topicQName.substring(endModelName + 1);
        }
        for (Object mObj : td) {
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            if (modelName != null && !modelName.equals(model.getName())) continue;
            for (Object tObj : model) {
                Topic topic;
                if (!(tObj instanceof Topic) || !topicName.equals((topic = (Topic)tObj).getName())) continue;
                return topic;
            }
        }
        return null;
    }

    private boolean doBasket(int function, String datasource, IoxWriter iomFile, Topic topic, Long basketSqlId, String basketXtfId, Map<String, String> genericDomains) throws IoxException {
        Model model = (Model)topic.getContainer();
        boolean referrs = false;
        StartBasketEvent iomBasket = null;
        if (this.delayedObjects != null) {
            this.delayedObjects.close();
        }
        this.delayedObjects = new ArrayPoolImpl(this.recman, (Serializer)new FixIomObjectRefsSerializer());
        Iterator iter = null;
        if (iomFile instanceof ItfWriter) {
            ArrayList itftablev = ModelUtilities.getItfTables((TransferDescription)this.td, (String)model.getName(), (String)topic.getName());
            iter = itftablev.iterator();
        } else {
            iter = topic.getViewables().iterator();
        }
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Viewable) {
                ViewableWrapper wrapper;
                DbTableName sqlName;
                Viewable aclass0;
                if (obj instanceof View && !TransferFromIli.isTransferableView(obj) || TransferToXtf.suppressViewable((Viewable)obj)) continue;
                Viewable aclass = (Viewable)obj;
                if (this.languageFilter != null) {
                    aclass = (Viewable)aclass.getTranslationOfOrSame();
                }
                Viewable iomTargetClass = aclass;
                if (this.crsFilter != null && (aclass0 = (Viewable)this.crsFilter.get(aclass)) != null) {
                    aclass = aclass0;
                }
                if (this.customMapping.tableExists(this.conn, sqlName = this.recConv.getSqlType((wrapper = this.class2wrapper.get(aclass)).getViewable()))) {
                    if (iomBasket == null) {
                        EhiLogger.logState((String)(topic.getScopedName(null) + " BID <" + basketXtfId + ">..."));
                        iomBasket = new StartBasketEvent(topic.getScopedName(null), basketXtfId, genericDomains);
                        if (this.languageFilter != null) {
                            iomBasket = (StartBasketEvent)this.languageFilter.filter((IoxEvent)iomBasket);
                        }
                        if (this.exportBaseModelFilter != null) {
                            iomBasket = (StartBasketEvent)this.exportBaseModelFilter.filter((IoxEvent)iomBasket);
                        }
                        if (this.rounder != null) {
                            iomBasket = (StartBasketEvent)this.rounder.filter((IoxEvent)iomBasket);
                        }
                        if (this.validator != null) {
                            this.validator.validate((IoxEvent)iomBasket);
                        }
                        if (function != 8) {
                            iomFile.write((IoxEvent)iomBasket);
                        }
                    }
                    EhiLogger.logState((String)(aclass.getScopedName(null) + "..."));
                    this.dumpObject(function, iomFile, aclass, iomTargetClass, basketSqlId, genericDomains);
                    continue;
                }
                EhiLogger.traceUnusualState((String)(aclass.getScopedName(null) + "...skipped; no table " + sqlName + " in db"));
                continue;
            }
            if (!(obj instanceof AttributeDef) || !(iomFile instanceof ItfWriter)) continue;
            AttributeDef attr = (AttributeDef)obj;
            Integer epsgCode = TransferFromIli.getEpsgCode(attr, genericDomains, this.defaultCrsCode);
            DbTableName sqlName = this.getSqlTableNameItfLineTable(attr, epsgCode);
            if (this.customMapping.tableExists(this.conn, sqlName)) {
                EhiLogger.logState((String)(attr.getContainer().getScopedName(null) + "_" + attr.getName() + "..."));
                if (iomBasket == null) {
                    iomBasket = new StartBasketEvent(topic.getScopedName(null), topic.getScopedName(null));
                    if (this.languageFilter != null) {
                        iomBasket = (StartBasketEvent)this.languageFilter.filter((IoxEvent)iomBasket);
                    }
                    if (this.exportBaseModelFilter != null) {
                        iomBasket = (StartBasketEvent)this.exportBaseModelFilter.filter((IoxEvent)iomBasket);
                    }
                    if (this.rounder != null) {
                        iomBasket = (StartBasketEvent)this.rounder.filter((IoxEvent)iomBasket);
                    }
                    if (this.validator != null) {
                        this.validator.validate((IoxEvent)iomBasket);
                    }
                    if (function != 8) {
                        iomFile.write((IoxEvent)iomBasket);
                    }
                }
                this.dumpItfTableObject(function, iomFile, attr, epsgCode, basketSqlId);
                continue;
            }
            EhiLogger.traceUnusualState((String)(attr.getScopedName(null) + "...skipped; no table " + sqlName + " in db"));
        }
        if (iomBasket != null) {
            for (FixIomObjectRefs fixref : this.delayedObjects) {
                boolean skipObj = false;
                for (IomObject ref : fixref.getRefs()) {
                    long sqlid = fixref.getTargetSqlid(ref);
                    String sqlTargetTable = fixref.getTargetSqlTable(ref);
                    if (this.sqlidPool.containsSqlid(sqlTargetTable, sqlid)) {
                        ref.setobjectrefoid(this.sqlidPool.getXtfid(sqlTargetTable, sqlid));
                        continue;
                    }
                    Viewable aclass = (Viewable)this.tag2class.get(fixref.getTargetClass(ref));
                    String tid = this.readObjectTid(aclass, sqlid);
                    if (tid == null) {
                        if (this.ignoreUnresolvedReferences) continue;
                        EhiLogger.logError((String)("unknown referenced object " + aclass.getScopedName(null) + " (sqltable " + sqlTargetTable + ", sqlid " + sqlid + ") referenced from " + fixref.getRoot().getobjecttag() + " TID " + fixref.getRoot().getobjectoid()));
                        referrs = true;
                        skipObj = true;
                        continue;
                    }
                    ref.setobjectrefoid(tid);
                }
                if (skipObj) continue;
                ObjectEvent objEvent = new ObjectEvent(fixref.getRoot());
                if (this.languageFilter != null) {
                    objEvent = (ObjectEvent)this.languageFilter.filter((IoxEvent)objEvent);
                }
                if (this.exportBaseModelFilter != null) {
                    objEvent = (ObjectEvent)this.exportBaseModelFilter.filter((IoxEvent)objEvent);
                }
                if (objEvent == null) continue;
                if (this.rounder != null) {
                    objEvent = (ObjectEvent)this.rounder.filter((IoxEvent)objEvent);
                }
                if (this.validator != null) {
                    this.validator.validate((IoxEvent)objEvent);
                }
                if (function == 8) continue;
                iomFile.write((IoxEvent)objEvent);
            }
            EndBasketEvent endBasket = new EndBasketEvent();
            if (this.languageFilter != null) {
                endBasket = (EndBasketEvent)this.languageFilter.filter((IoxEvent)endBasket);
            }
            if (this.exportBaseModelFilter != null) {
                endBasket = (EndBasketEvent)this.exportBaseModelFilter.filter((IoxEvent)endBasket);
            }
            if (this.rounder != null) {
                endBasket = (EndBasketEvent)this.rounder.filter((IoxEvent)endBasket);
            }
            if (this.validator != null) {
                this.validator.validate((IoxEvent)endBasket);
            }
            if (function != 8) {
                iomFile.write((IoxEvent)endBasket);
            }
            this.saveObjStat(iomBasket.getBid(), basketSqlId, datasource, iomBasket.getType());
        }
        return referrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readObjectTid(Viewable aclass, long sqlid) {
        String sqlIliTid = null;
        if (this.writeIliTid || Ili2cUtility.isViewableWithOid(aclass)) {
            String stmt = this.createQueryStmt4xtfid(aclass);
            EhiLogger.traceBackendCmd((String)stmt);
            PreparedStatement dbstmt = null;
            ResultSet rs = null;
            try {
                dbstmt = this.conn.prepareStatement(stmt);
                dbstmt.clearParameters();
                dbstmt.setLong(1, sqlid);
                if (this.fetchSize != null && this.fetchSize > 0) {
                    dbstmt.setFetchSize(this.fetchSize);
                }
                if ((rs = dbstmt.executeQuery()).next()) {
                    sqlIliTid = rs.getString(2);
                    if (rs.wasNull()) {
                        sqlIliTid = Long.toString(sqlid);
                    }
                    String sqlType = rs.getString(3);
                    this.sqlidPool.putSqlid2Xtfid(sqlType, sqlid, sqlIliTid);
                }
                String sqlType = null;
                return sqlType;
            }
            catch (SQLException ex) {
                EhiLogger.logError((String)("failed to query " + aclass.getScopedName(null)), (Throwable)ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((String)("failed to close query of " + aclass.getScopedName(null)), (Throwable)ex);
                    }
                    rs = null;
                }
                if (dbstmt != null) {
                    try {
                        dbstmt.close();
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((String)("failed to close query of " + aclass.getScopedName(null)), (Throwable)ex);
                    }
                    dbstmt = null;
                }
            }
        } else {
            sqlIliTid = Long.toString(sqlid);
            this.sqlidPool.putSqlid2Xtfid(this.recConv.getSqlType(aclass).getName(), sqlid, sqlIliTid);
        }
        return sqlIliTid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doitJava() {
        try {
            this.expgen = new IndentPrintWriter((Writer)new BufferedWriter(new FileWriter("c:/tmp/ili2db/export.java")));
            this.expgen.println("import ch.ehi.basics.logging.EhiLogger;");
            this.expgen.println("import ch.interlis.iom.IomObject;");
            this.expgen.println("public class TransferToXtf implements IdMapper {");
            this.expgen.indent();
            this.expgen.println("private java.sql.Connection conn=null;");
            this.expgen.println("private IomObject newObject(String className,String tid)");
            this.expgen.println("{");
            this.expgen.indent();
            this.expgen.println("// TODO create new object");
            this.expgen.println("return null;");
            this.expgen.unindent();
            this.expgen.println("}");
            this.expgen.println("private void writeObject(IomObject iomObj)");
            this.expgen.println("{");
            this.expgen.indent();
            this.expgen.println("// TODO write object");
            this.expgen.unindent();
            this.expgen.println("}");
            this.expgen.println("public String mapId(String idSpace,String id)");
            this.expgen.println("{");
            this.expgen.indent();
            this.expgen.println("// TODO mapId");
            this.expgen.println("return id;");
            this.expgen.unindent();
            this.expgen.println("}");
            this.expgen.println("public String newId()");
            this.expgen.println("{");
            this.expgen.indent();
            this.expgen.println("// TODO newId");
            this.expgen.println("throw new UnsupportedOperationException(\"this mapper doesn't generate new ids\");");
            this.expgen.unindent();
            this.expgen.println("}");
        }
        catch (IOException ex) {
            EhiLogger.logError((String)"failed to open file for java output", (Throwable)ex);
        }
        try {
            for (Object mObj : this.td) {
                if (!(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
                Model model = (Model)mObj;
                for (Object tObj : model) {
                    Domain domainDef;
                    if (tObj instanceof Topic && !this.suppressTopic((Topic)tObj)) {
                        Topic topic = (Topic)tObj;
                        for (Object obj : topic.getViewables()) {
                            Domain domainDef2;
                            if (obj instanceof Viewable && !this.suppressViewableIfJava((Viewable)obj)) {
                                Viewable aclass = (Viewable)obj;
                                EhiLogger.logState((String)(aclass.getScopedName(null) + "..."));
                                this.genClassHelper(aclass);
                                continue;
                            }
                            if (!(obj instanceof Domain) || !((domainDef2 = (Domain)obj).getType() instanceof EnumerationType)) continue;
                            String enumName = domainDef2.getScopedName(null);
                            this.enumTypes.add(enumName);
                        }
                        continue;
                    }
                    if (tObj instanceof Viewable && !this.suppressViewableIfJava((Viewable)tObj)) {
                        Viewable aclass = (Viewable)tObj;
                        EhiLogger.logState((String)(aclass.getScopedName(null) + "..."));
                        this.genClassHelper(aclass);
                        continue;
                    }
                    if (!(tObj instanceof Domain) || !((domainDef = (Domain)tObj).getType() instanceof EnumerationType)) continue;
                    String enumName = domainDef.getScopedName(null);
                    this.enumTypes.add(enumName);
                }
            }
        }
        finally {
            if (this.expgen != null) {
                this.expgen.println("private void addAny(String iliClassName,String select){");
                this.expgen.indent();
                Iterator linei = this.addanyLines.iterator();
                String sep = "";
                while (linei.hasNext()) {
                    String line = (String)linei.next();
                    this.expgen.println(sep + line);
                    sep = "else ";
                }
                if (sep.length() > 0) {
                    this.expgen.println("else{EhiLogger.logError(\"unknown class \"+iliClassName);}");
                } else {
                    this.expgen.println("EhiLogger.logError(\"unknown class \"+iliClassName);");
                }
                this.expgen.unindent();
                this.expgen.println("}");
                this.expgen.println("private EnumMapper getEnumMapper(String enumName){");
                this.expgen.indent();
                Iterator enumi = this.enumTypes.iterator();
                sep = "";
                while (enumi.hasNext()) {
                    String enumName = (String)enumi.next();
                    this.expgen.println(sep + "if(enumName.equals(\"" + enumName + "\")){return new IdentityEnumMapper();}");
                    sep = "else ";
                }
                if (sep.length() > 0) {
                    this.expgen.println("else{throw new IllegalArgumentException(\"unknown enum \"+enumName);}");
                } else {
                    this.expgen.println("throw new IllegalArgumentException(\"unknown enum \"+enumName);");
                }
                this.expgen.unindent();
                this.expgen.println("}");
                this.expgen.unindent();
                this.expgen.println("}");
                this.expgen.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpStructs(int function, AbstractStructWrapper structWrapper, FixIomObjectRefs fixref, Map<String, String> genericDomains, boolean isCrsAlternate) throws IoxException {
        Table baseClass = null;
        String stmt = null;
        if (structWrapper instanceof StructWrapper) {
            baseClass = ((CompositionType)((StructWrapper)structWrapper).getParentAttr().getDomain()).getComponentType();
            stmt = this.createQueryStmt4Type((Viewable)baseClass, (StructWrapper)structWrapper);
        } else if (structWrapper instanceof EmbeddedLinkWrapper) {
            baseClass = (Viewable)((EmbeddedLinkWrapper)structWrapper).getRole().getContainer();
            stmt = this.createQueryStmt4Type((Viewable)baseClass, (EmbeddedLinkWrapper)structWrapper);
        } else {
            throw new IllegalArgumentException("unexpected structWrapper " + structWrapper.getClass().getName());
        }
        HashMap<String, IomObject> structelev = new HashMap<String, IomObject>();
        HashSet<Viewable> structClassv = new HashSet<Viewable>();
        EhiLogger.traceBackendCmd((String)stmt);
        Statement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = this.conn.createStatement();
            if (this.fetchSize != null && this.fetchSize > 0) {
                dbstmt.setFetchSize(this.fetchSize);
            }
            rs = dbstmt.executeQuery(stmt);
            while (rs.next()) {
                String sqlid = rs.getString(1);
                String structEleClass = null;
                Viewable structClass = null;
                String structEleSqlType = rs.getString(2);
                structEleClass = this.ili2sqlName.mapSqlTableName(structEleSqlType);
                if (structEleClass == null) {
                    throw new IoxException("unknown T_Type '" + structEleSqlType + "' in table " + this.getStructRootTableName((Viewable)baseClass));
                }
                structClass = (Viewable)this.tag2class.get(structEleClass);
                IomObject iomObj = null;
                if (structWrapper instanceof StructWrapper) {
                    iomObj = structWrapper.getParent().addattrobj(((StructWrapper)structWrapper).getParentAttr().getName(), structEleClass);
                } else if (structWrapper instanceof EmbeddedLinkWrapper) {
                    iomObj = structWrapper.getParent().addattrobj(((EmbeddedLinkWrapper)structWrapper).getRole().getName(), structEleClass);
                }
                structelev.put(sqlid, iomObj);
                structClassv.add(structClass);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query structure elements " + baseClass.getScopedName(null)), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of structure elements " + baseClass.getScopedName(null)), (Throwable)ex);
                }
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                    dbstmt = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of structure elements " + baseClass.getScopedName(null)), (Throwable)ex);
                }
            }
        }
        Iterator classi = structClassv.iterator();
        while (classi.hasNext()) {
            Viewable aclass;
            Viewable iomTargetClass = aclass = (Viewable)classi.next();
            if (isCrsAlternate) {
                iomTargetClass = this.getCrsMappedToAlternateOrSame(aclass);
            }
            this.dumpObjHelper(function, null, aclass, iomTargetClass, null, genericDomains, fixref, structWrapper, structelev);
        }
    }

    private Viewable getCrsMappedToAlternateOrSame(Viewable aclass) {
        if (this.crsFilterToTarget == null) {
            return aclass;
        }
        Viewable aclass0 = (Viewable)this.crsFilterToTarget.get(aclass);
        if (aclass0 != null) {
            return aclass0;
        }
        return aclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpItfTableObject(int function, IoxWriter out, AttributeDef attr, Integer epsgCode, Long basketSqlId) {
        String stmt = this.createItfLineTableQueryStmt(attr, epsgCode, basketSqlId, this.geomConv);
        String sqlTabName = this.ili2sqlName.mapItfGeometryAsTable((Viewable)attr.getContainer(), attr, epsgCode);
        EhiLogger.traceBackendCmd((String)stmt);
        SurfaceOrAreaType type = (SurfaceOrAreaType)attr.getDomainResolvingAliases();
        String geomAttrName = ModelUtilities.getHelperTableGeomAttrName((AttributeDef)attr);
        String refAttrName = null;
        if (type instanceof SurfaceType) {
            refAttrName = ModelUtilities.getHelperTableMainTableRef((AttributeDef)attr);
        }
        PreparedStatement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = this.conn.prepareStatement(stmt);
            dbstmt.clearParameters();
            int paramIdx = 1;
            if (basketSqlId != null) {
                dbstmt.setLong(paramIdx++, basketSqlId);
            }
            if (this.fetchSize != null && this.fetchSize > 0) {
                dbstmt.setFetchSize(this.fetchSize);
            }
            rs = dbstmt.executeQuery();
            while (rs.next()) {
                Table lineAttrTable;
                int valuei = 1;
                long sqlid = rs.getLong(valuei);
                ++valuei;
                String sqlIliTid = null;
                if (this.hasIliTidCol) {
                    sqlIliTid = this.writeIliTid ? rs.getString(valuei) : Long.toString(sqlid);
                    ++valuei;
                }
                Viewable aclass = (Viewable)attr.getContainer();
                Iom_jObject iomObj = new Iom_jObject(aclass.getScopedName(null) + "_" + attr.getName(), sqlIliTid);
                Object geomobj = rs.getObject(valuei);
                ++valuei;
                if (!rs.wasNull()) {
                    try {
                        boolean is3D = false;
                        IomObject polyline = this.geomConv.toIomPolyline(geomobj, this.ili2sqlName.getSqlColNameItfLineTableGeomAttr(attr, sqlTabName), is3D);
                        iomObj.addattrobj(geomAttrName, polyline);
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert polyline"), (Throwable)ex);
                    }
                }
                if (type instanceof SurfaceType) {
                    IomObject ref = iomObj.addattrobj(refAttrName, "REF");
                    long refSqlId = rs.getLong(valuei);
                    String sqlTargetTable = this.recConv.getSqlType(aclass).getName();
                    if (this.sqlidPool.containsSqlid(sqlTargetTable, refSqlId)) {
                        String refTid = this.sqlidPool.getXtfid(sqlTargetTable, refSqlId);
                        ref.setobjectrefoid(refTid);
                    } else {
                        EhiLogger.logError((String)("unknown referenced object " + attr.getContainer().getScopedName(null) + " (sqltable " + sqlTargetTable + ", sqlid " + refSqlId + ") referenced from " + sqlTabName + " " + this.colT_ID + " " + sqlid));
                    }
                    ++valuei;
                }
                if ((lineAttrTable = type.getLineAttributeStructure()) != null) {
                    Iterator attri = lineAttrTable.getAttributes();
                    while (attri.hasNext()) {
                        AttributeDef lineattr = (AttributeDef)attri.next();
                        valuei = this.recConv.addAttrValue(rs, valuei, sqlid, iomObj, new ColumnWrapper(new StructAttrPath(new ViewableTransferElement((Object)lineattr))), lineattr, null, this.class2wrapper.get((Viewable)lineAttrTable), null, null, null);
                    }
                }
                if (out == null) continue;
                ObjectEvent objEvent = new ObjectEvent((IomObject)iomObj);
                if (this.languageFilter != null) {
                    objEvent = (ObjectEvent)this.languageFilter.filter((IoxEvent)objEvent);
                }
                if (this.exportBaseModelFilter != null) {
                    objEvent = (ObjectEvent)this.exportBaseModelFilter.filter((IoxEvent)objEvent);
                }
                if (this.rounder != null) {
                    objEvent = (ObjectEvent)this.rounder.filter((IoxEvent)objEvent);
                }
                if (this.validator != null) {
                    this.validator.validate((IoxEvent)objEvent);
                }
                if (function == 8) continue;
                out.write((IoxEvent)objEvent);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + attr.getScopedName(null)), (Throwable)ex);
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to write " + attr.getScopedName(null)), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of " + attr.getScopedName(null)), (Throwable)ex);
                }
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of " + attr.getScopedName(null)), (Throwable)ex);
                }
            }
        }
    }

    private void dumpObject(int function, IoxWriter out, Viewable aclass, Viewable iomTargetClass, Long basketSqlId, Map<String, String> genericDomains) {
        this.dumpObjHelper(function, out, aclass, iomTargetClass, basketSqlId, genericDomains, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpObjHelper(int function, IoxWriter out, Viewable aclass, Viewable iomTargetClass, Long basketSqlId, Map<String, String> genericDomains, FixIomObjectRefs fixref, AbstractStructWrapper structWrapper, HashMap<String, IomObject> structelev) {
        String stmt = this.recConv.createQueryStmt(aclass, basketSqlId, structWrapper);
        ViewableWrapper aclassWrapper = this.class2wrapper.get(aclass);
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = this.conn.prepareStatement(stmt);
            this.recConv.setStmtParams(dbstmt, basketSqlId, fixref, structWrapper);
            if (this.fetchSize != null && this.fetchSize > 0) {
                dbstmt.setFetchSize(this.fetchSize);
            }
            rs = dbstmt.executeQuery();
            while (rs.next()) {
                ArrayList<AbstractStructWrapper> structQueue = new ArrayList<AbstractStructWrapper>();
                long sqlid = this.recConv.getT_ID(rs);
                Iom_jObject iomObj = null;
                if (structWrapper == null) {
                    fixref = new FixIomObjectRefs();
                }
                iomObj = this.recConv.convertRecord(rs, aclassWrapper, aclass, fixref, structWrapper, structelev, structQueue, sqlid, genericDomains, iomTargetClass);
                this.updateObjStat(iomObj.getobjecttag(), sqlid);
                for (ViewableWrapper baseWrapper = aclassWrapper; baseWrapper != null; baseWrapper = baseWrapper.getExtending()) {
                    for (ViewableWrapper attrtableWrapper : baseWrapper.getPrimitiveCollectionWrappers()) {
                        AttributeDef attributeDef = attrtableWrapper.getPrimitiveCollectionAttr();
                        if (attributeDef == null || attributeDef.isTransient()) continue;
                        String query = this.createQueryStatementForPrimitiveCollectionAttribute(attrtableWrapper, attributeDef, sqlid);
                        EhiLogger.traceBackendCmd((String)query);
                        Statement statement = this.conn.createStatement();
                        ResultSet resultSet = statement.executeQuery(query);
                        while (resultSet.next()) {
                            this.recConv.addAttrValue(resultSet, 1, sqlid, iomObj, new ColumnWrapper(new StructAttrPath(new ViewableTransferElement((Object)attributeDef))), attributeDef, structQueue, attrtableWrapper, fixref, genericDomains, null);
                        }
                    }
                }
                Iterator roleIt = aclass.getAttributesAndRoles2();
                while (roleIt.hasNext()) {
                    RoleDef role;
                    AssociationDef roleOwner;
                    ViewableTransferElement roleEle = (ViewableTransferElement)roleIt.next();
                    if (!roleEle.embedded || !(roleEle.obj instanceof RoleDef) || (roleOwner = (AssociationDef)(role = (RoleDef)roleEle.obj).getContainer()).getDerivedFrom() != null || TransferFromIli.isLightweightAssociation(roleOwner)) continue;
                    structQueue.add(new EmbeddedLinkWrapper(sqlid, role, iomObj, aclassWrapper));
                }
                while (!structQueue.isEmpty()) {
                    AbstractStructWrapper wrapper = structQueue.remove(0);
                    this.dumpStructs(function, wrapper, fixref, genericDomains, aclass == iomTargetClass);
                }
                if (structWrapper != null) continue;
                if (!fixref.needsFixing() || out instanceof ItfWriter) {
                    ObjectEvent objEvent = new ObjectEvent((IomObject)iomObj);
                    if (this.languageFilter != null) {
                        objEvent = (ObjectEvent)this.languageFilter.filter((IoxEvent)objEvent);
                    }
                    if (this.exportBaseModelFilter != null) {
                        objEvent = (ObjectEvent)this.exportBaseModelFilter.filter((IoxEvent)objEvent);
                    }
                    if (objEvent == null) continue;
                    if (this.rounder != null) {
                        objEvent = (ObjectEvent)this.rounder.filter((IoxEvent)objEvent);
                    }
                    if (this.validator != null) {
                        this.validator.validate((IoxEvent)objEvent);
                    }
                    if (out == null || function == 8) continue;
                    out.write((IoxEvent)objEvent);
                    continue;
                }
                this.delayedObjects.add((Object)fixref);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + aclass.getScopedName(null)), (Throwable)ex);
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to write " + aclass.getScopedName(null)), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of " + aclass.getScopedName(null)), (Throwable)ex);
                }
            }
        }
    }

    private void genClassHelper(Viewable aclass) {
        boolean doStruct = false;
        if (aclass instanceof Table) {
            boolean bl = doStruct = !((Table)aclass).isIdentifiable();
        }
        if (doStruct) {
            this.expgen.println("private void add" + aclass.getName() + "(String parentTid,String parentAttrSql,IomObject parent,String parentAttrIli)");
        } else {
            this.expgen.println("private void add" + aclass.getName() + "(String subset)");
            String addany = "if(iliClassName.equals(\"" + aclass.getScopedName(null) + "\")){add" + aclass.getName() + "(select);}";
            this.addanyLines.add(addany);
        }
        this.expgen.println("{");
        this.expgen.indent();
        this.expgen.println("String tabName=\"" + this.createQueryStmtFromClause(aclass) + "\";");
        this.expgen.println("String stmt=\"" + this.recConv.createQueryStmt(aclass, null, null) + "\";");
        if (!doStruct) {
            this.expgen.println("if(subset!=null){");
            this.expgen.println("stmt=stmt+\" AND \"+subset;");
            this.expgen.println("}");
        }
        this.expgen.println("EhiLogger.traceBackendCmd(stmt);");
        this.expgen.println("java.sql.PreparedStatement dbstmt = null;");
        this.expgen.println("try{");
        this.expgen.indent();
        this.expgen.println("dbstmt = conn.prepareStatement(stmt);");
        this.expgen.println("dbstmt.clearParameters();");
        if (doStruct) {
            this.expgen.println("dbstmt.setString(1,parentTid);");
            this.expgen.println("dbstmt.setString(2,parentAttrSql);");
        }
        this.expgen.println("java.sql.ResultSet rs=dbstmt.executeQuery();");
        this.expgen.println("while(rs.next()){");
        this.expgen.indent();
        this.expgen.println("String tid=DbUtility.getString(rs,\"T_Id\",false,tabName);");
        this.expgen.println("String recInfo=tabName+\" \"+tid;");
        this.expgen.println("IomObject iomObj;");
        if (!doStruct) {
            this.expgen.println("iomObj=newObject(\"" + aclass.getScopedName(null) + "\",mapId(\"" + this.recConv.getSqlType(aclass) + "\",tid));");
        } else {
            this.expgen.println("iomObj=(IomObject)parent.addattrobj(parentAttrIli,\"" + aclass.getScopedName(null) + "\");");
        }
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (obj.obj instanceof AttributeDef && (attr = (AttributeDef)obj.obj).getExtending() == null) {
                String attrName = attr.getName();
                String sqlAttrName = this.ili2sqlName.mapIliAttributeDef(attr, null, this.recConv.getSqlType(aclass).getName(), null);
                Type type = attr.getDomain();
                if (type instanceof TypeAlias && Ili2cUtility.isBoolean(this.td, type)) {
                    this.expgen.println("Boolean prop_" + attrName + "=Db2Xtf.getBoolean(rs,\"" + sqlAttrName + "\"," + (type.isMandatoryConsideringAliases() ? "false" : "true") + ",recInfo,iomObj,\"" + attrName + "\");");
                } else {
                    type = attr.getDomainResolvingAliases();
                    if (type instanceof CompositionType) {
                        CompositionType ct = (CompositionType)type;
                        this.expgen.println("add" + ct.getComponentType().getName() + "(tid,\"" + this.ili2sqlName.mapIliAttributeDef(attr, null, this.recConv.getSqlType(aclass).getName(), null) + "\",iomObj,\"" + attr.getName() + "\");");
                    } else if (!(type instanceof PolylineType || type instanceof SurfaceOrAreaType || type instanceof CoordType)) {
                        if (type instanceof EnumerationType) {
                            String enumName = null;
                            if (attr.getDomain() instanceof TypeAlias) {
                                Domain domainDef = ((TypeAlias)attr.getDomain()).getAliasing();
                                enumName = domainDef.getScopedName(null);
                            } else {
                                enumName = aclass.getScopedName(null) + "->" + attrName;
                                this.enumTypes.add(enumName);
                            }
                            this.expgen.println("String prop_" + attrName + "=Db2Xtf.getEnum(rs,\"" + sqlAttrName + "\"," + (type.isMandatoryConsideringAliases() ? "false" : "true") + ",recInfo,getEnumMapper(\"" + enumName + "\"),iomObj,\"" + attrName + "\");");
                        } else {
                            this.expgen.println("String prop_" + attrName + "=Db2Xtf.getString(rs,\"" + sqlAttrName + "\"," + (type.isMandatoryConsideringAliases() ? "false" : "true") + ",recInfo,iomObj,\"" + attrName + "\");");
                        }
                    }
                }
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            String roleName = role.getName();
            String sqlRoleName = this.ili2sqlName.mapIliRoleDef(role, this.recConv.getSqlType(aclass).getName(), this.recConv.getSqlType((Viewable)role.getDestination()).getName());
            if (obj.embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null) continue;
                this.expgen.println("String prop_" + roleName + "=Db2Xtf.getRef(rs,\"" + sqlRoleName + "\",true,recInfo,this,\"" + this.recConv.getSqlType((Viewable)role.getDestination()) + "\",iomObj,\"" + roleName + "\",\"" + roleOwner.getScopedName(null) + "\");");
                continue;
            }
            this.expgen.println("String prop_" + roleName + "=Db2Xtf.getRef(rs,\"" + sqlRoleName + "\",false,recInfo,this,\"" + this.recConv.getSqlType((Viewable)role.getDestination()) + "\",iomObj,\"" + roleName + "\",\"REF\");");
        }
        if (!doStruct && aclass instanceof AbstractClassDef) {
            AbstractClassDef aclass2 = (AbstractClassDef)aclass;
            Iterator associ = aclass2.getTargetForRoles();
            while (associ.hasNext()) {
                RoleDef roleThis = (RoleDef)associ.next();
                if (roleThis.getKind() != 2 && roleThis.getKind() != 3) continue;
                RoleDef oppEnd = roleThis.getOppEnd();
                if (roleThis.isAssociationEmbedded()) {
                    this.expgen.println("addPendingObject(\"" + oppEnd.getDestination().getScopedName(null) + "\",\"T_Id\",prop_" + oppEnd.getName() + ");");
                    continue;
                }
                if (oppEnd.isAssociationEmbedded()) {
                    this.expgen.println("addPendingObject(\"" + oppEnd.getDestination().getScopedName(null) + "\",\"" + this.ili2sqlName.mapIliRoleDef(roleThis, null, null) + "\",tid);");
                    continue;
                }
                this.expgen.println("addPendingObject(\"" + ((AssociationDef)oppEnd.getContainer()).getScopedName(null) + "\",\"" + this.ili2sqlName.mapIliRoleDef(roleThis, null, null) + "\",prop_" + roleThis.getName() + ");");
            }
        }
        if (!doStruct) {
            this.expgen.println("writeObject(iomObj);");
        }
        this.expgen.unindent();
        this.expgen.println("}");
        this.expgen.unindent();
        this.expgen.println("}catch(java.sql.SQLException ex){");
        this.expgen.indent();
        this.expgen.println("EhiLogger.logError(\"failed to query \"+tabName,ex);");
        this.expgen.unindent();
        this.expgen.println("}finally{");
        this.expgen.indent();
        this.expgen.println("if(dbstmt!=null){");
        this.expgen.indent();
        this.expgen.println("try{");
        this.expgen.indent();
        this.expgen.println("dbstmt.close();");
        this.expgen.unindent();
        this.expgen.println("}catch(java.sql.SQLException ex){");
        this.expgen.indent();
        this.expgen.println("EhiLogger.logError(\"failed to close query of \"+tabName,ex);");
        this.expgen.unindent();
        this.expgen.println("}");
        this.expgen.unindent();
        this.expgen.println("}");
        this.expgen.unindent();
        this.expgen.println("}");
        this.expgen.unindent();
        this.expgen.println("}");
    }

    protected boolean suppressModel(Model model) {
        if (model == null) {
            return true;
        }
        if (model == this.td.INTERLIS) {
            return true;
        }
        return model instanceof TypeModel || model instanceof PredefinedModel;
    }

    protected boolean suppressTopic(Topic topic) {
        if (topic == null) {
            return true;
        }
        return topic.isAbstract();
    }

    public static boolean suppressViewable(Viewable v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        if (v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic()) {
            return true;
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    protected boolean suppressViewableIfJava(Viewable v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        return v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic();
    }

    private DbTableName getSqlTableNameItfLineTable(AttributeDef def, Integer epsgCode) {
        String sqlname = this.ili2sqlName.mapItfGeometryAsTable((Viewable)def.getContainer(), def, epsgCode);
        return new DbTableName(this.schema, sqlname);
    }

    private String createItfLineTableQueryStmt(AttributeDef attr, Integer epsgCode, Long basketSqlId, SqlColumnConverter conv) {
        Table lineAttrTable;
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT r0." + this.colT_ID);
        if (this.hasIliTidCol) {
            ret.append(", r0.T_Ili_Tid");
        }
        String sep = ",";
        SurfaceOrAreaType type = (SurfaceOrAreaType)attr.getDomainResolvingAliases();
        String sqlTabName = this.ili2sqlName.mapItfGeometryAsTable((Viewable)attr.getContainer(), attr, epsgCode);
        ret.append(sep);
        sep = ",";
        ret.append(conv.getSelectValueWrapperPolyline(this.ili2sqlName.getSqlColNameItfLineTableGeomAttr(attr, sqlTabName)));
        if (type instanceof SurfaceType) {
            ret.append(sep);
            sep = ",";
            ret.append(this.ili2sqlName.getSqlColNameItfLineTableRefAttr(attr, sqlTabName));
        }
        if ((lineAttrTable = type.getLineAttributeStructure()) != null) {
            Iterator attri = lineAttrTable.getAttributes();
            while (attri.hasNext()) {
                AttributeDef lineattr = (AttributeDef)attri.next();
                sep = this.recConv.addAttrToQueryStmt(ret, sep, null, new ColumnWrapper(new StructAttrPath(new ViewableTransferElement((Object)lineattr))), sqlTabName);
            }
        }
        ret.append(" FROM ");
        if (this.schema != null) {
            sqlTabName = this.schema + "." + sqlTabName;
        }
        ret.append(sqlTabName);
        ret.append(" r0");
        if (basketSqlId != null) {
            ret.append(" WHERE r0.T_basket=?");
        }
        return ret.toString();
    }

    private String createQueryStmt4xtfid(Viewable aclass) {
        ArrayList<ViewableWrapper> wrappers = this.recConv.getTargetTables(aclass);
        StringBuffer ret = new StringBuffer();
        int i = 1;
        ret.append("SELECT " + this.colT_ID + "," + "T_Ili_Tid" + "," + "T_Type" + " FROM (");
        String sep = "";
        HashSet<ViewableWrapper> visitedWrappers = new HashSet<ViewableWrapper>();
        for (ViewableWrapper wrapper : wrappers) {
            if (visitedWrappers.contains(wrapper = wrapper.getRoot())) continue;
            visitedWrappers.add(wrapper);
            ret.append(sep);
            ret.append("SELECT r" + i + "." + this.colT_ID);
            if (this.hasIliTidCol || wrapper.hasOid()) {
                ret.append(", r" + i + "." + "T_Ili_Tid");
            } else {
                ret.append(", NULL T_Ili_Tid");
            }
            if (this.recConv.createTypeDiscriminator() || wrapper.includesMultipleTypes()) {
                ret.append(", r" + i + "." + "T_Type");
            } else {
                ret.append(", '" + wrapper.getSqlTable().getName() + "' " + "T_Type");
            }
            ret.append(" FROM ");
            ret.append(wrapper.getSqlTable().getQName());
            ret.append(" r" + i + "");
            ++i;
            sep = " UNION ";
        }
        ret.append(") r0");
        ret.append(" WHERE r0." + this.colT_ID + "=?");
        return ret.toString();
    }

    private String createQueryStmtFromClause(Viewable aclass) {
        StringBuffer ret = new StringBuffer();
        ArrayList<Viewable> tablev = new ArrayList<Viewable>(10);
        tablev.add(aclass);
        for (Viewable base = (Viewable)aclass.getExtending(); base != null; base = (Viewable)base.getExtending()) {
            tablev.add(base);
        }
        String sep = "";
        int tablec = tablev.size();
        for (int i = 0; i < tablec; ++i) {
            ret.append(sep);
            ret.append(this.recConv.getSqlType((Viewable)tablev.get(i)));
            sep = ", ";
        }
        return ret.toString();
    }

    private String getStructRootTableName(Viewable aclass) {
        ViewableWrapper root = this.class2wrapper.get(aclass);
        while (root.getExtending() != null) {
            root = root.getExtending();
        }
        return root.getSqlTablename();
    }

    private String createQueryStmt4Type(Viewable aclass, StructWrapper wrapper) {
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT r0." + this.colT_ID);
        ret.append(", r0.T_Type");
        ret.append(", r0.T_Seq");
        ret.append(" FROM (");
        int tabidx = 0;
        String subSelectSep = "";
        for (ViewableWrapper root : this.recConv.getStructWrappers((Viewable)((Table)aclass))) {
            if (!root.isStructure()) continue;
            String tabalias = "r" + ++tabidx;
            ret.append(subSelectSep);
            ret.append("SELECT ");
            ret.append(tabalias + "." + this.colT_ID);
            if (this.createTypeDiscriminator || root.includesMultipleTypes()) {
                ret.append(", " + tabalias + "." + "T_Type");
            } else {
                ret.append(",'" + root.getSqlTablename() + "' AS " + "T_Type");
            }
            ret.append("," + tabalias + "." + "T_Seq");
            ret.append(" FROM ");
            ret.append(this.recConv.getSqlType(root.getViewable()));
            ret.append(" " + tabalias);
            if (wrapper != null) {
                ret.append(" WHERE " + tabalias + "." + this.ili2sqlName.mapIliAttributeDefReverse(wrapper.getParentAttr(), this.recConv.getSqlType(root.getViewable()).getName(), this.recConv.getSqlType(wrapper.getParentTable().getViewable()).getName()) + "=" + wrapper.getParentSqlId());
            }
            subSelectSep = " UNION ";
        }
        ret.append(" ) r0 ORDER BY T_Seq ASC");
        return ret.toString();
    }

    private String createQueryStmt4Type(Viewable aclass, EmbeddedLinkWrapper wrapper) {
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT r0." + this.colT_ID);
        ret.append(", r0.T_Type");
        ret.append(", 0 AS T_Seq");
        ret.append(" FROM (");
        int tabidx = 0;
        String subSelectSep = "";
        for (ViewableWrapper root : this.recConv.getStructWrappers(aclass)) {
            String tabalias = "r" + ++tabidx;
            ret.append(subSelectSep);
            ret.append("SELECT ");
            ret.append(tabalias + "." + this.colT_ID);
            if (this.createTypeDiscriminator || root.includesMultipleTypes()) {
                ret.append(", " + tabalias + "." + "T_Type");
            } else {
                ret.append(",'" + root.getSqlTablename() + "' AS " + "T_Type");
            }
            ret.append(" FROM ");
            ret.append(this.recConv.getSqlType(root.getViewable()));
            ret.append(" " + tabalias);
            RoleDef role = wrapper.getRole().getOppEnd();
            ArrayList<ViewableWrapper> targetTables = this.recConv.getTargetTables(role);
            String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, root.getSqlTablename(), wrapper.getParentTable().getSqlTablename(), targetTables.size() > 1);
            ret.append(" WHERE " + tabalias + "." + roleSqlName + "=" + wrapper.getParentSqlId());
            subSelectSep = " UNION ";
        }
        ret.append(" ) r0");
        return ret.toString();
    }

    private String createQueryStatementForPrimitiveCollectionAttribute(ViewableWrapper attrtableWrapper, AttributeDef attributeDef, long parentSqlid) {
        ViewableWrapper parent = attrtableWrapper.getMainTable();
        String refAttrSqlName = this.ili2sqlName.mapIliAttributeDefReverse(attributeDef, attrtableWrapper.getSqlTablename(), parent.getSqlTablename());
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        this.recConv.addAttrToQueryStmt(sb, "", attrtableWrapper.getSqlTableQName(), new ColumnWrapper(new StructAttrPath(new ViewableTransferElement((Object)attributeDef))), attrtableWrapper.getSqlTablename());
        sb.append(" FROM ");
        sb.append(attrtableWrapper.getSqlTableQName());
        sb.append(" WHERE ");
        sb.append(refAttrSqlName);
        sb.append(" = ");
        sb.append(parentSqlid);
        if (attributeDef.getDomainOrDerivedDomain().isOrdered()) {
            sb.append(" ORDER BY ");
            sb.append("T_Seq");
        }
        return sb.toString();
    }

    private void updateObjStat(String tag, long sqlId) {
        if (this.objStat.containsKey(tag)) {
            ClassStat stat = this.objStat.get(tag);
            stat.addEndid(sqlId);
        } else {
            ClassStat stat = new ClassStat(tag, sqlId);
            this.objStat.put(tag, stat);
        }
    }

    private void saveObjStat(String iliBasketId, Long basketSqlId, String datasource, String topic) {
        this.basketStat.put(iliBasketId, new BasketStat(datasource, topic, iliBasketId, this.objStat));
        this.objStat = new HashMap();
    }

    private static void AddFunctionsFromPluginFolder(Config config, String pluginFolder) {
        PluginLoader loader = new PluginLoader();
        loader.loadPlugins();
        if (pluginFolder != null) {
            EhiLogger.logState((String)("pluginFolder <" + pluginFolder + ">"));
            loader.loadPlugins(new File(pluginFolder));
        }
        HashMap userFunctions = new HashMap(PluginLoader.getInterlisFunctions((List)loader.getAllPlugins()));
        Map definedFunctions = (Map)config.getTransientObject("ch.interlis.iox_j.validator.customFunctions");
        if (definedFunctions != null) {
            userFunctions.putAll(definedFunctions);
        }
        config.setTransientObject("ch.interlis.iox_j.validator.customFunctions", userFunctions);
    }
}

