/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator.nls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NlsModelElement {
    private String scopedName;
    private String elementType;
    private Map<String, String> name = new HashMap<String, String>();
    private Map<String, String> documentation = new HashMap<String, String>();
    private Map<String, String> metaAttr = new HashMap<String, String>();

    public List<String> getLanguages() {
        HashSet<String> langs = new HashSet<String>();
        langs.addAll(this.name.keySet());
        langs.addAll(this.documentation.keySet());
        ArrayList<String> ret = new ArrayList<String>(langs);
        Collections.sort(ret, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        return ret;
    }

    public String getScopedName() {
        return this.scopedName;
    }

    public void setScopedName(String scopedName) {
        if (scopedName == null) {
            throw new IllegalArgumentException();
        }
        this.scopedName = scopedName;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        this.elementType = elementType;
    }

    public String getName(String lang) {
        return this.name.get(lang);
    }

    public void setName(String lang, String name) {
        this.name.put(lang, name);
    }

    public String getDocumentation(String lang) {
        return this.documentation.get(lang);
    }

    public void setDocumentation(String lang, String documentation) {
        this.documentation.put(lang, documentation);
    }

    public List<String> getMetaAttrs() {
        HashSet<String> metaAttrs = new HashSet<String>();
        metaAttrs.addAll(this.metaAttr.keySet());
        ArrayList<String> ret = new ArrayList<String>(metaAttrs);
        Collections.sort(ret);
        return ret;
    }

    public String getMetaAttr(String attrName) {
        return this.metaAttr.get(attrName);
    }

    public void setMetaAttr(String attrName, String attrValue) {
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        this.metaAttr.put(attrName, attrValue);
    }
}

