/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfAreaLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.ItfSurfaceLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.LineobjectIterator;
import ch.interlis.iom_j.itf.impl.Linetable2Polygon;
import ch.interlis.iox.IoxDataPool;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ItfReader2
implements IoxReader,
IoxIliReader {
    public static final String SAVED_GEOREF_PREFIX = "_itf_";
    public static final int POLYGON_BUILDING_ERRORS_ON = 0;
    public static final int POLYGON_BUILDING_ERRORS_OFF = 1;
    public static final int POLYGON_BUILDING_ERRORS_WARNING = 1;
    private ItfReader rawReader = null;
    private Map<String, IomObject> currentMainObjs = null;
    private LineobjectIterator currentAreaAttrsIt = null;
    private LineobjectIterator currentSurfaceAttrsIt = null;
    private HashMap<AttributeDef, ItfSurfaceLinetable2Polygon> currentSurfaceAttrs = null;
    private HashMap<AttributeDef, ItfAreaLinetable2Polygon> currentAreaAttrs = null;
    private ObjectPoolManager objPool = null;
    private ArrayList<IoxInvalidDataException> dataerrs = new ArrayList();
    private int ignorePolygonBuildingErrors = 0;
    private boolean readLinetables = false;
    private boolean allowItfAreaHoles = true;
    private PipelinePool ioxDataPool = null;
    private LogEventFactory errFact = null;
    private Set<String> unexpectedLinetables = new HashSet<String>();
    private IoxEvent _next_Event = null;
    private AbstractClassDef attrs_currentClass = null;
    private HashMap<AttributeDef, ItfAreaLinetable2Polygon> attrs_areaAttrs = null;
    private HashMap<AttributeDef, ItfSurfaceLinetable2Polygon> attrs_surfaceAttrs = null;

    public ItfReader2(InputStream in, boolean ignorePolygonBuildingErrors1) throws IoxException {
        this.initErrFact(null);
        this.rawReader = new ItfReader(in, this.errFact);
        this.init(ignorePolygonBuildingErrors1);
    }

    public ItfReader2(InputStream in, LogEventFactory errFact1, boolean ignorePolygonBuildingErrors1) throws IoxException {
        this.initErrFact(errFact1);
        this.rawReader = new ItfReader(in, this.errFact);
        this.init(ignorePolygonBuildingErrors1);
    }

    public ItfReader2(File in, boolean ignorePolygonBuildingErrors1) throws IoxException {
        this.initErrFact(null);
        this.rawReader = new ItfReader(in, this.errFact);
        this.init(ignorePolygonBuildingErrors1);
    }

    public ItfReader2(File in, LogEventFactory errFact1, boolean ignorePolygonBuildingErrors1) throws IoxException {
        this.initErrFact(errFact1);
        this.rawReader = new ItfReader(in, this.errFact);
        this.init(ignorePolygonBuildingErrors1);
    }

    private void init(boolean ignorePolygonBuildingErrors1) {
        this.objPool = new ObjectPoolManager();
        this.ignorePolygonBuildingErrors = ignorePolygonBuildingErrors1 ? 1 : 0;
    }

    private void initErrFact(LogEventFactory errFact) {
        if (errFact == null) {
            this.errFact = new LogEventFactory();
            this.errFact.setLogger(new Log2EhiLogger());
        } else {
            this.errFact = errFact;
            if (errFact.getLogger() == null) {
                this.errFact.setLogger(new Log2EhiLogger());
            }
        }
    }

    public void close() throws IoxException {
        if (this.rawReader != null) {
            this.rawReader.close();
        }
        this.rawReader = null;
        this.closePolygonizers();
        if (this.objPool != null) {
            this.objPool.close();
            this.objPool = null;
        }
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.rawReader.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.rawReader.getFactory();
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.rawReader.setFactory(factory);
    }

    public IoxEvent read() throws IoxException {
        IoxEvent rawEvent;
        block11: {
            if (this.currentMainObjs != null) {
                if (this.readLinetables && this.currentAreaAttrsIt.hasNext()) {
                    IomObject lineObj = this.currentAreaAttrsIt.next();
                    return new ObjectEvent(lineObj);
                }
                if (this.currentMainObjs.size() > 0) {
                    Linetable2Polygon polygonizer;
                    String nextTid = this.currentMainObjs.keySet().iterator().next();
                    IomObject nextObj = this.currentMainObjs.get(nextTid);
                    this.currentMainObjs.remove(nextTid);
                    for (AttributeDef areaAttr : this.currentAreaAttrs.keySet()) {
                        String areaAttrName = areaAttr.getName();
                        polygonizer = this.currentAreaAttrs.get(areaAttr);
                        this.mergeAreaGeomToMainObj(areaAttrName, (ItfAreaLinetable2Polygon)polygonizer, nextTid, nextObj);
                    }
                    for (AttributeDef surfaceAttr : this.currentSurfaceAttrs.keySet()) {
                        String surfaceAttrName = surfaceAttr.getName();
                        polygonizer = this.currentSurfaceAttrs.get(surfaceAttr);
                        this.mergeSurfaceGeomToMainObj(surfaceAttrName, (ItfSurfaceLinetable2Polygon)polygonizer, nextTid, nextObj);
                    }
                    return new ObjectEvent(nextObj);
                }
                if (this.readLinetables && this.currentSurfaceAttrsIt.hasNext()) {
                    IomObject lineObj = this.currentSurfaceAttrsIt.next();
                    return new ObjectEvent(lineObj);
                }
                this.closePolygonizers();
                this.currentMainObjs = null;
                this.currentSurfaceAttrs = null;
                this.currentSurfaceAttrsIt = null;
                this.currentAreaAttrs = null;
                this.currentAreaAttrsIt = null;
            }
            rawEvent = null;
            while ((rawEvent = this.nextEvent()) instanceof ObjectEvent) {
                if ((rawEvent = this.handleObject(rawEvent)) == null) continue;
                return rawEvent;
            }
            if (!(rawEvent instanceof EndTransferEvent) || this.ignorePolygonBuildingErrors == 1 || this.dataerrs.size() <= 0) break block11;
            for (IoxInvalidDataException dataerr : this.dataerrs) {
                if (this.ignorePolygonBuildingErrors == 1) {
                    this.errFact.addEvent(this.errFact.logWarning(dataerr));
                    continue;
                }
                this.errFact.addEvent(this.errFact.logError(dataerr));
            }
            if (this.ignorePolygonBuildingErrors == 0) {
                throw new IoxInvalidDataException("failed to build polygons");
            }
            if (this.ignorePolygonBuildingErrors == 1) {
                this.errFact.addEvent(this.errFact.logWarning(new IoxInvalidDataException("failed to build polygons")));
            }
        }
        return rawEvent;
    }

    protected IoxEvent handleObject(IoxEvent rawEvent) throws IoxException {
        block35: {
            Linetable2Polygon polygonizer;
            ArrayList<IoxInvalidDataException> dataerrs2;
            ArrayList<IoxInvalidDataException> dataerrs22;
            Linetable2Polygon polygonizer2;
            Object polygonizer3;
            AttributeDef surfaceOrAreaAttr;
            AbstractClassDef aclass;
            Object aclassObj;
            String iliQName;
            IomObject rawObj;
            block33: {
                rawObj = ((ObjectEvent)rawEvent).getIomObject();
                iliQName = rawObj.getobjecttag();
                aclassObj = this.rawReader.mapIliQName2Class(iliQName);
                aclass = null;
                surfaceOrAreaAttr = null;
                if (aclassObj instanceof AbstractClassDef) {
                    aclass = (AbstractClassDef)aclassObj;
                } else {
                    surfaceOrAreaAttr = (AttributeDef)aclassObj;
                    aclass = (AbstractClassDef)surfaceOrAreaAttr.getContainer();
                }
                this.currentSurfaceAttrs = this.getSurfaceAttrs(aclass);
                this.currentAreaAttrs = this.getAreaAttrs(aclass);
                if (this.currentSurfaceAttrs.size() == 0 && this.currentAreaAttrs.size() == 0) break block35;
                if (surfaceOrAreaAttr == null) {
                    this.pushBackEvent(rawEvent);
                }
                while (surfaceOrAreaAttr != null) {
                    block36: {
                        block32: {
                            polygonizer3 = this.currentAreaAttrs.get(surfaceOrAreaAttr);
                            if (polygonizer3 == null) {
                                ItfSurfaceLinetable2Polygon surfacePolygonizer;
                                if (!this.unexpectedLinetables.contains(iliQName)) {
                                    this.dataerrs.add(new IoxInvalidDataException("unexpected linetable " + iliQName));
                                    this.unexpectedLinetables.add(iliQName);
                                }
                                if ((surfacePolygonizer = this.currentSurfaceAttrs.get(surfaceOrAreaAttr)) != null) {
                                    surfacePolygonizer.addItfLinetableObject(rawObj);
                                }
                                return null;
                            }
                            do {
                                ((ItfAreaLinetable2Polygon)polygonizer3).addItfLinetableObject(rawObj);
                                rawEvent = this.nextEvent();
                                if (!(rawEvent instanceof ObjectEvent)) break block32;
                            } while (iliQName.equals((rawObj = ((ObjectEvent)rawEvent).getIomObject()).getobjecttag()));
                            iliQName = rawObj.getobjecttag();
                            break block36;
                        }
                        rawObj = null;
                        iliQName = null;
                        this.pushBackEvent(rawEvent);
                    }
                    surfaceOrAreaAttr = null;
                    if (iliQName == null) continue;
                    aclassObj = this.rawReader.mapIliQName2Class(iliQName);
                    if (aclassObj instanceof AbstractClassDef) {
                        if (aclassObj != aclass) {
                            throw new IoxException("unexpected table " + iliQName);
                        }
                        this.pushBackEvent(rawEvent);
                        continue;
                    }
                    surfaceOrAreaAttr = (AttributeDef)aclassObj;
                    if (surfaceOrAreaAttr.getContainer() == aclass) continue;
                    throw new IoxException("unexpected linetable " + iliQName);
                }
                surfaceOrAreaAttr = null;
                this.currentMainObjs = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectSerializer(this.getFactory()));
                iliQName = aclass.getScopedName(null);
                while ((rawEvent = this.nextEvent()) instanceof ObjectEvent) {
                    rawObj = ((ObjectEvent)rawEvent).getIomObject();
                    if (!iliQName.equals(rawObj.getobjecttag())) {
                        aclassObj = this.rawReader.mapIliQName2Class(rawObj.getobjecttag());
                        if (aclassObj instanceof AbstractClassDef) {
                            this.pushBackEvent(rawEvent);
                        } else {
                            surfaceOrAreaAttr = (AttributeDef)aclassObj;
                            if (surfaceOrAreaAttr.getContainer() != aclass) {
                                surfaceOrAreaAttr = null;
                                this.pushBackEvent(rawEvent);
                            } else {
                                iliQName = rawObj.getobjecttag();
                            }
                        }
                        break block33;
                    }
                    String oid = rawObj.getobjectoid();
                    this.currentMainObjs.put(oid, rawObj);
                    for (AttributeDef areaAttr : this.currentAreaAttrs.keySet()) {
                        polygonizer2 = this.currentAreaAttrs.get(areaAttr);
                        IomObject georef = rawObj.getattrobj(areaAttr.getName(), 0);
                        if (georef == null) continue;
                        ((ItfAreaLinetable2Polygon)polygonizer2).addGeoRef(oid, georef);
                    }
                    for (AttributeDef surfaceAttr : this.currentSurfaceAttrs.keySet()) {
                        polygonizer2 = this.currentSurfaceAttrs.get(surfaceAttr);
                        ((ItfSurfaceLinetable2Polygon)polygonizer2).addMainObjectTid(oid);
                    }
                }
                this.pushBackEvent(rawEvent);
            }
            while (surfaceOrAreaAttr != null) {
                block37: {
                    block34: {
                        polygonizer3 = this.currentSurfaceAttrs.get(surfaceOrAreaAttr);
                        do {
                            ((ItfSurfaceLinetable2Polygon)polygonizer3).addItfLinetableObject(rawObj);
                            rawEvent = this.nextEvent();
                            if (!(rawEvent instanceof ObjectEvent)) break block34;
                        } while (iliQName.equals((rawObj = ((ObjectEvent)rawEvent).getIomObject()).getobjecttag()));
                        iliQName = rawObj.getobjecttag();
                        break block37;
                    }
                    rawObj = null;
                    iliQName = null;
                    this.pushBackEvent(rawEvent);
                }
                surfaceOrAreaAttr = null;
                if (iliQName == null) continue;
                aclassObj = this.rawReader.mapIliQName2Class(iliQName);
                if (aclassObj instanceof AbstractClassDef) {
                    surfaceOrAreaAttr = null;
                    this.pushBackEvent(rawEvent);
                    break;
                }
                surfaceOrAreaAttr = (AttributeDef)aclassObj;
                if (surfaceOrAreaAttr.getContainer() == aclass) continue;
                surfaceOrAreaAttr = null;
                this.pushBackEvent(rawEvent);
                break;
            }
            for (AttributeDef areaAttr : this.currentAreaAttrs.keySet()) {
                String areaAttrName = areaAttr.getName();
                this.setTopologyValidationDone(areaAttr);
                polygonizer2 = this.currentAreaAttrs.get(areaAttr);
                try {
                    ((ItfAreaLinetable2Polygon)polygonizer2).buildSurfaces();
                    dataerrs22 = ((ItfAreaLinetable2Polygon)polygonizer2).getDataerrs();
                    this.dataerrs.addAll(dataerrs22);
                    if (dataerrs22.size() <= 0) continue;
                    this.dataerrs.add(new IoxInvalidDataException("failed to build polygons of " + aclass.getScopedName(null) + "." + areaAttrName));
                    this.setTopologyValidationFailed(areaAttr);
                }
                catch (Exception e) {
                    dataerrs2 = ((ItfAreaLinetable2Polygon)polygonizer2).getDataerrs();
                    this.dataerrs.addAll(dataerrs2);
                    this.dataerrs.add(new IoxInvalidDataException("failed to build polygons of " + aclass.getScopedName(null) + "." + areaAttrName, (Throwable)e));
                    this.setTopologyValidationFailed(areaAttr);
                }
            }
            for (AttributeDef surfaceAttr : this.currentSurfaceAttrs.keySet()) {
                String surfaceAttrName = surfaceAttr.getName();
                this.setTopologyValidationDone(surfaceAttr);
                polygonizer2 = this.currentSurfaceAttrs.get(surfaceAttr);
                try {
                    ((ItfSurfaceLinetable2Polygon)polygonizer2).buildSurfaces();
                    dataerrs22 = ((ItfSurfaceLinetable2Polygon)polygonizer2).getDataerrs();
                    this.dataerrs.addAll(dataerrs22);
                    if (dataerrs22.size() <= 0) continue;
                    this.setTopologyValidationFailed(surfaceAttr);
                    this.dataerrs.add(new IoxInvalidDataException("failed to build polygons of " + aclass.getScopedName(null) + "." + surfaceAttrName));
                }
                catch (Exception e) {
                    dataerrs2 = ((ItfSurfaceLinetable2Polygon)polygonizer2).getDataerrs();
                    this.dataerrs.addAll(dataerrs2);
                    this.dataerrs.add(new IoxInvalidDataException("failed to build polygons of " + aclass.getScopedName(null) + "." + surfaceAttrName, (Throwable)e));
                    this.setTopologyValidationFailed(surfaceAttr);
                }
            }
            if (this.currentMainObjs.keySet().size() == 0) {
                this.dataerrs.add(new IoxInvalidDataException("no main objects of " + aclass.getScopedName() + " but linetable objects"));
                return null;
            }
            if (this.readLinetables) {
                this.currentAreaAttrsIt = new LineobjectIterator(this.currentAreaAttrs);
                this.currentSurfaceAttrsIt = new LineobjectIterator(this.currentSurfaceAttrs);
                if (this.currentAreaAttrsIt.hasNext()) {
                    IomObject lineObj = this.currentAreaAttrsIt.next();
                    return new ObjectEvent(lineObj);
                }
            }
            String nextTid = this.currentMainObjs.keySet().iterator().next();
            IomObject nextObj = this.currentMainObjs.get(nextTid);
            this.currentMainObjs.remove(nextTid);
            for (AttributeDef areaAttr : this.currentAreaAttrs.keySet()) {
                String areaAttrName = areaAttr.getName();
                polygonizer = this.currentAreaAttrs.get(areaAttr);
                this.mergeAreaGeomToMainObj(areaAttrName, (ItfAreaLinetable2Polygon)polygonizer, nextTid, nextObj);
            }
            for (AttributeDef surfaceAttr : this.currentSurfaceAttrs.keySet()) {
                String surfaceAttrName = surfaceAttr.getName();
                polygonizer = this.currentSurfaceAttrs.get(surfaceAttr);
                this.mergeSurfaceGeomToMainObj(surfaceAttrName, (ItfSurfaceLinetable2Polygon)polygonizer, nextTid, nextObj);
            }
            return new ObjectEvent(nextObj);
        }
        return rawEvent;
    }

    private void setTopologyValidationDone(AttributeDef attr) {
        if (this.ioxDataPool != null) {
            this.ioxDataPool.setIntermediateValue(attr, "topology", this);
        }
    }

    private void setTopologyValidationFailed(AttributeDef attr) {
        if (this.ioxDataPool != null) {
            this.ioxDataPool.setIntermediateValue(attr, "topologyValidationOk", new Boolean(false));
        }
    }

    private void closePolygonizers() {
        Linetable2Polygon polygonizer;
        if (this.currentAreaAttrs != null) {
            for (AttributeDef areaAttr : this.currentAreaAttrs.keySet()) {
                String areaAttrName = areaAttr.getName();
                polygonizer = this.currentAreaAttrs.get(areaAttr);
                ((ItfAreaLinetable2Polygon)polygonizer).close();
            }
        }
        if (this.currentSurfaceAttrs != null) {
            for (AttributeDef surfaceAttr : this.currentSurfaceAttrs.keySet()) {
                String surfaceAttrName = surfaceAttr.getName();
                polygonizer = this.currentSurfaceAttrs.get(surfaceAttr);
                ((ItfSurfaceLinetable2Polygon)polygonizer).close();
            }
        }
    }

    private void mergeSurfaceGeomToMainObj(String surfaceAttrName, ItfSurfaceLinetable2Polygon polygonizer, String mainObjOid, IomObject mainObj) throws IoxException {
        IomObject polygon = null;
        try {
            polygon = polygonizer.getSurfaceObject(mainObjOid);
            if (polygon != null) {
                mainObj.addattrobj(surfaceAttrName, polygon);
            }
        }
        catch (IoxInvalidDataException e) {
            this.dataerrs.add(e);
        }
    }

    private void mergeAreaGeomToMainObj(String areaAttrName, ItfAreaLinetable2Polygon polygonizer, String mainObjOid, IomObject mainObj) throws IoxException {
        IomObject georef = mainObj.getattrobj(areaAttrName, 0);
        if (georef != null) {
            mainObj.deleteattrobj(areaAttrName, 0);
            mainObj.addattrobj(SAVED_GEOREF_PREFIX + areaAttrName, georef);
            IomObject polygon = null;
            try {
                polygon = polygonizer.getSurfaceObject(mainObjOid);
                if (polygon != null) {
                    mainObj.addattrobj(areaAttrName, polygon);
                }
            }
            catch (IoxInvalidDataException e) {
                this.dataerrs.add(e);
            }
        }
    }

    private void pushBackEvent(IoxEvent rawEvent) {
        if (this._next_Event != null) {
            throw new IllegalStateException("more than one push back event");
        }
        this._next_Event = rawEvent;
    }

    private IoxEvent nextEvent() throws IoxException {
        if (this._next_Event == null) {
            return this.rawReader.read();
        }
        IoxEvent rawEvent = this._next_Event;
        this._next_Event = null;
        return rawEvent;
    }

    private HashMap<AttributeDef, ItfAreaLinetable2Polygon> getAreaAttrs(AbstractClassDef aclass) {
        if (this.attrs_currentClass != aclass) {
            this.initAttrs(aclass);
        }
        return this.attrs_areaAttrs;
    }

    private HashMap<AttributeDef, ItfSurfaceLinetable2Polygon> getSurfaceAttrs(AbstractClassDef aclass) {
        if (this.attrs_currentClass != aclass) {
            this.initAttrs(aclass);
        }
        return this.attrs_surfaceAttrs;
    }

    private void initAttrs(AbstractClassDef<?> aclass) {
        this.attrs_currentClass = aclass;
        this.attrs_areaAttrs = new HashMap();
        this.attrs_surfaceAttrs = new HashMap();
        Iterator attri = aclass.getAttributes();
        while (attri.hasNext()) {
            Linetable2Polygon polygonBuilder;
            Object attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef)) continue;
            AttributeDef attr = (AttributeDef)attrObj;
            Type type = Type.findReal((Type)attr.getDomain());
            if (type instanceof SurfaceType) {
                polygonBuilder = new ItfSurfaceLinetable2Polygon(attr, this.ignorePolygonBuildingErrors);
                ((ItfSurfaceLinetable2Polygon)polygonBuilder).setKeepLinetables(this.readLinetables, ModelUtilities.getHelperTableMainTableRef(attr), ModelUtilities.getHelperTableMainTableRef2(attr));
                this.attrs_surfaceAttrs.put(attr, (ItfSurfaceLinetable2Polygon)polygonBuilder);
                continue;
            }
            if (!(type instanceof AreaType)) continue;
            polygonBuilder = new ItfAreaLinetable2Polygon(attr, this.ignorePolygonBuildingErrors);
            ((ItfAreaLinetable2Polygon)polygonBuilder).setAllowItfAreaHoles(this.allowItfAreaHoles);
            ((ItfAreaLinetable2Polygon)polygonBuilder).setKeepLinetables(this.readLinetables, ModelUtilities.getHelperTableMainTableRef(attr), ModelUtilities.getHelperTableMainTableRef2(attr));
            this.attrs_areaAttrs.put(attr, (ItfAreaLinetable2Polygon)polygonBuilder);
        }
    }

    @Override
    public void setModel(TransferDescription td) {
        this.rawReader.setModel(td);
    }

    public void setBidPrefix(String prefix) {
        this.rawReader.setBidPrefix(prefix);
    }

    public boolean isRenumberTids() {
        return this.rawReader.isRenumberTids();
    }

    public void setRenumberTids(boolean renumberTids) {
        this.rawReader.setRenumberTids(renumberTids);
    }

    public void setReadEnumValAsItfCode(boolean val) {
        this.rawReader.setReadEnumValAsItfCode(val);
    }

    public boolean isReadEnumValAsItfCode() {
        return this.rawReader.isReadEnumValAsItfCode();
    }

    public void setReadLinetables(boolean val) {
        this.readLinetables = val;
    }

    public boolean isReadLinetables() {
        return this.readLinetables;
    }

    public ArrayList<IoxInvalidDataException> getDataErrs() {
        return this.dataerrs;
    }

    public void clearDataErrs() {
        this.dataerrs.clear();
    }

    public IoxDataPool getIoxDataPool() {
        return this.ioxDataPool;
    }

    public void setIoxDataPool(IoxDataPool ioxDataPool) {
        this.ioxDataPool = (PipelinePool)ioxDataPool;
    }

    public boolean isAllowItfAreaHoles() {
        return this.allowItfAreaHoles;
    }

    public void setAllowItfAreaHoles(boolean allowItfAreaHoles) {
        this.allowItfAreaHoles = allowItfAreaHoles;
    }

    public int getIgnorePolygonBuildingErrors() {
        return this.ignorePolygonBuildingErrors;
    }

    public void setIgnorePolygonBuildingErrors(int ignorePolygonBuildingErrors) {
        this.ignorePolygonBuildingErrors = ignorePolygonBuildingErrors;
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
        this.rawReader.setTopicFilter(topicNames);
    }

    @Override
    public String getMimeType() {
        return "application/interlis+txt;version=1.0";
    }
}

