/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.interlis.ilirepository.IliSite;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.ilirepository.impl.VisitorAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RepositoryVisitor {
    private String[] repositoryUri;
    private RepositoryAccess rep = null;
    protected VisitorAction action = null;

    public RepositoryVisitor(RepositoryAccess rep, VisitorAction action) {
        this.rep = rep;
        this.action = action;
    }

    public void setRepositories(String[] repositoryUri) {
        ArrayList<String> repos = new ArrayList<String>();
        for (String uri : repositoryUri) {
            if (uri == null || uri.trim().length() <= 0) continue;
            repos.add(uri.trim());
        }
        this.repositoryUri = repos.toArray(new String[repos.size()]);
    }

    private boolean crawlParents(HashSet<String> visitedSites, List<String> parents) throws RepositoryAccessException {
        while (!parents.isEmpty()) {
            String uri = RepositoryVisitor.fixUri(parents.remove(0));
            if (visitedSites.contains(uri)) continue;
            visitedSites.add(uri);
            boolean stopVisiting = this.action.processRepository(uri, this.rep);
            if (stopVisiting) {
                return true;
            }
            IliSite iliSite = this.rep.getIliSite(uri);
            if (iliSite == null) continue;
            Iterator<String> parenti = iliSite.iteratorParentSite();
            while (parenti.hasNext()) {
                String parent = parenti.next();
                parents.add(parent);
            }
        }
        return false;
    }

    public static String fixUri(String uri) {
        if (uri.endsWith("/")) {
            return uri;
        }
        uri = uri + "/";
        return uri;
    }

    public void visitRepositories() throws RepositoryAccessException {
        Iterator<String> parenti;
        boolean stopVisiting;
        HashSet<String> visitedSites = new HashSet<String>();
        for (int i = 0; i < this.repositoryUri.length; ++i) {
            String uri = RepositoryVisitor.fixUri(this.repositoryUri[i]);
            if (visitedSites.contains(uri)) continue;
            visitedSites.add(uri);
            stopVisiting = this.action.processRepository(uri, this.rep);
            if (!stopVisiting) continue;
            return;
        }
        ArrayList<String> parents = new ArrayList<String>();
        ArrayList<String> subsidiaries = new ArrayList<String>();
        for (int i = 0; i < this.repositoryUri.length; ++i) {
            String uri = this.repositoryUri[i];
            IliSite iliSite = this.rep.getIliSite(uri);
            if (iliSite == null) continue;
            parenti = iliSite.iteratorParentSite();
            while (parenti.hasNext()) {
                String parent = parenti.next();
                parents.add(parent);
            }
            Iterator<String> subsidiaryi = iliSite.iteratorSubsidiarySite();
            while (subsidiaryi.hasNext()) {
                String subsidiary = subsidiaryi.next();
                subsidiaries.add(subsidiary);
            }
        }
        stopVisiting = this.crawlParents(visitedSites, parents);
        if (stopVisiting) {
            return;
        }
        while (!subsidiaries.isEmpty()) {
            String uri = RepositoryVisitor.fixUri((String)subsidiaries.remove(0));
            if (visitedSites.contains(uri)) continue;
            visitedSites.add(uri);
            boolean stopVisiting2 = this.action.processRepository(uri, this.rep);
            if (stopVisiting2) {
                return;
            }
            IliSite iliSite = this.rep.getIliSite(uri);
            if (iliSite == null) continue;
            Iterator<String> subsidiaryi = iliSite.iteratorSubsidiarySite();
            while (subsidiaryi.hasNext()) {
                String subsidiary = subsidiaryi.next();
                subsidiaries.add(subsidiary);
            }
            parenti = iliSite.iteratorParentSite();
            while (parenti.hasNext()) {
                String parent = parenti.next();
                parents.add(parent);
            }
            boolean stopVisiting3 = this.crawlParents(visitedSites, parents);
            if (!stopVisiting3) continue;
            return;
        }
    }
}

