/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.base;

import ch.ehi.basics.logging.EhiLogger;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StatementExecutionHelper {
    private Integer batchSize = null;
    private int queuedBatch = 0;
    private boolean shouldBatch = false;
    private int singleUpdatesCount = 0;
    private int totalBatchUpdatesCount = 0;

    public StatementExecutionHelper(Integer batchSize) {
        this.batchSize = batchSize;
        this.shouldBatch = this.batchSize != null && batchSize > 1;
    }

    public void write(PreparedStatement ps) throws SQLException {
        if (this.shouldBatch) {
            ps.addBatch();
            ++this.queuedBatch;
            if (this.queuedBatch >= this.batchSize) {
                int[] updates = ps.executeBatch();
                this.totalBatchUpdatesCount += updates.length;
                ps.clearBatch();
                this.queuedBatch = 0;
                EhiLogger.traceState((String)("batch executed, update counts: " + updates.length));
            }
        } else {
            ps.executeUpdate();
            ++this.singleUpdatesCount;
        }
    }

    public void flush(PreparedStatement ps) throws SQLException {
        if (this.shouldBatch) {
            int[] updates = ps.executeBatch();
            this.totalBatchUpdatesCount += updates.length;
            ps.clearBatch();
            this.queuedBatch = 0;
            EhiLogger.traceState((String)("total batch updates executed: " + this.totalBatchUpdatesCount));
        } else {
            EhiLogger.traceState((String)("single updates executed: " + this.singleUpdatesCount));
        }
    }
}

