/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2mssql;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2mssql.MsSqlCustomStrategy;
import ch.ehi.ili2mssql.MsSqlSequenceBasedIdGen;
import ch.ehi.ili2mssql.converter.MsSqlColumnConverter;
import ch.ehi.ili2mssql.sqlgen.GeneratorMsSql;
import java.text.ParseException;

public class MsSqlMain
extends AbstractMain {
    String dbinstance = "";
    boolean dbWindowsAuth = false;

    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(MsSqlColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorMsSql.class.getName());
        config.setJdbcDriver("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        config.setIdGenerator(MsSqlSequenceBasedIdGen.class.getName());
        config.setIli2dbCustomStrategy(MsSqlCustomStrategy.class.getName());
        config.setUuidDefaultValue("NEWID()");
        config.setValue("ch.ehi.ili2db.modelsTabModelnameColSize", "400");
    }

    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            public String makeUrl(Config config) {
                if (config.getDbdatabase() != null) {
                    String strDbHost = !MsSqlMain.this.isNullOrEmpty(config.getDbhost()) ? config.getDbhost() : "localhost";
                    String strInstance = !MsSqlMain.this.isNullOrEmpty(MsSqlMain.this.dbinstance) ? "\\" + MsSqlMain.this.dbinstance : "";
                    String strPort = !MsSqlMain.this.isNullOrEmpty(config.getDbport()) ? ":" + config.getDbport() : "";
                    String strDbdatabase = ";databaseName=" + config.getDbdatabase();
                    String strWindowsAuth = MsSqlMain.this.dbWindowsAuth ? ";integratedSecurity=true" : "";
                    return "jdbc:sqlserver://" + strDbHost + strInstance + strPort + strDbdatabase + strWindowsAuth;
                }
                return null;
            }
        };
    }

    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return null;
    }

    public static void main(String[] args) {
        new MsSqlMain().domain(args);
    }

    public String getAPP_NAME() {
        return "ili2mssql";
    }

    public String getDB_PRODUCT_NAME() {
        return "SQL Server";
    }

    public String getJAR_NAME() {
        return "ili2mssql.jar";
    }

    protected void printConnectOptions() {
        System.err.println("--dbhost  host         The host name of the server. Defaults to localhost.");
        System.err.println("--dbport  port         The port number the server is listening on. Defaults to 1433.");
        System.err.println("--dbdatabase database  The database name.");
        System.err.println("--dbusr  username      User name to access database.");
        System.err.println("--dbpwd  password      Password of user used to access database.");
    }

    protected void printSpecificOptions() {
        System.err.println("--dbinstance instance  The instance of the Database Engine");
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
        System.err.println("--dbwindowsauth        SQL Server validates a user's identity using only his Windows username and password");
    }

    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbhost")) {
            config.setDbhost(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbport")) {
            config.setDbport(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbdatabase")) {
            config.setDbdatabase(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbusr")) {
            config.setDbusr(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbpwd")) {
            config.setDbpwd(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbschema")) {
            config.setDbschema(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbinstance")) {
            this.dbinstance = args[++argi];
            ++argi;
        } else if (this.isOption(arg, "--dbwindowsauth")) {
            ++argi;
            this.dbWindowsAuth = this.parseBooleanArgument(arg);
        }
        return argi;
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

