/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator.nls;

import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.NlsModelElement;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Ili2TranslationXml {
    private Map<String, NlsModelElement> elements = new HashMap<String, NlsModelElement>();
    public static final String METAOBJECT = ".METAOBJECT.";
    public static final String FR = "fr";
    public static final String IT = "it";
    public static final String EN = "en";
    public static final String DE = "de";

    public ModelElements convertTransferDescription2ModelElements(TransferDescription td) {
        Model[] models = td.getModelsFromLastFile();
        List<NlsModelElement> nlsEles = this.convertModels(models);
        ModelElements ret = new ModelElements();
        for (NlsModelElement nlsEle : nlsEles) {
            TranslationElement ele = new TranslationElement();
            ele.setScopedName(nlsEle.getScopedName());
            ele.setElementType(nlsEle.getElementType());
            ele.setName_de(this.makeNotNull(nlsEle.getName(DE)));
            ele.setDocumentation_de(this.makeNotNull(nlsEle.getDocumentation(DE)));
            ele.setName_it(this.makeNotNull(nlsEle.getName(IT)));
            ele.setDocumentation_it(this.makeNotNull(nlsEle.getDocumentation(IT)));
            ele.setName_fr(this.makeNotNull(nlsEle.getName(FR)));
            ele.setDocumentation_fr(this.makeNotNull(nlsEle.getDocumentation(FR)));
            ele.setName_en(this.makeNotNull(nlsEle.getName(EN)));
            ele.setDocumentation_en(this.makeNotNull(nlsEle.getDocumentation(EN)));
            ret.add(ele);
            List<String> metaAttrNames = nlsEle.getMetaAttrs();
            for (String metaAttrName : metaAttrNames) {
                String metaAttrValue = nlsEle.getMetaAttr(metaAttrName);
                if (metaAttrValue == null) continue;
                TranslationElement ele2 = new TranslationElement();
                ele2.setScopedName(Ili2TranslationXml.getMetaAttributeScopedName(nlsEle.getScopedName(), metaAttrName));
                ele2.setElementType("METAATTRIBUTE");
                ele2.setName_de(metaAttrValue);
                ret.add(ele2);
            }
        }
        return ret;
    }

    private String makeNotNull(String val) {
        return val == null ? "" : val;
    }

    public static void writeModelElementsAsXML(ModelElements eles, File fileName) throws Exception {
        Class[] jaxbContextPath = new Class[]{ModelElements.class};
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbContextPath);
        Marshaller ms = jaxbContext.createMarshaller();
        ms.marshal((Object)eles, fileName);
    }

    public List<NlsModelElement> convertModels(Model[] models) {
        for (Model model : models) {
            this.visitElement(model);
        }
        ArrayList<NlsModelElement> ret = new ArrayList<NlsModelElement>();
        ArrayList<String> iliNames = new ArrayList<String>();
        iliNames.addAll(this.elements.keySet());
        Collections.sort(iliNames);
        for (String iliName : iliNames) {
            NlsModelElement nlsEle = this.elements.get(iliName);
            ret.add(nlsEle);
        }
        return ret;
    }

    private String getElementType(Object model) {
        if (model instanceof Model) {
            return "MODEL";
        }
        if (model instanceof AttributeDef) {
            return "ATTRIBUTE";
        }
        if (model instanceof RoleDef) {
            return "ROLE";
        }
        if (model instanceof Function) {
            return "FUNCTION";
        }
        if (model instanceof Parameter) {
            return "PARAMETER";
        }
        if (model instanceof FormalArgument) {
            return "FORMAL ARGUMENT";
        }
        if (model instanceof Domain) {
            return "DOMAIN";
        }
        if (model instanceof LineForm) {
            return "LINE FORM";
        }
        if (model instanceof Unit) {
            return "UNIT";
        }
        if (model instanceof Topic) {
            return "TOPIC";
        }
        if (model instanceof MetaDataUseDef) {
            return "META DATA BASKET";
        }
        if (model instanceof AbstractClassDef) {
            return this.findElementType(model);
        }
        if (model instanceof AssociationDef) {
            return "ASSOCIATION";
        }
        if (model instanceof View) {
            return "VIEW";
        }
        if (model instanceof Graphic) {
            return "GRAPHIC";
        }
        if (model instanceof Constraint) {
            return "CONSTRAINT";
        }
        if (model instanceof ExpressionSelection) {
            return "EXPRESSION SELECTION";
        }
        if (model instanceof SignAttribute) {
            return "SIGN ATTRIBUTE";
        }
        if (model instanceof Enumeration.Element) {
            return "ENUMERATION ELEMENT";
        }
        return "";
    }

    private String findElementType(Object model) {
        AbstractClassDef abstractClassDefiniton = (AbstractClassDef)model;
        if (abstractClassDefiniton instanceof Table) {
            Table table = (Table)abstractClassDefiniton;
            if (table.isIdentifiable()) {
                return "CLASS";
            }
            return "STRUCTURE";
        }
        if (abstractClassDefiniton instanceof AssociationDef) {
            return "ASSOCIATION";
        }
        throw new IllegalArgumentException("Unexpected AbstractClassDef");
    }

    public static Element getElementInRootLanguage(Element ele) {
        Element baseLanguageElement = ele.getTranslationOf();
        while (baseLanguageElement != null) {
            ele = baseLanguageElement;
            baseLanguageElement = ele.getTranslationOf();
        }
        return ele;
    }

    private void setModelElementAllLanguages(NlsModelElement translationElement, Element modelElement) {
        String language = Ili2TranslationXml.getLanguage(modelElement);
        this.setModelElementOneLanguage(translationElement, modelElement, language);
        Element baseLanguageElement = modelElement.getTranslationOf();
        while (baseLanguageElement != null) {
            language = Ili2TranslationXml.getLanguage(baseLanguageElement);
            this.setModelElementOneLanguage(translationElement, baseLanguageElement, language);
            Element translatedElement = baseLanguageElement;
            baseLanguageElement = translatedElement.getTranslationOf();
        }
    }

    public static String getLanguage(Element ele) {
        if (ele instanceof Model) {
            return ((Model)ele).getLanguage();
        }
        return ((Model)ele.getContainer(Model.class)).getLanguage();
    }

    private void setModelElementOneLanguage(NlsModelElement text, Element model, String language) {
        if (model.getName() != null) {
            text.setName(language, model.getName());
        }
        if (model.getDocumentation() != null) {
            text.setDocumentation(language, model.getDocumentation());
        }
        this.visitMetaAttributes(text, model);
    }

    private void visitEnumerationElement(NlsModelElement nlsEle, Enumeration.Element element, String language) {
        nlsEle.setName(language, element.getName());
        nlsEle.setDocumentation(language, element.getDocumentation());
    }

    private void visitElement(Element ele) {
        block7: {
            block8: {
                block6: {
                    Element rootEle = Ili2TranslationXml.getElementInRootLanguage(ele);
                    NlsModelElement nlsEle = this.getNlsModelElement(rootEle.getScopedName());
                    this.setModelElementAllLanguages(nlsEle, ele);
                    nlsEle.setElementType(this.getElementType(ele));
                    if (!(ele instanceof AttributeDef)) break block6;
                    AttributeDef attr = (AttributeDef)ele;
                    if (!(attr.getDomain() instanceof EnumerationType)) break block7;
                    String attrRootScopedName = Ili2TranslationXml.getElementInRootLanguage(attr).getScopedName();
                    this.visitEnumarationType((EnumerationType)attr.getDomain(), attrRootScopedName, attr);
                    break block7;
                }
                if (!(ele instanceof Domain)) break block8;
                Domain domain = (Domain)ele;
                if (!(domain.getType() instanceof EnumerationType)) break block7;
                String domainRootScopedName = Ili2TranslationXml.getElementInRootLanguage(domain).getScopedName();
                this.visitEnumarationType((EnumerationType)domain.getType(), domainRootScopedName, domain);
                break block7;
            }
            if (ele instanceof Function) {
                Function function = (Function)ele;
                String lang = Ili2TranslationXml.getLanguage(function);
                String rootFunctionScopedName = Ili2TranslationXml.getElementInRootLanguage(function).getScopedName();
                FormalArgument[] args = function.getArguments();
                for (int i = 0; i < args.length; ++i) {
                    String rootArgScopedName = rootFunctionScopedName + "." + Ili2TranslationXml.getElementInRootLanguage(args[i]).getName();
                    NlsModelElement nlsArg = this.getNlsModelElement(rootArgScopedName);
                    nlsArg.setElementType(this.getElementType(args[i]));
                    this.setModelElementOneLanguage(nlsArg, args[i], lang);
                    for (Function baseFunction = (Function)function.getTranslationOf(); baseFunction != null; baseFunction = (Function)baseFunction.getTranslationOf()) {
                        FormalArgument[] baseArgs = baseFunction.getArguments();
                        this.setModelElementOneLanguage(nlsArg, baseArgs[i], Ili2TranslationXml.getLanguage(baseFunction));
                    }
                }
            } else if (ele instanceof Container) {
                Iterator eleIt = ((Container)ele).iterator();
                while (eleIt.hasNext()) {
                    this.visitElement((Element)eleIt.next());
                }
            }
        }
    }

    private void visitMetaAttributes(NlsModelElement nlsEle, Element ele) {
        for (String metaAttrName : ele.getMetaValues().getValues()) {
            String metaAttrValue = ele.getMetaValue(metaAttrName);
            nlsEle.setMetaAttr(metaAttrName, metaAttrValue);
        }
    }

    private NlsModelElement getNlsModelElement(String scopedName) {
        if (this.elements.containsKey(scopedName)) {
            return this.elements.get(scopedName);
        }
        NlsModelElement nlsEle = new NlsModelElement();
        nlsEle.setScopedName(scopedName);
        this.elements.put(nlsEle.getScopedName(), nlsEle);
        return nlsEle;
    }

    public static String getMetaAttributeScopedName(String eleScopedName, String metaAttrName) {
        return eleScopedName + METAOBJECT + metaAttrName;
    }

    private void visitEnumarationType(EnumerationType et, String scopedNamePrefix, Element domainOrAttr) {
        Enumeration enumeration = et.getEnumeration();
        this.visitEnumaration(enumeration, scopedNamePrefix, domainOrAttr);
    }

    private void visitEnumaration(Enumeration enumeration, String scopedNamePrefix, Element domainOrAttr) {
        Iterator<Enumeration.Element> enumarationIterator = enumeration.getElements();
        while (enumarationIterator.hasNext()) {
            Enumeration.Element enumEle = enumarationIterator.next();
            String scopedName = scopedNamePrefix + "." + Ili2TranslationXml.getEnumerationElementInRootLanguage(enumEle).getName();
            NlsModelElement nlsEle = this.getNlsModelElement(scopedName);
            nlsEle.setElementType(this.getElementType(enumEle));
            String language = Ili2TranslationXml.getLanguage(domainOrAttr);
            this.visitEnumerationElement(nlsEle, enumEle, language);
            this.visitEnumerationElementMetaAttributes(nlsEle, enumEle);
            Enumeration.Element baseLanguageElement = enumEle.getTranslationOf();
            Element baseLanguageModelElement = domainOrAttr.getTranslationOf();
            while (baseLanguageElement != null) {
                String baseLanguage = Ili2TranslationXml.getLanguage(baseLanguageModelElement);
                this.visitEnumerationElement(nlsEle, baseLanguageElement, baseLanguage);
                this.visitEnumerationElementMetaAttributes(nlsEle, baseLanguageElement);
                baseLanguageElement = baseLanguageElement.getTranslationOf();
                baseLanguageModelElement = baseLanguageModelElement.getTranslationOf();
            }
            if (enumEle.getSubEnumeration() == null) continue;
            this.visitEnumaration(enumEle.getSubEnumeration(), scopedName, domainOrAttr);
        }
    }

    private void visitEnumerationElementMetaAttributes(NlsModelElement nlsEle, Enumeration.Element ele) {
        for (String metaAttrName : ele.getMetaValues().getValues()) {
            String metaAttrValue = ele.getMetaValues().getValue(metaAttrName);
            nlsEle.setMetaAttr(metaAttrName, metaAttrValue);
        }
    }

    private static Enumeration.Element getEnumerationElementInRootLanguage(Enumeration.Element ele) {
        Enumeration.Element baseLanguageElement = ele.getTranslationOf();
        while (baseLanguageElement != null) {
            ele = baseLanguageElement;
            baseLanguageElement = ele.getTranslationOf();
        }
        return ele;
    }

    public static ModelElements readModelElementsXml(File file) throws Exception {
        Unmarshaller um = Ili2TranslationXml.createUnmarshaller();
        ModelElements modelElements = (ModelElements)um.unmarshal(file);
        return modelElements;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        Class[] jaxbContextPath = new Class[]{ModelElements.class};
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbContextPath);
        Unmarshaller um = jaxbContext.createUnmarshaller();
        return um;
    }
}

