/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2h2gis;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class GeneratorH2gis
extends GeneratorJdbc {
    private boolean createGeomIdx = false;
    private ArrayList<DbColumn> indexColumns = null;

    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        if ("True".equalsIgnoreCase(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            this.createGeomIdx = true;
        }
    }

    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String type = "";
        String size = "";
        Object notSupported = null;
        boolean createColNow = true;
        if (column instanceof DbColBoolean) {
            type = "boolean";
        } else if (column instanceof DbColDateTime) {
            type = "timestamp";
        } else if (column instanceof DbColDate) {
            type = "date";
        } else if (column instanceof DbColTime) {
            type = "time";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "decimal(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            DbColGeometry geo = (DbColGeometry)column;
            if (!geo.getSrsAuth().equals("EPSG")) {
                throw new IllegalArgumentException("unexpected SrsAuth <" + geo.getSrsAuth() + ">");
            }
            type = "geometry(" + GeneratorH2gis.getH2gisType(geo.getType()) + (geo.getDimension() == 3 ? ",Z" : "") + "," + geo.getSrsId() + ")";
            type = "geometry";
        } else {
            int colsize;
            DbColNumber col;
            type = column instanceof DbColId ? "bigint" : (column instanceof DbColUuid ? "uuid" : (column instanceof DbColNumber ? ((col = (DbColNumber)column).getSize() > 10 || col.getMaxValue() != null && col.getMaxValue() > Integer.MAX_VALUE || col.getMinValue() != null && col.getMinValue() < Integer.MIN_VALUE ? "bigint" : "integer") : (column instanceof DbColVarchar ? ((colsize = ((DbColVarchar)column).getSize()) == -1 ? "varchar" : "varchar(" + Integer.toString(colsize) + ")") : (column instanceof DbColBlob ? "binary" : (column instanceof DbColXml ? "varchar" : (column instanceof DbColJson ? "varchar" : "varchar"))))));
        }
        String cmt = column.getComment();
        cmt = cmt != null ? " COMMENT '" + GeneratorH2gis.escapeString(cmt) + "'" : "";
        if (column.getArraySize() != 0 && !(column instanceof DbColJson)) {
            String isNull = column.isNotNull() ? "NOT NULL" : "NULL";
            type = "TEXT";
            String name = column.getName();
            this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + isNull + cmt + this.newline());
            this.colSep = ",";
        } else {
            String sep = " ";
            String defaultValue = "";
            if (column.getDefaultValue() != null) {
                defaultValue = sep + "DEFAULT " + column.getDefaultValue();
            }
            String isNull = sep + (column.isNotNull() ? "NOT NULL" : "NULL");
            if (column.isPrimaryKey()) {
                isNull = sep + "PRIMARY KEY";
            }
            if (column.isIndex() || this.createGeomIdx && column instanceof DbColGeometry) {
                this.indexColumns.add(column);
            }
            if (createColNow) {
                String name = column.getName();
                this.out.write(this.getIndent() + this.colSep + name + " " + type + defaultValue + isNull + cmt + this.newline());
                this.colSep = ",";
            }
        }
    }

    public void visit1TableBegin(DbTable tab) throws IOException {
        super.visit1TableBegin(tab);
        this.indexColumns = new ArrayList();
    }

    public void visitTableEndColumn(DbTable tab) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitIndex(DbIndex idx) throws IOException {
        if (idx.isUnique()) {
            StringWriter out = new StringWriter();
            DbTable tab = idx.getTable();
            String tableName = tab.getName().getQName();
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            out.write(this.getIndent() + "CREATE UNIQUE INDEX " + constraintName + " ON " + tableName + " (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                if (attr instanceof DbColGeometry) {
                    if (((DbColGeometry)attr).getType() == 0) {
                        // empty if block
                    }
                    out.write(sep + "ST_AsBinary(" + attr.getName() + ")");
                } else {
                    out.write(sep + attr.getName());
                }
                sep = ",";
            }
            out.write(")" + this.newline());
            String stmt = out.toString();
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, stmt));
            out = null;
            if (this.conn != null && this.createdTables.contains(tab.getName())) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt);
                        dbstmt.executeUpdate(stmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add UNIQUE to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
    }

    protected String getTableEndOptions(DbTable tab) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit1TableEnd(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            sqlTabName = tab.getName().getSchema() + "." + sqlTabName;
        }
        boolean tableExists = GeneratorH2gis.tableExists(this.conn, tab.getName());
        super.visit1TableEnd(tab);
        String cmt = tab.getComment();
        if (cmt != null) {
            String cmtstmt = "COMMENT ON TABLE " + sqlTabName + " IS '" + GeneratorH2gis.escapeString(cmt) + "';";
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, cmtstmt));
            if (this.conn != null && !tableExists) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)cmtstmt);
                        dbstmt.execute(cmtstmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add comment on table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        for (DbColumn idxcol : this.indexColumns) {
            String idxstmt = null;
            String idxName = this.createConstraintName(tab, "idx", new String[]{idxcol.getName().toLowerCase()});
            idxstmt = idxcol instanceof DbColGeometry ? "CREATE SPATIAL INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )" : "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )";
            this.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt((GeneratorJdbc)this, idxstmt));
            if (this.conn == null || tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)idxstmt);
                    dbstmt.execute(idxstmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add index on column " + tab.getName() + "." + idxcol.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
        this.indexColumns = null;
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getH2gisType(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMETRYCOLLECTION";
            }
        }
        throw new IllegalArgumentException();
    }

    public void visitTableBeginConstraint(DbTable dbTab) throws IOException {
        super.visitTableBeginConstraint(dbTab);
        String sqlTabName = dbTab.getName().getQName();
        Iterator dbColi = dbTab.iteratorColumn();
        while (dbColi.hasNext()) {
            String constraintName;
            CharSequence action;
            String createstmt;
            DbColNumber dbColNum;
            DbColumn dbCol = (DbColumn)dbColi.next();
            if (dbCol instanceof DbColNumber && (((DbColNumber)dbCol).getMinValue() != null || ((DbColNumber)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColNumber)dbCol;
                    createstmt = null;
                    action = "";
                    if (dbColNum.getMinValue() != null || dbColNum.getMaxValue() != null) {
                        action = dbColNum.getMaxValue() == null ? ">=" + dbColNum.getMinValue() : (dbColNum.getMinValue() == null ? "<=" + dbColNum.getMaxValue() : "BETWEEN " + dbColNum.getMinValue() + " AND " + dbColNum.getMaxValue());
                    }
                    constraintName = this.createConstraintName(dbTab, "check", new String[]{dbCol.getName()});
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " CHECK( " + dbCol.getName() + " " + (String)action + ")";
                    Object var9_10 = null;
                    String string = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
                    this.addConstraint(dbTab, constraintName, createstmt, string);
                }
            } else if (dbCol instanceof DbColDecimal && (((DbColDecimal)dbCol).getMinValue() != null || ((DbColDecimal)dbCol).getMaxValue() != null) && dbCol.getArraySize() == 0) {
                dbColNum = (DbColDecimal)dbCol;
                createstmt = null;
                action = "";
                if (dbColNum.getMinValue() != null || dbColNum.getMaxValue() != null) {
                    action = dbColNum.getMaxValue() == null ? ">=" + dbColNum.getMinValue() : (dbColNum.getMinValue() == null ? "<=" + dbColNum.getMaxValue() : "BETWEEN " + dbColNum.getMinValue() + " AND " + dbColNum.getMaxValue());
                }
                constraintName = this.createConstraintName(dbTab, "check", new String[]{dbCol.getName()});
                createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " CHECK( " + dbCol.getName() + " " + (String)action + ")";
                Object var9_12 = null;
                String string = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
                this.addConstraint(dbTab, constraintName, createstmt, string);
            }
            if (!(dbCol instanceof DbColVarchar) || ((DbColVarchar)dbCol).getValueRestriction() == null || dbCol.getArraySize() != 0) continue;
            DbColVarchar dbColTxt = (DbColVarchar)dbCol;
            createstmt = null;
            action = new StringBuffer("IN (");
            String sep = "";
            for (String restrictedValue : dbColTxt.getValueRestriction()) {
                ((StringBuffer)action).append(sep);
                ((StringBuffer)action).append("'");
                ((StringBuffer)action).append(GeneratorH2gis.escapeString(restrictedValue));
                ((StringBuffer)action).append("'");
                sep = ",";
            }
            ((StringBuffer)action).append(")");
            String string = this.createConstraintName(dbTab, "check", new String[]{dbCol.getName()});
            createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + ((StringBuffer)action).toString() + ")";
            String dropstmt2 = null;
            dropstmt2 = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
            this.addConstraint(dbTab, string, createstmt, dropstmt2);
        }
    }

    private DbColumn getPrimaryKeyColumn(DbSchema schema, DbTableName referencedTableName) {
        DbTable referencedTable = schema.findTable(referencedTableName);
        Iterator dbColIt = referencedTable.iteratorColumn();
        while (dbColIt.hasNext()) {
            DbColumn dbCol = (DbColumn)dbColIt.next();
            if (!dbCol.isPrimaryKey()) continue;
            return dbCol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(Connection conn, DbTableName tableName) {
        try {
            if (conn == null) return false;
            DatabaseMetaData meta = conn.getMetaData();
            String catalog = conn.getCatalog();
            String schema = tableName.getSchema();
            if (schema == null && ((schema = meta.getUserName()) == null || schema.equals(""))) {
                schema = "PUBLIC";
            }
            ResultSet rs = null;
            try {
                String db_tableName;
                String db_schemaName;
                rs = meta.getTables(null, null, null, null);
                do {
                    if (!rs.next()) return false;
                    String db_catalogName = rs.getString("TABLE_CAT");
                    db_schemaName = rs.getString("TABLE_SCHEM");
                    db_tableName = rs.getString("TABLE_NAME");
                } while (db_schemaName != null && !db_schemaName.equalsIgnoreCase(schema) || !db_tableName.equalsIgnoreCase(tableName.getName()));
                boolean bl = true;
                return bl;
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if table " + tableName + " exists", ex);
        }
    }
}

