/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.api.Aggregate;
import org.h2gis.api.AbstractFunction;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ST_Extent
extends AbstractFunction
implements Aggregate {
    private Envelope aggregatedEnvelope = new Envelope();

    public ST_Extent() {
        this.addProperty("remarks", "Return an envelope of the aggregation of all geometries in the table.");
    }

    public void init(Connection connection) throws SQLException {
        this.aggregatedEnvelope = new Envelope();
    }

    public int getInternalType(int[] inputTypes) throws SQLException {
        if (inputTypes.length != 1) {
            throw new SQLException(ST_Extent.class.getSimpleName() + " expect 1 argument.");
        }
        if (inputTypes[0] != 22) {
            throw new SQLException(ST_Extent.class.getSimpleName() + " expect a geometry argument");
        }
        return 22;
    }

    public void add(Object o) throws SQLException {
        if (o instanceof Geometry) {
            Geometry geom = (Geometry)o;
            this.aggregatedEnvelope.expandToInclude(geom.getEnvelopeInternal());
        }
    }

    public Geometry getResult() throws SQLException {
        if (this.aggregatedEnvelope.isNull()) {
            return null;
        }
        return new GeometryFactory().toGeometry(this.aggregatedEnvelope);
    }
}

