/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.mesh.DelaunayData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class ST_3DArea
extends DeterministicScalarFunction {
    public ST_3DArea() {
        this.addProperty("remarks", "Compute the 3D area of a polygon or a multipolygon derived from a 3D triangular decomposition.\nDistance units are those of the geometry spatial reference system.");
    }

    public String getJavaStaticMethod() {
        return "st3darea";
    }

    public static Double st3darea(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        double area = 0.0;
        for (int idPoly = 0; idPoly < geometry.getNumGeometries(); ++idPoly) {
            Geometry subGeom = geometry.getGeometryN(idPoly);
            if (!(subGeom instanceof Polygon)) continue;
            area += ST_3DArea.compute3DArea((Polygon)subGeom).doubleValue();
        }
        return area;
    }

    private static Double compute3DArea(Polygon geometry) {
        DelaunayData delaunayData = new DelaunayData();
        delaunayData.put((Geometry)geometry, DelaunayData.MODE.TESSELLATION);
        delaunayData.triangulate();
        return delaunayData.get3DArea();
    }
}

