/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.ST_GeomFromText;
import org.locationtech.jts.geom.Geometry;

public class ST_PointFromText
extends DeterministicScalarFunction {
    public static final String TYPE_ERROR = "The provided WKT Geometry is not a POINT. Type: ";

    public ST_PointFromText() {
        this.addProperty("remarks", "Convert a WKT String into a POINT.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String wKT) throws SQLException {
        return ST_PointFromText.toGeometry(wKT, 0);
    }

    public static Geometry toGeometry(String wKT, int srid) throws SQLException {
        if (wKT == null) {
            return null;
        }
        Geometry geometry = ST_GeomFromText.toGeometry(wKT, srid);
        String geometryType = geometry.getGeometryType();
        if (!geometryType.equalsIgnoreCase("POINT")) {
            throw new SQLException(TYPE_ERROR + geometryType);
        }
        return geometry;
    }
}

