/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.URIUtilities;

public class TSVRead
extends AbstractFunction
implements ScalarFunction {
    public TSVRead() {
        this.addProperty("remarks", "Read a Tab-separated values file.");
    }

    public String getJavaStaticMethod() {
        return "readTSV";
    }

    public static void readTSV(Connection connection, String fileName, String tableReference) throws SQLException, FileNotFoundException, IOException {
        File file = URIUtilities.fileFromString((String)fileName);
        if (FileUtil.isFileImportable(file, "tsv")) {
            TSVDriverFunction tsvDriver = new TSVDriverFunction();
            tsvDriver.importFile(connection, tableReference, file, (ProgressVisitor)new EmptyProgressVisitor());
        }
    }

    public static void readTSV(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase();
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        TSVRead.readTSV(connection, fileName, tableName);
    }
}

