/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import org.h2gis.functions.io.shp.internal.MultiLineHandler;
import org.h2gis.functions.io.shp.internal.MultiPointHandler;
import org.h2gis.functions.io.shp.internal.PointHandler;
import org.h2gis.functions.io.shp.internal.PolygonHandler;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapefileException;

public final class ShapeType {
    public static final ShapeType NULL = new ShapeType(0, "Null");
    public static final ShapeType POINT = new ShapeType(1, "Point");
    public static final ShapeType POINTZ = new ShapeType(11, "PointZ");
    public static final ShapeType POINTM = new ShapeType(21, "PointM");
    public static final ShapeType ARC = new ShapeType(3, "Arc");
    public static final ShapeType ARCZ = new ShapeType(13, "ArcZ");
    public static final ShapeType ARCM = new ShapeType(23, "ArcM");
    public static final ShapeType POLYGON = new ShapeType(5, "Polygon");
    public static final ShapeType POLYGONZ = new ShapeType(15, "PolygonZ");
    public static final ShapeType POLYGONM = new ShapeType(25, "PolygonM");
    public static final ShapeType MULTIPOINT = new ShapeType(8, "MultiPoint");
    public static final ShapeType MULTIPOINTZ = new ShapeType(18, "MultiPointZ");
    public static final ShapeType MULTIPOINTM = new ShapeType(28, "MultiPointM");
    public static final ShapeType UNDEFINED = new ShapeType(-1, "Undefined");
    public final int id;
    public final String name;

    protected ShapeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMultiPoint() {
        boolean mp = true;
        if (this == UNDEFINED) {
            mp = false;
        } else if (this == NULL) {
            mp = false;
        } else if (this == POINT) {
            mp = false;
        }
        return mp;
    }

    public boolean isPointType() {
        return this.id % 10 == 1;
    }

    public boolean isLineType() {
        return this.id % 10 == 3;
    }

    public boolean isPolygonType() {
        return this.id % 10 == 5;
    }

    public boolean isMultiPointType() {
        return this.id % 10 == 8;
    }

    public static ShapeType forID(int id) {
        ShapeType t;
        switch (id) {
            case 0: {
                t = NULL;
                break;
            }
            case 1: {
                t = POINT;
                break;
            }
            case 11: {
                t = POINTZ;
                break;
            }
            case 21: {
                t = POINTM;
                break;
            }
            case 3: {
                t = ARC;
                break;
            }
            case 13: {
                t = ARCZ;
                break;
            }
            case 23: {
                t = ARCM;
                break;
            }
            case 5: {
                t = POLYGON;
                break;
            }
            case 15: {
                t = POLYGONZ;
                break;
            }
            case 25: {
                t = POLYGONM;
                break;
            }
            case 8: {
                t = MULTIPOINT;
                break;
            }
            case 18: {
                t = MULTIPOINTZ;
                break;
            }
            case 28: {
                t = MULTIPOINTM;
                break;
            }
            default: {
                t = UNDEFINED;
            }
        }
        return t;
    }

    public ShapeHandler getShapeHandler() throws ShapefileException {
        ShapeHandler handler;
        switch (this.id) {
            case 1: 
            case 11: 
            case 21: {
                handler = new PointHandler(this);
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                handler = new MultiLineHandler(this);
                break;
            }
            case 5: 
            case 15: 
            case 25: {
                handler = new PolygonHandler(this);
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                handler = new MultiPointHandler(this);
                break;
            }
            default: {
                handler = null;
            }
        }
        return handler;
    }
}

