/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.osm.OSMDriverFunction;
import org.h2gis.functions.io.osm.OSMTablesFactory;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.URIUtilities;

public class OSMRead
extends AbstractFunction
implements ScalarFunction {
    public OSMRead() {
        this.addProperty("remarks", "Read a OSM file and copy the content in the specified tables.\nThe user can set a prefix name for all OSM tables and specify if the existing OSM\n tables must be dropped.\nHere a sample in order to extract buildings polygons using way nodes:\ncreate index on MAP_WAY_NODE(ID_WAY,ID_NODE);\ndrop table if exists MAP_BUILDINGS,MAP_WAY_GEOM;\ncreate table MAP_BUILDINGS(ID_WAY bigint primary key) as SELECT DISTINCT ID_WAY FROM MAP_WAY_TAG WT, MAP_TAG T WHERE WT.ID_TAG = T.ID_TAG AND T.TAG_KEY IN ('building');\ncreate table MAP_WAY_GEOM(ID_WAY BIGINT PRIMARY KEY, THE_GEOM POLYGON) AS SELECT ID_WAY, ST_MAKEPOLYGON(ST_MAKELINE(THE_GEOM)) THE_GEOM FROM (SELECT (SELECT ST_ACCUM(THE_GEOM) THE_GEOM FROM (SELECT N.ID_NODE, N.THE_GEOM,WN.ID_WAY IDWAY FROM MAP_NODE N,MAP_WAY_NODE WN WHERE N.ID_NODE = WN.ID_NODE ORDER BY WN.NODE_ORDER) WHERE  IDWAY = W.ID_WAY) THE_GEOM ,W.ID_WAY FROM MAP_WAY W,MAP_BUILDINGS B WHERE W.ID_WAY = B.ID_WAY) GEOM_TABLE WHERE ST_GEOMETRYN(THE_GEOM,1) = ST_GEOMETRYN(THE_GEOM, ST_NUMGEOMETRIES(THE_GEOM)) AND ST_NUMGEOMETRIES(THE_GEOM) > 2;");
    }

    public String getJavaStaticMethod() {
        return "readOSM";
    }

    public static void readOSM(Connection connection, String fileName, String tableReference, boolean deleteTables) throws FileNotFoundException, SQLException, IOException {
        File file;
        if (deleteTables) {
            OSMTablesFactory.dropOSMTables(connection, JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData()), tableReference);
        }
        if (!(file = URIUtilities.fileFromString((String)fileName)).exists()) {
            throw new FileNotFoundException("The following file does not exists:\n" + fileName);
        }
        OSMDriverFunction osmdf = new OSMDriverFunction();
        osmdf.importFile(connection, tableReference, file, (ProgressVisitor)new EmptyProgressVisitor(), deleteTables);
    }

    public static void readOSM(Connection connection, String fileName, String tableReference) throws FileNotFoundException, SQLException, IOException {
        OSMRead.readOSM(connection, fileName, tableReference, false);
    }

    public static void readOSM(Connection connection, String fileName) throws FileNotFoundException, SQLException, IOException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase();
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        OSMRead.readOSM(connection, fileName, tableName);
    }
}

