/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJsonWriteDriver {
    private final Connection connection;
    private Map<String, Integer> cachedColumnNames;
    private int columnCountProperties = -1;

    public GeoJsonWriteDriver(Connection connection) {
        this.connection = connection;
    }

    public void write(ProgressVisitor progress, ResultSet resultSet, File file) throws SQLException, IOException {
        this.write(progress, resultSet, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProgressVisitor progress, ResultSet rs, File fileName, String encoding) throws SQLException, IOException {
        block20: {
            if (FileUtil.isExtensionWellFormated(fileName, "geojson")) {
                FileOutputStream fos = null;
                JsonEncoding jsonEncoding = JsonEncoding.UTF8;
                if (encoding != null) {
                    try {
                        jsonEncoding = JsonEncoding.valueOf((String)encoding);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
                    }
                }
                try {
                    fos = new FileOutputStream(fileName);
                    int rowCount = 0;
                    int type = rs.getType();
                    if (type == 1004 || type == 1005) {
                        rs.last();
                        rowCount = rs.getRow();
                        rs.beforeFirst();
                    }
                    ProgressVisitor copyProgress = progress.subProcess(rowCount);
                    List spatialFieldNames = SFSUtilities.getGeometryFields((ResultSet)rs);
                    if (spatialFieldNames.isEmpty()) {
                        throw new SQLException("The resulset %s does not contain a geometry field");
                    }
                    JsonFactory jsonFactory = new JsonFactory();
                    JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("type", "FeatureCollection");
                    jsonGenerator.writeArrayFieldStart("features");
                    try {
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        int geoFieldIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)resultSetMetaData, (String)((String)spatialFieldNames.get(0)));
                        this.cacheMetadata(resultSetMetaData);
                        while (rs.next()) {
                            this.writeFeature(jsonGenerator, rs, geoFieldIndex);
                            copyProgress.endStep();
                        }
                        copyProgress.endOfProgress();
                        jsonGenerator.writeEndArray();
                        jsonGenerator.writeEndObject();
                        jsonGenerator.flush();
                        jsonGenerator.close();
                        break block20;
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new SQLException(ex);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            throw new SQLException("Only .geojson extension is supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ProgressVisitor progress, String tableName, File fileName, String encoding) throws SQLException, IOException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (!tableName.startsWith("(") || !tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
            ResultSet resultSet = ps.executeQuery();
            this.write(progress, resultSet, fileName, encoding);
            return;
        }
        if (!FileUtil.isExtensionWellFormated(fileName, "geojson")) throw new SQLException("Only .geojson extension is supported");
        JsonEncoding jsonEncoding = JsonEncoding.UTF8;
        if (encoding != null) {
            try {
                jsonEncoding = JsonEncoding.valueOf((String)encoding);
            }
            catch (IllegalArgumentException ex) {
                throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)tableName);
            if (recordCount <= 0) return;
            ProgressVisitor copyProgress = progress.subProcess(recordCount);
            TableLocation parse = TableLocation.parse((String)tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData()));
            List spatialFieldNames = SFSUtilities.getGeometryFields((Connection)this.connection, (TableLocation)parse);
            if (spatialFieldNames.isEmpty()) {
                throw new SQLException(String.format("The table %s does not contain a geometry field", tableName));
            }
            try (Statement st = this.connection.createStatement();){
                JsonFactory jsonFactory = new JsonFactory();
                JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("type", "FeatureCollection");
                this.writeCRS(jsonGenerator, SFSUtilities.getAuthorityAndSRID((Connection)this.connection, (TableLocation)parse, (String)((String)spatialFieldNames.get(0))));
                jsonGenerator.writeArrayFieldStart("features");
                try (ResultSet rs = st.executeQuery(String.format("select * from %s", tableName));){
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    int geoFieldIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)resultSetMetaData, (String)((String)spatialFieldNames.get(0)));
                    this.cacheMetadata(resultSetMetaData);
                    while (rs.next()) {
                        this.writeFeature(jsonGenerator, rs, geoFieldIndex);
                        copyProgress.endStep();
                    }
                    copyProgress.endOfProgress();
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeEndObject();
                    jsonGenerator.flush();
                    jsonGenerator.close();
                    return;
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    private void writeFeature(JsonGenerator jsonGenerator, ResultSet rs, int geoFieldIndex) throws IOException, SQLException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "Feature");
        this.writeGeometry((Geometry)rs.getObject(geoFieldIndex), jsonGenerator);
        this.writeProperties(jsonGenerator, rs);
        jsonGenerator.writeEndObject();
    }

    private void cacheMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.cachedColumnNames = new LinkedHashMap<String, Integer>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String fieldTypeName = resultSetMetaData.getColumnTypeName(i);
            if (fieldTypeName.equalsIgnoreCase("geometry") || !this.isSupportedPropertyType(resultSetMetaData.getColumnType(i), fieldTypeName)) continue;
            this.cachedColumnNames.put(resultSetMetaData.getColumnName(i).toUpperCase(), i);
            ++this.columnCountProperties;
        }
    }

    private void writeGeometry(Geometry geom, JsonGenerator gen) throws IOException {
        if (geom != null) {
            gen.writeObjectFieldStart("geometry");
            if (geom instanceof Point) {
                this.write((Point)geom, gen);
            } else if (geom instanceof MultiPoint) {
                this.write((MultiPoint)geom, gen);
            } else if (geom instanceof LineString) {
                this.write((LineString)geom, gen);
            } else if (geom instanceof MultiLineString) {
                this.write((MultiLineString)geom, gen);
            } else if (geom instanceof Polygon) {
                this.write((Polygon)geom, gen);
            } else if (geom instanceof MultiPolygon) {
                this.write((MultiPolygon)geom, gen);
            } else if (geom instanceof GeometryCollection) {
                this.write((GeometryCollection)geom, gen);
            } else {
                throw new RuntimeException("Unsupported Geomery type");
            }
            gen.writeEndObject();
        } else {
            gen.writeNullField("geometry");
        }
    }

    private void write(Point point, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Point");
        gen.writeFieldName("coordinates");
        this.writeCoordinate(point.getCoordinate(), gen);
    }

    private void write(MultiPoint points, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPoint");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(points.getCoordinates(), gen);
    }

    private void write(LineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "LineString");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(geom.getCoordinates(), gen);
    }

    private void write(MultiLineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiLineString");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            this.writeCoordinates(geom.getGeometryN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(GeometryCollection coll, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "GeometryCollection");
        gen.writeArrayFieldStart("geometries");
        for (int i = 0; i < coll.getNumGeometries(); ++i) {
            Geometry geom = coll.getGeometryN(i);
            gen.writeStartObject();
            if (geom instanceof Point) {
                this.write((Point)geom, gen);
            } else if (geom instanceof MultiPoint) {
                this.write((MultiPoint)geom, gen);
            } else if (geom instanceof LineString) {
                this.write((LineString)geom, gen);
            } else if (geom instanceof MultiLineString) {
                this.write((MultiLineString)geom, gen);
            } else if (geom instanceof Polygon) {
                this.write((Polygon)geom, gen);
            } else if (geom instanceof MultiPolygon) {
                this.write((MultiPolygon)geom, gen);
            } else if (geom instanceof GeometryCollection) {
                this.write((GeometryCollection)geom, gen);
            } else {
                throw new RuntimeException("Unsupported Geomery type");
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void write(Polygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Polygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        this.writeCoordinates(geom.getExteriorRing().getCoordinates(), gen);
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            this.writeCoordinates(geom.getInteriorRingN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(MultiPolygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPolygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon p = (Polygon)geom.getGeometryN(i);
            gen.writeStartArray();
            this.writeCoordinates(p.getExteriorRing().getCoordinates(), gen);
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                this.writeCoordinates(p.getInteriorRingN(j).getCoordinates(), gen);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
    }

    private void writeCoordinate(Coordinate coordinate, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(coordinate.x);
        gen.writeNumber(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            gen.writeNumber(coordinate.z);
        }
        gen.writeEndArray();
    }

    private void writeCoordinates(Coordinate[] coordinates, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Coordinate coord : coordinates) {
            this.writeCoordinate(coord, gen);
        }
        gen.writeEndArray();
    }

    private void writeProperties(JsonGenerator jsonGenerator, ResultSet rs) throws IOException, SQLException {
        if (this.columnCountProperties != -1) {
            jsonGenerator.writeObjectFieldStart("properties");
            for (Map.Entry<String, Integer> entry : this.cachedColumnNames.entrySet()) {
                String string = entry.getKey();
                string = string.toLowerCase();
                Integer fieldId = entry.getValue();
                if (rs.getObject(fieldId) instanceof Object[]) {
                    Object[] array = (Object[])rs.getObject(fieldId);
                    jsonGenerator.writeArrayFieldStart(string);
                    this.writeArray(jsonGenerator, array, true);
                    jsonGenerator.writeEndArray();
                    continue;
                }
                if (rs.getObject(fieldId) != null && rs.getObject(fieldId).equals("{}")) {
                    jsonGenerator.writeObjectFieldStart(string);
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (rs.getObject(fieldId) == "null") {
                    jsonGenerator.writeFieldName(string);
                    jsonGenerator.writeNull();
                    continue;
                }
                jsonGenerator.writeObjectField(string, rs.getObject(fieldId));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public boolean isSupportedPropertyType(int sqlTypeId, String sqlTypeName) throws SQLException {
        switch (sqlTypeId) {
            case -15: 
            case -6: 
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 1111: 
            case 2003: {
                return true;
            }
        }
        throw new SQLException("Field type not supported by GeoJSON driver: " + sqlTypeName);
    }

    private void writeCRS(JsonGenerator jsonGenerator, String[] authorityAndSRID) throws IOException {
        if (authorityAndSRID[1] != null) {
            jsonGenerator.writeObjectFieldStart("crs");
            jsonGenerator.writeStringField("type", "name");
            jsonGenerator.writeObjectFieldStart("properties");
            StringBuilder sb = new StringBuilder("urn:ogc:def:crs:");
            sb.append(authorityAndSRID[0]).append("::").append(authorityAndSRID[1]);
            jsonGenerator.writeStringField("name", sb.toString());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    private void writeArray(JsonGenerator jsonGenerator, Object[] array, boolean firstInHierarchy) throws IOException, SQLException {
        if (!firstInHierarchy) {
            jsonGenerator.writeStartArray();
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof Integer) {
                jsonGenerator.writeNumber(((Integer)array[i]).intValue());
                continue;
            }
            if (array[i] instanceof String) {
                if (array[i].equals("{}")) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeEndObject();
                    continue;
                }
                jsonGenerator.writeString((String)array[i]);
                continue;
            }
            if (array[i] instanceof Double) {
                jsonGenerator.writeNumber(((Double)array[i]).doubleValue());
                continue;
            }
            if (array[i] instanceof Boolean) {
                jsonGenerator.writeBoolean(((Boolean)array[i]).booleanValue());
                continue;
            }
            if (!(array[i] instanceof Object[])) continue;
            this.writeArray(jsonGenerator, (Object[])array[i], false);
        }
        if (!firstInHierarchy) {
            jsonGenerator.writeEndArray();
        }
    }
}

