/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2h2gis;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2h2gis.GeneratorH2gis;
import ch.ehi.ili2h2gis.H2gisColumnConverter;
import ch.ehi.ili2h2gis.H2gisIdGen;
import ch.ehi.ili2h2gis.H2gisMapping;
import java.io.File;
import java.text.ParseException;

public class H2gisMain
extends AbstractMain {
    @Override
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(H2gisColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorH2gis.class.getName());
        config.setJdbcDriver("org.h2.Driver");
        config.setIdGenerator(H2gisIdGen.class.getName());
        config.setIli2dbCustomStrategy(H2gisMapping.class.getName());
        config.setStrokeArcs("enable");
    }

    @Override
    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            @Override
            public String makeUrl(Config config) {
                if (config.getDbhost() == null && config.getDbfile() != null) {
                    return "jdbc:h2:file:" + new File(config.getDbfile()).getAbsolutePath();
                }
                if (config.getDbdatabase() != null) {
                    String host = config.getDbhost() != null ? config.getDbhost() : "localhost";
                    String port = config.getDbport() != null ? ":" + config.getDbport() : "";
                    return "jdbc:h2:tcp://" + host + port + "/" + config.getDbdatabase();
                }
                return null;
            }
        };
    }

    @Override
    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return null;
    }

    public static void main(String[] args) {
        new H2gisMain().domain(args);
    }

    @Override
    public String getAPP_NAME() {
        return "ili2h2gis";
    }

    @Override
    public String getDB_PRODUCT_NAME() {
        return "h2gis";
    }

    @Override
    public String getJAR_NAME() {
        return "ili2h2gis.jar";
    }

    @Override
    protected void printConnectOptions() {
        System.err.println("--dbfile path          The path to the database files. (file based db)");
        System.err.println("--dbhost  host         The host name of the server. Defaults to localhost. (server based db; optional)");
        System.err.println("--dbport  port         The port number the server is listening on. Defaults to 9092. (server based db; optional)");
        System.err.println("--dbdatabase database  The database name. (server based db)");
        System.err.println("--dbusr  username      User name to access database.");
        System.err.println("--dbpwd  password      Password of user used to access database.");
    }

    @Override
    protected void printSpecificOptions() {
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
        System.err.println("--oneGeomPerTable      If more than one geometry per table, create secondary table.");
    }

    @Override
    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbhost")) {
            config.setDbhost(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbport")) {
            config.setDbport(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbdatabase")) {
            config.setDbdatabase(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbfile")) {
            config.setDbfile(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbusr")) {
            config.setDbusr(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbpwd")) {
            config.setDbpwd(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbschema")) {
            config.setDbschema(args[++argi]);
            ++argi;
        } else if (this.isOption(arg, "--oneGeomPerTable")) {
            config.setOneGeomPerTable(this.parseBooleanArgument(arg));
            ++argi;
        }
        return argi;
    }
}

