/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_IsRing
extends DeterministicScalarFunction {
    public ST_IsRing() {
        this.addProperty("remarks", "Return TRUE if the provided geometry is a closed and simple LINESTRING or MULTILINESTRING; NULL otherwise.");
    }

    public String getJavaStaticMethod() {
        return "isRing";
    }

    public static Boolean isRing(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString mString = (MultiLineString)geometry;
            return mString.isClosed() && mString.isSimple();
        }
        if (geometry instanceof LineString) {
            LineString line = (LineString)geometry;
            return line.isClosed() && geometry.isSimple();
        }
        return null;
    }
}

